/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.archive;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

@EditorFor(value=Parameters.class)
public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    private String mimeType;
    private String fileNames;
    private String configIds;

    public Parameters() {
        this.reset();
        this.toString();
    }

    @Override
    public void reset() {
        this.mimeType = "application/x-archive";
        this.fileNames = "";
        this.configIds = "";
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.mimeType = this.buffer.getString("mimeType", this.mimeType);
        this.fileNames = this.buffer.getString("fileNames", this.fileNames);
        this.configIds = this.buffer.getString("configIds", this.configIds);
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setString("mimeType", this.mimeType);
        this.buffer.setString("fileNames", this.fileNames);
        this.buffer.setString("configIds", this.configIds);
        return this.buffer.toString();
    }

    public void setFileNames(String fileNames) {
        this.fileNames = fileNames;
    }

    public String getFileNames() {
        return this.fileNames;
    }

    public void setConfigIds(String configIds) {
        this.configIds = configIds;
    }

    public String getConfigIds() {
        return this.configIds;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add("mimeType", "MIME type of the filter's container format", null);
        desc.add("fileNames", "File names", "Comma-delimited list of file names to be processed (wildcards are allowed) in the same order as configuration ids");
        desc.add("configIds", "Filter configuration ids", "Comma-delimited list of configuration ids corresponding to the file names");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription parametersDescription) {
        EditorDescription desc = new EditorDescription("Archive Filter Parameters", true, false);
        desc.addTextInputPart(parametersDescription.get("mimeType"));
        desc.addTextInputPart(parametersDescription.get("fileNames"));
        desc.addTextInputPart(parametersDescription.get("configIds"));
        return desc;
    }
}

