/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.doxygen;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiFileNotFoundException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonPart;
import net.sf.okapi.common.skeleton.ISkeletonWriter;

public class DoxygenWriter
implements IFilterWriter {
    private static final String SELF_REF = "$self$";
    private static final String DUMMY_SKELETON = String.format("%s%s%s", "[#$", "$self$", "]");
    private OutputStream output;
    private String outputPath;
    private OutputStreamWriter writer;
    private LocaleId language;
    private String encoding;
    private String linebreak;
    private File tempFile;
    private GenericContent formatter = new GenericContent();
    private StringBuilder commentBuffer = new StringBuilder();
    private HashMap<String, String> referencedText = new HashMap();
    private List<GenericSkeletonPart> skeletonParts;
    private static String LINEBREAK_PATTERN_TEMPLATE = "(?<=%s)";
    private Pattern linebreakPattern;
    private int numLines;

    @Override
    public String getName() {
        return "DoxygenWriter";
    }

    @Override
    public void setOptions(LocaleId language, String defaultEncoding) {
        this.language = language;
        this.encoding = defaultEncoding;
    }

    @Override
    public void setOutput(String path) {
        this.close();
        this.outputPath = path;
    }

    @Override
    public void setOutput(OutputStream output) {
        this.close();
        this.outputPath = null;
        this.output = output;
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                this.processStartDocument(event);
                break;
            }
            case END_DOCUMENT: {
                this.processEndDocument();
                break;
            }
            case START_GROUP: {
                this.processStartGroup(event);
                break;
            }
            case END_GROUP: {
                this.processEndGroup();
                break;
            }
            case TEXT_UNIT: {
                this.processTextUnit(event);
                break;
            }
            case DOCUMENT_PART: {
                this.processDocumentPart(event);
                break;
            }
            default: {
                event = Event.NOOP_EVENT;
            }
        }
        return event;
    }

    private void processEndGroup() {
        String[] commentLines = this.linebreakPattern.split(this.commentBuffer.toString());
        this.commentBuffer = new StringBuilder();
        try {
            int wroteLines;
            for (int i = 0; i < commentLines.length || i < this.skeletonParts.size(); ++i) {
                if (i < this.skeletonParts.size()) {
                    this.writer.write(this.skeletonParts.get(i).toString());
                }
                if (i < commentLines.length) {
                    this.writer.write(commentLines[i]);
                }
                if (i < commentLines.length || i >= this.skeletonParts.size()) continue;
                this.writer.write(this.linebreak);
            }
            for (int i = wroteLines = commentLines.length > this.skeletonParts.size() ? commentLines.length : this.skeletonParts.size(); i < this.numLines; ++i) {
                this.writer.write(this.linebreak);
            }
        }
        catch (IOException e) {
            throw new OkapiIOException("Error writing a Doxygen-commented file.", e);
        }
    }

    private void processStartGroup(Event event) {
        StartGroup group = event.getStartGroup();
        this.skeletonParts = ((GenericSkeleton)group.getSkeleton()).getParts();
        Property prop = group.getProperty("numLines");
        this.numLines = prop != null ? Integer.parseInt(prop.getValue()) : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.writer == null) {
            return;
        }
        IOException err = null;
        InputStream orig = null;
        OutputStream dest = null;
        try {
            this.writer.close();
            this.writer = null;
            this.output.close();
            this.output = null;
            if (this.tempFile != null) {
                int len;
                dest = new FileOutputStream(this.outputPath);
                orig = new FileInputStream(this.tempFile);
                byte[] buffer = new byte[2048];
                while ((len = orig.read(buffer)) > 0) {
                    dest.write(buffer, 0, len);
                }
            }
        }
        catch (IOException e) {
            err = e;
        }
        finally {
            if (dest != null) {
                try {
                    dest.close();
                }
                catch (IOException e) {
                    err = e;
                }
                dest = null;
            }
            if (orig != null) {
                try {
                    orig.close();
                }
                catch (IOException e) {
                    err = e;
                }
                orig = null;
                if (err != null) {
                    throw new RuntimeException(err);
                }
                if (this.tempFile != null) {
                    this.tempFile.delete();
                    this.tempFile = null;
                }
            }
        }
    }

    @Override
    public IParameters getParameters() {
        return null;
    }

    @Override
    public void setParameters(IParameters params) {
    }

    @Override
    public void cancel() {
    }

    @Override
    public EncoderManager getEncoderManager() {
        return null;
    }

    @Override
    public ISkeletonWriter getSkeletonWriter() {
        return null;
    }

    private void createWriter(StartDocument startDoc) {
        this.linebreak = startDoc.getLineBreak();
        this.linebreakPattern = Pattern.compile(String.format(LINEBREAK_PATTERN_TEMPLATE, this.linebreak));
        try {
            String originalEnc;
            this.tempFile = null;
            if (this.output == null) {
                boolean useTemp = false;
                File f = new File(this.outputPath);
                if (f.exists()) {
                    boolean bl = useTemp = !f.delete();
                }
                if (useTemp) {
                    this.tempFile = File.createTempFile("vrszwTmp", null);
                    this.output = new BufferedOutputStream(new FileOutputStream(this.tempFile.getAbsolutePath()));
                } else {
                    Util.createDirectories(this.outputPath);
                    this.output = new BufferedOutputStream(new FileOutputStream(this.outputPath));
                }
            }
            if ((originalEnc = startDoc.getEncoding()) == null) {
                originalEnc = Charset.defaultCharset().name();
            }
            if (this.encoding == null) {
                this.encoding = originalEnc;
            }
            this.writer = new OutputStreamWriter(this.output, this.encoding);
            boolean useUTF8BOM = false;
            if ("utf-8".equalsIgnoreCase(this.encoding) && "utf-8".equalsIgnoreCase(originalEnc)) {
                useUTF8BOM = false;
            }
            Util.writeBOMIfNeeded(this.writer, useUTF8BOM, this.encoding);
        }
        catch (FileNotFoundException e) {
            throw new OkapiFileNotFoundException(e);
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    private void processStartDocument(Event event) {
        StartDocument sd = event.getStartDocument();
        this.createWriter(sd);
        this.referencedText.clear();
    }

    private void processEndDocument() {
        this.close();
    }

    private void processTextUnit(Event event) {
        ITextUnit tu = event.getTextUnit();
        GenericSkeleton skel = (GenericSkeleton)tu.getSkeleton();
        StringBuilder tuText = new StringBuilder();
        tuText.append(skel != null ? skel.toString() : DUMMY_SKELETON);
        TextContainer bodyContainer = null;
        bodyContainer = tu.hasTarget(this.language) ? tu.getTarget(this.language) : tu.getSource();
        this.referencedText.put(SELF_REF, this.formatter.printSegmentedContent(bodyContainer, false, true));
        Object[] refMarkInfo = TextFragment.getRefMarker(tuText);
        while (refMarkInfo != null) {
            assert (this.referencedText.containsKey(refMarkInfo[0]));
            tuText.replace((Integer)refMarkInfo[1], (Integer)refMarkInfo[2], this.referencedText.get(refMarkInfo[0]));
            refMarkInfo = TextFragment.getRefMarker(tuText);
        }
        if (tu.getReferenceCount() > 0) {
            this.referencedText.put(tu.getId(), tuText.toString());
            return;
        }
        this.commentBuffer.append((CharSequence)tuText);
    }

    private void processDocumentPart(Event event) {
        try {
            DocumentPart part = event.getDocumentPart();
            this.writer.write(part.toString());
        }
        catch (IOException e) {
            throw new OkapiIOException("Error writing a Doxygen-commented file.", e);
        }
    }

    private List<String> splitText(String s, int lines) {
        ArrayList<String> parts = new ArrayList<String>();
        int stride = s.length() / lines + s.length() % lines;
        for (int i = 0; i < lines; ++i) {
            int start = i * stride;
            int end = Math.min((i + 1) * stride, s.length());
            parts.add(s.substring(start, end));
        }
        return parts;
    }
}

