/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.SpinInputPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    private static final String EXTRACTNOTES = "extractNotes";
    private static final String SIMPLIFYCODES = "simplifyCodes";
    private static final String EXTRACTMASTERSPREADS = "extractMasterSpreads";
    private static final String SKIPTHRESHOLD = "skipThreshold";
    private static final String NEWTUONBR = "newTuOnBr";
    private static final String EXTRACTHIDDENLAYERS = "extractHiddenLayers";
    private boolean extractNotes;
    private boolean simplifyCodes;
    private boolean extractMasterSpreads;
    private int skipThreshold;
    private boolean newTuOnBr;
    private boolean extractHiddenLayers;

    public Parameters() {
        this.reset();
        this.toString();
    }

    @Override
    public void reset() {
        this.extractNotes = false;
        this.simplifyCodes = true;
        this.extractMasterSpreads = true;
        this.skipThreshold = 1000;
        this.newTuOnBr = false;
        this.extractHiddenLayers = false;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.extractNotes = this.buffer.getBoolean(EXTRACTNOTES, this.extractNotes);
        this.simplifyCodes = this.buffer.getBoolean(SIMPLIFYCODES, this.simplifyCodes);
        this.extractMasterSpreads = this.buffer.getBoolean(EXTRACTMASTERSPREADS, this.extractMasterSpreads);
        this.skipThreshold = this.buffer.getInteger(SKIPTHRESHOLD, this.skipThreshold);
        this.newTuOnBr = this.buffer.getBoolean(NEWTUONBR, this.newTuOnBr);
        this.extractHiddenLayers = this.buffer.getBoolean(EXTRACTHIDDENLAYERS, this.extractHiddenLayers);
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setBoolean(EXTRACTNOTES, this.extractNotes);
        this.buffer.setBoolean(SIMPLIFYCODES, this.simplifyCodes);
        this.buffer.setBoolean(EXTRACTMASTERSPREADS, this.extractMasterSpreads);
        this.buffer.setInteger(SKIPTHRESHOLD, this.skipThreshold);
        this.buffer.setBoolean(NEWTUONBR, this.newTuOnBr);
        this.buffer.setBoolean(EXTRACTHIDDENLAYERS, this.extractHiddenLayers);
        return this.buffer.toString();
    }

    public boolean getExtractNotes() {
        return this.extractNotes;
    }

    public void setExtractNotes(boolean extractNotes) {
        this.extractNotes = extractNotes;
    }

    public boolean getSimplifyCodes() {
        return this.simplifyCodes;
    }

    public void setSimplifyCodes(boolean simplifyCodes) {
        this.simplifyCodes = simplifyCodes;
    }

    public boolean getExtractMasterSpreads() {
        return this.extractMasterSpreads;
    }

    public void setExtractMasterSpreads(boolean extractMasterSpreads) {
        this.extractMasterSpreads = extractMasterSpreads;
    }

    public int getSkipThreshold() {
        return this.skipThreshold;
    }

    public void setSkipThreshold(int skipThreshold) {
        this.skipThreshold = skipThreshold;
    }

    public boolean getNewTuOnBr() {
        return this.newTuOnBr;
    }

    public void setNewTuOnBr(boolean newTuOnBr) {
        this.newTuOnBr = newTuOnBr;
    }

    public boolean getExtractHiddenLayers() {
        return this.extractHiddenLayers;
    }

    public void setExtractHiddenLayers(boolean extractHiddenLayers) {
        this.extractHiddenLayers = extractHiddenLayers;
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(EXTRACTNOTES, "Extract notes", null);
        desc.add(EXTRACTMASTERSPREADS, "Extract master spreads", null);
        desc.add(EXTRACTHIDDENLAYERS, "Extract hidden layers", null);
        desc.add(SIMPLIFYCODES, "Simplify inline codes when possible", null);
        desc.add(NEWTUONBR, "Create new paragraphs on hard returns [IMPORTANT: STILL BETA! May prevent merge!]", "Option is BETA and may prevent you to merge back. Make sure to test round-trip!");
        desc.add(SKIPTHRESHOLD, "Maximum spread size", "Skip any spread larger than the given value (in Kbytes)");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("IDML Filter", true, false);
        desc.addCheckboxPart(paramsDesc.get(EXTRACTNOTES));
        desc.addCheckboxPart(paramsDesc.get(EXTRACTMASTERSPREADS));
        desc.addCheckboxPart(paramsDesc.get(EXTRACTHIDDENLAYERS));
        desc.addSeparatorPart();
        desc.addCheckboxPart(paramsDesc.get(SIMPLIFYCODES));
        desc.addCheckboxPart(paramsDesc.get(NEWTUONBR));
        desc.addSeparatorPart();
        SpinInputPart sip = desc.addSpinInputPart(paramsDesc.get(SKIPTHRESHOLD));
        sip.setRange(1, 32000);
        return desc;
    }
}

