/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.EndTagType;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.StartTagType;
import net.htmlparser.jericho.StreamedSource;
import net.htmlparser.jericho.Tag;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.filters.abstractmarkup.ExtractionRuleState;
import net.sf.okapi.filters.openxml.OpenXMLContentFilter;
import net.sf.okapi.filters.openxml.YamlParameters;
import net.sf.okapi.filters.yaml.TaggedFilterConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelAnalyzer {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private ZipFile zipFile;
    private ZipEntry entry;
    private Enumeration<? extends ZipEntry> entries;
    private InputStream is;
    private TreeMap<Integer, Point> tmCells;
    private TreeSet<String> tsColors;
    private ExtractionRuleState ruleState;
    private YamlParameters parameters;
    private Iterator<Segment> nodeIterator;
    private StreamedSource document;

    public ExcelAnalyzer(URI zipURI) {
        try {
            File fZip = new File(zipURI.getPath());
            this.zipFile = new ZipFile(fZip);
        }
        catch (IOException e) {
            this.LOGGER.warn("Error opening zipped Excel file.");
            throw new OkapiIOException("Error opening zipped Excel file.");
        }
    }

    public ExcelAnalyzer(ZipFile zipFile) {
        this.zipFile = zipFile;
    }

    public TreeMap<Integer, Point> analyzeExcelGetSheetSizes() {
        this.tmCells = new TreeMap();
        this.entries = this.zipFile.entries();
        while (this.entries.hasMoreElements()) {
            this.entry = this.entries.nextElement();
            String sEntryName = this.entry.getName();
            int iCute = sEntryName.lastIndexOf(47);
            if (iCute > -1) {
                sEntryName = sEntryName.substring(iCute + 1);
            }
            if (!sEntryName.substring(0, 5).equals("sheet")) continue;
            this.nodeIterator = this.createNodeIterator(this.entry);
            while (this.nodeIterator.hasNext()) {
                Segment segment = this.nodeIterator.next();
                if (!(segment instanceof Tag)) continue;
                Tag tag = (Tag)segment;
                if (!this.parameters.getTaggedConfig().getElementRuleTypeCandidate(tag.getName()).equals("ATTRIBUTES_ONLY") || !tag.getName().equals("dimension")) continue;
                for (Attribute attribute : tag.parseAttributes()) {
                    if (!attribute.getName().equals("ref")) continue;
                    String sDim = attribute.getValue();
                    iCute = sEntryName.indexOf(46);
                    if (iCute <= -1) continue;
                    String sNum = sEntryName.substring(5, iCute);
                    Integer ii = new Integer(sNum);
                    String[] sDims = sDim.split(":");
                    int y = this.getNumberOfRows(sDims[1]);
                    int x = this.getNumberOfColumns(sDims[1]);
                    this.tmCells.put(ii, new Point(x, y));
                }
            }
        }
        this.closeInput();
        return this.tmCells;
    }

    private int getNumberOfRows(String s) {
        int rslt = 0;
        String goomer = "0123456789";
        if (s != null) {
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                int ndx = goomer.indexOf(s.charAt(i));
                if (ndx <= -1) continue;
                try {
                    rslt = new Integer(s.substring(ndx));
                }
                catch (Exception e) {}
                break;
            }
        }
        return rslt;
    }

    private int getNumberOfColumns(String s) {
        int rslt = 0;
        String goomer = "0123456789";
        if (s != null) {
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                int ndx = goomer.indexOf(s.charAt(i));
                if (ndx <= -1) continue;
                String col = s.substring(0, i);
                len = col.length();
                if (len == 1) {
                    rslt = Character.digit(col.charAt(0), 10) - 48;
                    break;
                }
                if (len != 2) break;
                rslt = Character.digit(col.charAt(1), 10) - 64 + 26 * (Character.digit(col.charAt(1), 10) - 65) + 26;
                break;
            }
        }
        return rslt;
    }

    public TreeSet analyzeExcelGetNonThemeColors() {
        this.tsColors = new TreeSet();
        this.entries = this.zipFile.entries();
        while (this.entries.hasMoreElements()) {
            this.entry = this.entries.nextElement();
            String sEntryName = this.entry.getName();
            int iCute = sEntryName.lastIndexOf(47);
            if (iCute > -1) {
                sEntryName = sEntryName.substring(iCute + 1);
            }
            if (!sEntryName.equals("styles.xml")) continue;
            this.nodeIterator = this.createNodeIterator(this.entry);
            TaggedFilterConfiguration tfc = this.parameters.getTaggedConfig();
            while (this.nodeIterator.hasNext()) {
                Tag tag;
                Segment segment = this.nodeIterator.next();
                if (!(segment instanceof Tag) || tfc.getElementRuleTypeCandidate((tag = (Tag)segment).getName()) != TaggedFilterConfiguration.RULE_TYPE.ATTRIBUTES_ONLY || !tag.getName().equals("color")) continue;
                for (Attribute attribute : tag.parseAttributes()) {
                    if (!attribute.getName().equals("rgb")) continue;
                    String sColor = attribute.getValue();
                    this.tsColors.add(sColor);
                }
            }
            this.closeInput();
            break;
        }
        return this.tsColors;
    }

    public TreeSet analyzeExcelGetStylesOfExcludedColors(TreeSet tsExcludedColors) {
        int nCurrentFont = 0;
        int nCurrentStyle = 0;
        boolean bXfing = false;
        TreeSet<String> tsStyles = new TreeSet<String>();
        if (tsExcludedColors.size() == 0) {
            return tsStyles;
        }
        this.tsColors = new TreeSet();
        this.entries = this.zipFile.entries();
        boolean[] bFonts = new boolean[1];
        while (this.entries.hasMoreElements()) {
            this.entry = this.entries.nextElement();
            String sEntryName = this.entry.getName();
            int iCute = sEntryName.lastIndexOf(47);
            if (iCute > -1) {
                sEntryName = sEntryName.substring(iCute + 1);
            }
            if (!sEntryName.equals("styles.xml")) continue;
            this.nodeIterator = this.createNodeIterator(this.entry);
            TaggedFilterConfiguration tfc = this.parameters.getTaggedConfig();
            while (this.nodeIterator.hasNext()) {
                Segment segment = this.nodeIterator.next();
                if (!(segment instanceof Tag)) continue;
                Tag tag = (Tag)segment;
                String sTagName = tag.getName();
                TaggedFilterConfiguration.RULE_TYPE rtRuleType = tfc.getElementRuleTypeCandidate(sTagName);
                if (tag.getTagType() == StartTagType.NORMAL || tag.getTagType() == StartTagType.UNREGISTERED) {
                    if (rtRuleType == TaggedFilterConfiguration.RULE_TYPE.ATTRIBUTES_ONLY) {
                        if (tag.getName().equals("color")) {
                            for (Attribute attribute : tag.parseAttributes()) {
                                String sColor;
                                if (!attribute.getName().equals("rgb") || !tsExcludedColors.contains(sColor = attribute.getValue())) continue;
                                bFonts[nCurrentFont - 1] = true;
                            }
                            continue;
                        }
                        if (sTagName.equals("fonts")) {
                            for (Attribute attribute : tag.parseAttributes()) {
                                if (attribute.getName().equals("count")) {
                                    String sCount = attribute.getValue();
                                    int nFontTotal = new Integer(sCount);
                                    bFonts = new boolean[nFontTotal];
                                    for (int i = 0; i < nFontTotal; ++i) {
                                        bFonts[i] = false;
                                    }
                                }
                                nCurrentFont = 0;
                            }
                            continue;
                        }
                        if (!sTagName.equals("xf") || !bXfing) continue;
                        ++nCurrentStyle;
                        for (Attribute attribute : tag.parseAttributes()) {
                            String sFontNum;
                            int nThisFont;
                            String sAttName = attribute.getName();
                            if (!sAttName.equals("fontId") || !bFonts[nThisFont = new Integer(sFontNum = attribute.getValue()).intValue()]) continue;
                            tsStyles.add(new Integer(nCurrentStyle - 1).toString());
                        }
                        continue;
                    }
                    if (rtRuleType != TaggedFilterConfiguration.RULE_TYPE.INLINE_ELEMENT) continue;
                    if (sTagName.equals("font")) {
                        ++nCurrentFont;
                    }
                    if (!sTagName.equals("cellxfs")) continue;
                    bXfing = true;
                    continue;
                }
                if (tag.getTagType() != EndTagType.NORMAL && tag.getTagType() != EndTagType.UNREGISTERED || rtRuleType != TaggedFilterConfiguration.RULE_TYPE.INLINE_ELEMENT || !sTagName.equals("cellxfs")) continue;
                bXfing = false;
            }
            this.closeInput();
            break;
        }
        return tsStyles;
    }

    public int analyzeExcelGetSharedStringsCount() {
        int rslt = 0;
        this.entries = this.zipFile.entries();
        while (this.entries.hasMoreElements()) {
            this.entry = this.entries.nextElement();
            String sEntryName = this.entry.getName();
            int iCute = sEntryName.lastIndexOf(47);
            if (iCute > -1) {
                sEntryName = sEntryName.substring(iCute + 1);
            }
            if (!sEntryName.equals("sharedStrings.xml")) continue;
            this.setupSharedStringsReader(this.entry);
            TaggedFilterConfiguration tfc = this.parameters.getTaggedConfig();
            while (this.nodeIterator.hasNext()) {
                Tag tag;
                String sTagName;
                TaggedFilterConfiguration.RULE_TYPE rtRuleType;
                Segment segment = this.nodeIterator.next();
                if (!(segment instanceof Tag) || (rtRuleType = tfc.getElementRuleTypeCandidate(sTagName = (tag = (Tag)segment).getName())) != TaggedFilterConfiguration.RULE_TYPE.INLINE_ELEMENT || !tag.getName().equals("sst")) continue;
                for (Attribute attribute : tag.parseAttributes()) {
                    String sCount;
                    if (attribute.getName().equals("count")) {
                        sCount = attribute.getValue();
                        if (rslt != 0) continue;
                        rslt = new Integer(sCount);
                        continue;
                    }
                    if (!attribute.getName().equals("uniqueCount")) continue;
                    sCount = attribute.getValue();
                    rslt = new Integer(sCount);
                }
                if (rslt <= 0) continue;
                break;
            }
            this.closeInput();
            break;
        }
        return rslt;
    }

    private void setupSharedStringsReader(ZipEntry entry) {
        try {
            this.is = this.zipFile.getInputStream(entry);
            URL urlConfig = OpenXMLContentFilter.class.getResource("/net/sf/okapi/filters/openxml/excelConfiguration.yml");
            this.parameters = new YamlParameters(urlConfig);
            this.ruleState = new ExtractionRuleState(true, false);
            this.document = new StreamedSource(new InputStreamReader(this.is, "UTF-8"));
            this.nodeIterator = this.document.iterator();
        }
        catch (IOException e) {
            this.LOGGER.warn("Error opening XML file within zipped Excel file.");
            throw new OkapiIOException("Error opening XML file within zipped Excel file.");
        }
    }

    private Iterator<Segment> createNodeIterator(ZipEntry ntry) {
        try {
            URL urlConfig = OpenXMLContentFilter.class.getResource("/net/sf/okapi/filters/openxml/excelStylesConfiguration.yml");
            this.parameters = new YamlParameters(urlConfig);
            this.ruleState = new ExtractionRuleState(true, false);
            this.is = this.zipFile.getInputStream(ntry);
            this.document = new StreamedSource(new InputStreamReader(this.is));
        }
        catch (IOException e) {
            OkapiIOException re = new OkapiIOException(e);
            throw new OkapiIOException("Filter could not open input stream");
        }
        return this.document.iterator();
    }

    private void closeInput() {
        try {
            this.is.close();
        }
        catch (IOException e) {
            this.LOGGER.warn("Error opening zipped Excel file.");
            throw new OkapiIOException("Error opening zipped Excel file.");
        }
        finally {
            this.is = null;
        }
    }
}

