/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.pensieve;

import java.io.File;
import java.io.OutputStream;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiNotImplementedException;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.tm.pensieve.common.PensieveUtil;
import net.sf.okapi.tm.pensieve.common.TranslationUnit;
import net.sf.okapi.tm.pensieve.common.TranslationUnitVariant;
import net.sf.okapi.tm.pensieve.writer.ITmWriter;
import net.sf.okapi.tm.pensieve.writer.TmWriterFactory;

public class PensieveFilterWriter
implements IFilterWriter {
    private ITmWriter writer;
    private String directory;
    private LocaleId srcLoc;
    private LocaleId trgLoc;
    private boolean overwriteSameSource = false;

    @Override
    public void cancel() {
    }

    @Override
    public void close() {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    @Override
    public String getName() {
        return "PensieveFilterWriter";
    }

    @Override
    public EncoderManager getEncoderManager() {
        return null;
    }

    @Override
    public ISkeletonWriter getSkeletonWriter() {
        return null;
    }

    @Override
    public IParameters getParameters() {
        return null;
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                this.handleStartDocument(event);
                break;
            }
            case TEXT_UNIT: {
                this.handleTextUnit(event);
                break;
            }
            case END_DOCUMENT: {
                this.close();
            }
        }
        return event;
    }

    @Override
    public void setOptions(LocaleId locale, String defaultEncoding) {
        this.trgLoc = locale;
    }

    @Override
    public void setOutput(String path) {
        File f = new File(path);
        this.directory = f.getAbsolutePath();
    }

    public void setOverwriteSameSource(boolean overwriteSameSource) {
        this.overwriteSameSource = overwriteSameSource;
    }

    @Override
    public void setOutput(OutputStream output) {
        throw new OkapiNotImplementedException("Output type not supported.");
    }

    @Override
    public void setParameters(IParameters params) {
    }

    private void handleStartDocument(Event event) {
        Util.createDirectories(this.directory + File.separator);
        File file = new File(this.directory + File.separator + "segments.gen");
        this.writer = TmWriterFactory.createFileBasedTmWriter(this.directory, !file.exists());
        StartDocument sd = (StartDocument)event.getResource();
        this.srcLoc = sd.getLocale();
    }

    private void handleTextUnit(Event event) {
        ITextUnit tu = event.getTextUnit();
        if (!tu.hasTarget(this.trgLoc)) {
            return;
        }
        TextContainer srcCont = tu.getSource();
        TextContainer trgCont = tu.getTarget(this.trgLoc);
        if (srcCont.contentIsOneSegment() && trgCont.contentIsOneSegment()) {
            this.writer.indexTranslationUnit(PensieveUtil.convertToTranslationUnit(this.srcLoc, this.trgLoc, tu), this.overwriteSameSource);
            return;
        }
        if (trgCont.getSegments().count() != srcCont.getSegments().count()) {
            TranslationUnitVariant source = new TranslationUnitVariant(this.srcLoc, srcCont.getUnSegmentedContentCopy());
            TranslationUnitVariant target = new TranslationUnitVariant(this.trgLoc, trgCont.getUnSegmentedContentCopy());
            TranslationUnit trUnit = new TranslationUnit(source, target);
            this.writer.indexTranslationUnit(trUnit, this.overwriteSameSource);
            return;
        }
        ISegments trgSegs = trgCont.getSegments();
        for (Segment srcSeg : srcCont.getSegments()) {
            Segment trgSeg = trgSegs.get(srcSeg.id);
            if (trgSeg == null || !trgSeg.getContent().hasText()) continue;
            TranslationUnitVariant source = new TranslationUnitVariant(this.srcLoc, srcSeg.text);
            TranslationUnitVariant target = new TranslationUnitVariant(this.trgLoc, trgSeg.text);
            TranslationUnit trUnit = new TranslationUnit(source, target);
            this.writer.indexTranslationUnit(trUnit, this.overwriteSameSource);
        }
    }
}

