/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.php;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.filters.InlineCodeFinder;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.CodeFinderPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

@EditorFor(value=Parameters.class)
public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    static final String USECODEFINDER = "useCodeFinder";
    static final String CODEFINDERRULES = "codeFinderRules";
    static final String USEDIRECTIVES = "useDirectives";
    static final String EXTRACTOUTSIDEDIRECTIVES = "extractOutsideDirectives";
    private boolean useCodeFinder;
    private InlineCodeFinder codeFinder = new InlineCodeFinder();
    private boolean useDirectives;
    private boolean extractOutsideDirectives;

    public Parameters() {
        this.reset();
        this.toString();
    }

    public InlineCodeFinder getCodeFinder() {
        return this.codeFinder;
    }

    public boolean getUseCodeFinder() {
        return this.useCodeFinder;
    }

    public void setUseCodeFinder(boolean useCodeFinder) {
        this.useCodeFinder = useCodeFinder;
    }

    public String getCodeFinderRules() {
        return this.codeFinder.toString();
    }

    public void setCodeFinderRules(String codeFinderRules) {
        this.codeFinder.fromString(codeFinderRules);
    }

    public boolean getUseDirectives() {
        return this.useDirectives;
    }

    public void setUseDirectives(boolean useDirectives) {
        this.useDirectives = useDirectives;
    }

    public boolean getExtractOutsideDirectives() {
        return this.extractOutsideDirectives;
    }

    public void setExtractOutsideDirectives(boolean extractOutsideDirectives) {
        this.extractOutsideDirectives = extractOutsideDirectives;
    }

    @Override
    public void reset() {
        this.useDirectives = true;
        this.extractOutsideDirectives = true;
        this.useCodeFinder = true;
        this.codeFinder.reset();
        this.codeFinder.setSample("... attr='val'> text <br/> text \\n text <a att='val'> text [VAR1] text\n{VAR2} text <a att='val' ...");
        this.codeFinder.setUseAllRulesWhenTesting(true);
        this.codeFinder.addRule("(\\A[^<]*?>)|(<[\\w!?/].*?(>|\\Z))");
        this.codeFinder.addRule("\\\\a|\\\\b|\\\\f|\\\\n|\\\\r|\\\\t|\\\\v");
        this.codeFinder.addRule("(\\w[-._\\w]*\\w@\\w[-._\\w]*\\w\\.\\w{2,3})");
        this.codeFinder.addRule("[\\[{][\\w_$]+?[}\\]]");
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setBoolean(USEDIRECTIVES, this.useDirectives);
        this.buffer.setBoolean(EXTRACTOUTSIDEDIRECTIVES, this.extractOutsideDirectives);
        this.buffer.setBoolean(USECODEFINDER, this.useCodeFinder);
        this.buffer.setGroup(CODEFINDERRULES, this.codeFinder.toString());
        return this.buffer.toString();
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.useDirectives = this.buffer.getBoolean(USEDIRECTIVES, this.useDirectives);
        this.extractOutsideDirectives = this.buffer.getBoolean(EXTRACTOUTSIDEDIRECTIVES, this.extractOutsideDirectives);
        this.useCodeFinder = this.buffer.getBoolean(USECODEFINDER, this.useCodeFinder);
        this.codeFinder.fromString(this.buffer.getGroup(CODEFINDERRULES, ""));
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(USEDIRECTIVES, "Use localization directives", null);
        desc.add(EXTRACTOUTSIDEDIRECTIVES, "Extract outside the scope of the directives", null);
        desc.add(USECODEFINDER, "Has inline codes as defined below:", null);
        desc.add(CODEFINDERRULES, null, "Rules for inline codes");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("PHP Filter Parameters", true, false);
        CheckboxPart cbp1 = desc.addCheckboxPart(paramDesc.get(USEDIRECTIVES));
        CheckboxPart cbp2 = desc.addCheckboxPart(paramDesc.get(EXTRACTOUTSIDEDIRECTIVES));
        cbp2.setMasterPart(cbp1, true);
        cbp1 = desc.addCheckboxPart(paramDesc.get(USECODEFINDER));
        CodeFinderPart cfp = desc.addCodeFinderPart(paramDesc.get(CODEFINDERRULES));
        cfp.setMasterPart(cbp1, true);
        return desc;
    }
}

