/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.rainbowkit;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.FileUtil;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.MultiEvent;
import net.sf.okapi.common.resource.PipelineParameters;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.po.POFilter;
import net.sf.okapi.filters.rainbowkit.IManifestEditor;
import net.sf.okapi.filters.rainbowkit.Manifest;
import net.sf.okapi.filters.rainbowkit.MergingInfo;
import net.sf.okapi.filters.rainbowkit.Parameters;
import net.sf.okapi.filters.rtf.RTFFilter;
import net.sf.okapi.filters.transtable.TransTableFilter;
import net.sf.okapi.filters.versifiedtxt.VersifiedTextFilter;
import net.sf.okapi.filters.xini.rainbowkit.XINIRainbowkitFilter;
import net.sf.okapi.filters.xliff.XLIFFFilter;
import net.sf.okapi.lib.transifex.TransifexClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class RainbowKitFilter
implements IFilter {
    public static final String RAINBOWKIT_MIME_TYPE = "application/x-rainbowkit";
    public static final String RAINBOWKIT_PACKAGE_MIME_TYPE = "application/x-rainbowkit-package";
    public static final String RAINBOWKIT_PACKAGE_EXTENSION = ".rkp";
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private Parameters params = new Parameters();
    private boolean canceled;
    private boolean hasNext;
    private LinkedList<Event> queue;
    private Manifest manifest;
    private MergingInfo info;
    private Iterator<Integer> iter;
    private IFilter filter;
    private RTFFilter rtfFilter;
    private boolean hasMoreDoc;
    private TransifexClient cli;

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public void close() {
        if (this.filter != null) {
            this.filter.close();
            this.filter = null;
        }
        if (this.rtfFilter != null) {
            this.rtfFilter.close();
            this.rtfFilter = null;
        }
    }

    @Override
    public String getName() {
        return "okf_rainbowkit";
    }

    @Override
    public String getDisplayName() {
        return "Rainbow Translation Kit Filter";
    }

    @Override
    public String getMimeType() {
        return RAINBOWKIT_MIME_TYPE;
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration(this.getName(), RAINBOWKIT_MIME_TYPE, this.getClass().getName(), "Rainbow Translation Kit", "Configuration for Rainbow translation kit.", null, ".rkm;"));
        list.add(new FilterConfiguration(this.getName() + "-package", RAINBOWKIT_PACKAGE_MIME_TYPE, this.getClass().getName(), "Rainbow Translation Kit Package", "Configuration for Rainbow translation kit package.", null, ".rkp;"));
        list.add(new FilterConfiguration(this.getName() + "-noprompt", RAINBOWKIT_MIME_TYPE, this.getClass().getName(), "Rainbow Translation Kit (No prompt)", "Configuration for Rainbow translation kit (without prompt).", "noprompt.fprm", ".rkm;"));
        return list;
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.filter != null) {
            return this.filter.getEncoderManager();
        }
        return null;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public Event next() {
        try {
            if (this.canceled) {
                this.queue.clear();
                this.queue.add(new Event(EventType.CANCELED));
                this.hasNext = false;
            }
            if (this.queue.isEmpty()) {
                this.nextEventInDocument(false);
                if (!this.hasMoreDoc) {
                    this.hasNext = false;
                    this.queue.add(Event.NOOP_EVENT);
                }
            }
            return this.queue.poll();
        }
        catch (Throwable e) {
            throw new OkapiIOException("Error reading the package.\n" + e.getMessage(), e);
        }
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        this.close();
        this.canceled = false;
        if (input.getInputURI() == null) {
            throw new OkapiIOException("This filter requires URI-based raw documents only.");
        }
        File inFile = new File(input.getInputURI());
        String inFileName = inFile.getAbsolutePath();
        boolean isPackage = inFileName.endsWith(RAINBOWKIT_PACKAGE_EXTENSION);
        this.manifest = new Manifest();
        if (isPackage) {
            String root = Util.getDirectoryName(inFileName);
            String packageName = Util.getFilename(inFileName, false);
            String manifestFullName = Util.ensureSeparator(root, false);
            manifestFullName = Util.ensureSeparator(manifestFullName + packageName, false);
            FileUtil.unzip(inFileName, manifestFullName);
            manifestFullName = manifestFullName + "manifest" + ".rkm";
            inFile = new File(manifestFullName);
        }
        this.manifest.load(inFile);
        if (this.params.getOpenManifest()) {
            String className = "net.sf.okapi.filters.rainbowkit.ui.ManifestDialog";
            try {
                IManifestEditor dlg = (IManifestEditor)Class.forName(className).newInstance();
                if (!dlg.edit(null, this.manifest, true)) {
                    this.canceled = true;
                    return;
                }
            }
            catch (Throwable e) {
                this.LOGGER.error("Cannot create the editor ({})\n{}", (Object)className, (Object)e.getMessage());
            }
        }
        this.hasMoreDoc = true;
        this.queue = new LinkedList();
        this.hasNext = true;
        this.iter = this.manifest.getItems().keySet().iterator();
        this.nextDocument();
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        if (this.filter != null) {
            return this.filter.createSkeletonWriter();
        }
        return null;
    }

    @Override
    public IFilterWriter createFilterWriter() {
        if (this.filter != null) {
            return this.filter.createFilterWriter();
        }
        return null;
    }

    private void nextDocument() {
        while (this.iter.hasNext()) {
            int id = this.iter.next();
            this.info = this.manifest.getItem(id);
            if (!this.info.getSelected()) continue;
            this.startDocument();
            return;
        }
        this.hasMoreDoc = false;
    }

    private void startDocument() {
        File file = null;
        String extension = null;
        if (this.info.getExtractionType().equals("xliff")) {
            this.filter = new XLIFFFilter();
            extension = ".xlf";
        } else if (this.info.getExtractionType().equals("omegat")) {
            this.filter = new XLIFFFilter();
            extension = ".xlf";
        } else if (this.info.getExtractionType().equals("po")) {
            this.filter = new POFilter();
            extension = ".po";
        } else {
            if (this.info.getExtractionType().equals("rtf")) {
                file = this.postprocessRTF("rtf");
                ArrayList<Event> list = new ArrayList<Event>();
                list.add(new Event(EventType.START_BATCH_ITEM));
                RawDocument rd = new RawDocument(file.toURI(), this.info.getTargetEncoding(), this.manifest.getTargetLocale(), this.manifest.getTargetLocale());
                PipelineParameters pp = new PipelineParameters();
                pp.setOutputURI(rd.getInputURI());
                pp.setSourceLocale(rd.getSourceLocale());
                pp.setTargetLocale(rd.getTargetLocale());
                pp.setOutputEncoding(rd.getEncoding());
                pp.setInputRawDocument(rd);
                pp.setBatchInputCount(1);
                list.add(new Event(EventType.PIPELINE_PARAMETERS, pp));
                list.add(new Event(EventType.RAW_DOCUMENT, rd));
                list.add(new Event(EventType.END_BATCH_ITEM));
                this.queue.add(new Event(EventType.MULTI_EVENT, new MultiEvent(list)));
                return;
            }
            if (this.info.getExtractionType().equals("xliff+rtf")) {
                file = this.postprocessRTF("xliff+rtf");
                this.filter = new XLIFFFilter();
                extension = "";
            } else if (this.info.getExtractionType().equals("transifex")) {
                file = this.downloadFromTransifex(this.info);
                this.filter = new POFilter();
            } else if (this.info.getExtractionType().equals("ontram")) {
                file = new File(this.manifest.getTempTargetDirectory() + "contents.xini");
                this.filter = new XINIRainbowkitFilter(this.info.getRelativeInputPath());
            } else if (this.info.getExtractionType().equals("versified+rtf")) {
                file = this.postprocessRTF("versified+rtf");
                this.filter = new VersifiedTextFilter();
                extension = "";
            } else if (this.info.getExtractionType().equals("table")) {
                this.filter = new TransTableFilter();
                extension = ".txt";
            } else {
                if (this.info.getExtractionType().equals("none")) {
                    String inputPath = this.manifest.getTempOriginalDirectory() + this.info.getRelativeInputPath();
                    String outputPath = this.manifest.getMergeDirectory() + this.info.getRelativeInputPath();
                    Util.copyFile(inputPath, outputPath, false);
                    this.queue.add(Event.NOOP_EVENT);
                    return;
                }
                throw new OkapiIOException("Unsupported extraction type: " + this.info.getExtractionType());
            }
        }
        if (file == null) {
            file = new File(this.manifest.getTempTargetDirectory() + this.info.getRelativeInputPath() + extension);
        }
        RawDocument rd = new RawDocument(file.toURI(), this.info.getInputEncoding(), this.manifest.getSourceLocale(), this.manifest.getTargetLocale());
        this.filter.open(rd);
        this.nextEventInDocument(true);
    }

    private void nextEventInDocument(boolean attach) {
        if (this.filter == null) {
            this.nextDocument();
            return;
        }
        if (this.filter.hasNext()) {
            if (attach) {
                Event event = this.filter.next();
                StartDocument sd = event.getStartDocument();
                sd.setAnnotation(this.info);
                sd.setAnnotation(this.manifest);
                this.queue.add(event);
            } else {
                Event e = this.filter.next();
                this.queue.add(e);
            }
        } else {
            this.filter.close();
            this.nextDocument();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File postprocessRTF(String tkitType) {
        File outputFile = null;
        OutputStreamWriter writer = null;
        try {
            File file;
            if (this.rtfFilter == null) {
                this.rtfFilter = new RTFFilter();
            }
            if (tkitType == "xliff+rtf") {
                this.rtfFilter.setStripWSBeforeTextStart(true);
            }
            String lineBreak = "\r\n";
            String outputPath = null;
            if ("xliff+rtf".equals(tkitType)) {
                file = new File(this.manifest.getTempTargetDirectory() + this.info.getRelativeInputPath() + ".xlf" + ".rtf");
                this.rtfFilter.open(new RawDocument(file.toURI(), "windows-1252", this.manifest.getTargetLocale()));
                outputPath = this.manifest.getTempTargetDirectory() + this.info.getRelativeInputPath() + ".xlf";
            } else if ("versified+rtf".equals(tkitType)) {
                file = new File(this.manifest.getTempTargetDirectory() + this.info.getRelativeInputPath() + ".vrsz" + ".rtf");
                this.rtfFilter.open(new RawDocument(file.toURI(), "UTF-8", this.manifest.getTargetLocale()));
                outputPath = this.manifest.getTempTargetDirectory() + this.info.getRelativeInputPath() + ".vrsz";
            } else {
                file = new File(this.manifest.getTempTargetDirectory() + this.info.getRelativeInputPath() + ".rtf");
                this.rtfFilter.open(new RawDocument(file.toURI(), "windows-1252", this.manifest.getTargetLocale()));
                outputPath = this.manifest.getMergeDirectory() + this.info.getRelativeTargetPath();
            }
            outputFile = new File(outputPath);
            Util.createDirectories(outputPath);
            writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(outputPath)), this.info.getTargetEncoding());
            Util.writeBOMIfNeeded(writer, false, this.info.getTargetEncoding());
            StringBuilder buf = new StringBuilder();
            while (this.rtfFilter.getTextUntil(buf, -1, 0) == 0) {
                writer.write(buf.toString());
                writer.write(lineBreak);
            }
        }
        catch (Exception e) {
            Throwable e2 = e.getCause();
            this.LOGGER.error("RTF Conversion error.\n{}", (Object)(e2 != null ? e2.getMessage() : e.getMessage()));
        }
        finally {
            if (this.rtfFilter != null) {
                this.rtfFilter.close();
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    this.LOGGER.error("RTF Conversion error when closing file.\n{}", (Object)e.getMessage());
                }
            }
        }
        return outputFile;
    }

    private File downloadFromTransifex(MergingInfo info) {
        if (Util.isEmpty(info.getResourceId())) {
            this.LOGGER.error("The file '{}' does not have an associated Transifex resource id.", (Object)info.getRelativeInputPath());
            return null;
        }
        if (this.cli == null) {
            net.sf.okapi.lib.transifex.Parameters prm = new net.sf.okapi.lib.transifex.Parameters();
            prm.fromString(this.manifest.getCreatorParameters());
            this.cli = new TransifexClient(prm.getServer());
            this.cli.setProject(prm.getProjectId());
            this.cli.setCredentials(prm.getUser(), prm.getPassword());
        }
        String outputPath = this.manifest.getTempTargetDirectory() + info.getRelativeInputPath() + ".po";
        String[] res = this.cli.getResource(info.getResourceId(), this.manifest.getTargetLocale(), outputPath);
        if (res[0] == null) {
            this.LOGGER.error("Cannot pull the resource from Transifex.\n{}", (Object)res[1]);
            return null;
        }
        File file = new File(outputPath);
        return file;
    }
}

