/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xliff;

import java.io.File;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import net.sf.okapi.common.ClassUtil;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.AltTranslation;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.annotation.GenericAnnotations;
import net.sf.okapi.common.annotation.ITSLQIAnnotations;
import net.sf.okapi.common.annotation.ITSProvenanceAnnotations;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.exceptions.OkapiIllegalFilterOperationException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.GenericFilterWriter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.filterwriter.ITSContent;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonPart;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.xliff.Parameters;
import net.sf.okapi.filters.xliff.XLIFFITSFilterExtension;
import net.sf.okapi.filters.xliff.XLIFFSkeletonWriter;
import net.sf.okapi.filters.xliff.its.IITSDataStore;
import net.sf.okapi.filters.xliff.its.ITSDefaultDataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class XLIFFFilter
implements IFilter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String PROP_BUILDNUM = "build-num";
    public static final String PROP_EXTRADATA = "extradata";
    public static final String PROP_WASSEGMENTED = "wassegmented";
    private static final String ALTTRANSTYPE_PROPOSAL = "proposal";
    private boolean hasNext;
    private XMLStreamReader reader;
    private RawDocument input;
    private String docName;
    private int tuId;
    private IdGenerator otherId;
    private IdGenerator groupId;
    private String startDocId;
    private LocaleId srcLang;
    private LocaleId trgLang;
    private LinkedList<Event> queue;
    private boolean canceled;
    private GenericSkeleton skel;
    private GenericSkeletonPart itsLQISource;
    private GenericSkeletonPart itsLQITarget;
    private GenericSkeletonPart itsProvSource;
    private GenericSkeletonPart itsProvTarget;
    private ITextUnit tu;
    private int approved;
    private Parameters params = new Parameters();
    private boolean sourceDone;
    private boolean targetDone;
    private boolean altTransDone;
    private boolean segSourceDone;
    private String encoding;
    private Stack<String> parentIds;
    private List<String> groupUsedIds;
    private AltTranslationsAnnotation altTrans;
    private int altTransQuality;
    private MatchType altTransMatchType;
    private String altTransOrigin;
    private String altTransEngine;
    private boolean inAltTrans;
    private boolean processAltTrans;
    private Stack<Boolean> preserveSpaces;
    private String lineBreak;
    private boolean hasUTF8BOM;
    private EncoderManager encoderManager;
    private int autoMid;
    private XLIFFITSFilterExtension itsFilterHandler;
    private Stack<String> annotatorsRef;

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public void close() {
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
            if (this.input != null) {
                this.input.close();
                this.input = null;
            }
            this.hasNext = false;
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
    }

    @Override
    public String getName() {
        return "okf_xliff";
    }

    @Override
    public String getDisplayName() {
        return "XLIFF Filter";
    }

    @Override
    public String getMimeType() {
        return "application/x-xliff+xml";
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration(this.getName(), "application/x-xliff+xml", this.getClass().getName(), "XLIFF", "Configuration for XML Localisation Interchange File Format (XLIFF) documents.", null, ".xlf;.xliff;.sdlxliff;"));
        return list;
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setMapping("application/x-xliff+xml", "net.sf.okapi.common.encoder.XMLEncoder");
        }
        return this.encoderManager;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public Event next() {
        try {
            if (this.canceled) {
                this.queue.clear();
                this.queue.add(new Event(EventType.CANCELED));
                this.hasNext = false;
            }
            if (this.queue.isEmpty() && !this.read()) {
                Ending ending = new Ending(this.otherId.createId());
                ending.setSkeleton(this.skel);
                this.queue.add(new Event(EventType.END_DOCUMENT, ending));
            }
            if (this.queue.peek().getEventType() == EventType.END_DOCUMENT) {
                this.hasNext = false;
            }
            return this.queue.poll();
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        this.open(input, generateSkeleton, new ITSDefaultDataStore());
    }

    public void open(RawDocument input, boolean generateSkeleton, IITSDataStore datastore) {
        try {
            this.close();
            this.canceled = false;
            this.input = input;
            XMLInputFactory fact = null;
            if (this.params.getUseCustomParser()) {
                Class<?> factClass = ClassUtil.getClass(this.params.getFactoryClass());
                fact = (XMLInputFactory)factClass.newInstance();
            } else {
                fact = XMLInputFactory.newInstance();
            }
            fact.setProperty("javax.xml.stream.isCoalescing", true);
            fact.setProperty("javax.xml.stream.supportDTD", false);
            input.setEncoding("UTF-8");
            BOMNewlineEncodingDetector detector = new BOMNewlineEncodingDetector(input.getStream(), input.getEncoding());
            detector.detectBom();
            String inStreamCharset = "UTF-8";
            if (detector.isAutodetected()) {
                inStreamCharset = detector.getEncoding();
            }
            InputStreamReader inStreamReader = this.createStreamReader(input, inStreamCharset);
            XMLEventReader eventReader = null != input.getInputURI() ? fact.createXMLEventReader(input.getInputURI().toString(), inStreamReader) : fact.createXMLEventReader(inStreamReader);
            this.itsFilterHandler = new XLIFFITSFilterExtension(fact, datastore, input.getInputURI());
            File newInput = this.itsFilterHandler.parseInDocumentITSStandoff(eventReader, inStreamCharset);
            input.setNewInputStream(newInput, input.getEncoding(), input.getSourceLocale(), input.getTargetLocale());
            inStreamReader = this.createStreamReader(input, inStreamCharset);
            this.reader = null != input.getInputURI() ? fact.createXMLStreamReader(input.getInputURI().toString(), inStreamReader) : fact.createXMLStreamReader(inStreamReader);
            this.itsFilterHandler.setXLIFFReader(this.reader);
            String realEnc = this.reader.getCharacterEncodingScheme();
            this.encoding = realEnc != null ? realEnc : input.getEncoding();
            this.annotatorsRef = new Stack();
            this.annotatorsRef.push(null);
            this.srcLang = input.getSourceLocale();
            if (this.srcLang == null) {
                throw new NullPointerException("Source language not set.");
            }
            this.trgLang = input.getTargetLocale();
            if (this.trgLang == null) {
                throw new NullPointerException("Target language not set.");
            }
            this.hasUTF8BOM = detector.hasUtf8Bom();
            this.lineBreak = detector.getNewlineType().toString();
            if (input.getInputURI() != null) {
                this.docName = input.getInputURI().getPath();
            }
            this.preserveSpaces = new Stack();
            this.preserveSpaces.push(false);
            this.parentIds = new Stack();
            this.parentIds.push("p0");
            this.tuId = 0;
            this.groupId = new IdGenerator(null, "g");
            this.otherId = new IdGenerator(null, "d");
            this.hasNext = true;
            this.queue = new LinkedList();
            this.groupUsedIds = new ArrayList<String>();
            this.startDocId = this.otherId.createId();
            StartDocument startDoc = new StartDocument(this.startDocId);
            startDoc.setName(this.docName);
            startDoc.setEncoding(this.encoding, this.hasUTF8BOM);
            startDoc.setLocale(this.srcLang);
            startDoc.setFilterParameters(this.getParameters());
            startDoc.setFilterWriter(this.createFilterWriter());
            startDoc.setType("application/x-xliff+xml");
            startDoc.setMimeType("application/x-xliff+xml");
            startDoc.setMultilingual(true);
            startDoc.setLineBreak(this.lineBreak);
            this.queue.add(new Event(EventType.START_DOCUMENT, startDoc));
            this.skel = new GenericSkeleton();
            startDoc.setProperty(new Property("encoding", this.encoding, false));
            this.skel.append("<?xml version=\"1.0\" encoding=\"");
            this.skel.addValuePlaceholder(startDoc, "encoding", LocaleId.EMPTY);
            this.skel.append("\"?>");
            startDoc.setSkeleton(this.skel);
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException("Cannot open XML document.\n" + e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new OkapiIOException("Cannot open XML document.\n" + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new OkapiIOException("Cannot open XML document.\n" + e.getMessage(), e);
        }
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        XLIFFSkeletonWriter writer = new XLIFFSkeletonWriter(this.params);
        if (this.itsFilterHandler != null && this.itsFilterHandler.getITSStandoffManager() != null) {
            writer.setITSStandoffManager(this.itsFilterHandler.getITSStandoffManager());
        }
        return writer;
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return new GenericFilterWriter(this.createSkeletonWriter(), this.getEncoderManager());
    }

    public InputStreamReader createStreamReader(RawDocument input, String charset) {
        InputStreamReader inputStreamReader;
        try {
            inputStreamReader = new InputStreamReader(input.getStream(), charset);
        }
        catch (UnsupportedEncodingException e) {
            this.logger.warn("Invalid encoding '{}', using default.", (Object)charset);
            inputStreamReader = new InputStreamReader(input.getStream());
        }
        return inputStreamReader;
    }

    private boolean read() throws XMLStreamException {
        this.skel = new GenericSkeleton();
        while (this.reader.hasNext()) {
            int eventType = this.reader.next();
            switch (eventType) {
                case 1: {
                    String name = this.reader.getLocalName();
                    if ("trans-unit".equals(name)) {
                        return this.processTransUnit();
                    }
                    if ("file".equals(name)) {
                        return this.processStartFile();
                    }
                    if ("group".equals(name)) {
                        if (!this.processStartGroup()) break;
                        return true;
                    }
                    if ("bin-unit".equals(name)) {
                        if (!this.processStartBinUnit()) break;
                        return true;
                    }
                    this.storeStartElement(false, false);
                    break;
                }
                case 2: {
                    this.storeEndElement();
                    if ("file".equals(this.reader.getLocalName())) {
                        return this.processEndFile();
                    }
                    if ("group".equals(this.reader.getLocalName())) {
                        return this.processEndGroup();
                    }
                    if (!"bin-unit".equals(this.reader.getLocalName())) break;
                    return this.processEndBinUnit();
                }
                case 6: 
                case 12: {
                    this.skel.append(this.reader.getText().replace("\n", this.lineBreak));
                    break;
                }
                case 4: {
                    this.skel.append(Util.escapeToXML(this.reader.getText().replace("\n", this.lineBreak), 0, this.params.getEscapeGT(), null));
                    break;
                }
                case 5: {
                    this.skel.append("<!--" + this.reader.getText().replace("\n", this.lineBreak) + "-->");
                    break;
                }
                case 3: {
                    this.skel.append("<?" + this.reader.getPITarget() + " " + this.reader.getPIData() + "?>");
                    break;
                }
                case 11: {
                    break;
                }
                case 9: 
                case 10: 
                case 13: 
                case 14: 
                case 15: {
                    break;
                }
                case 7: {
                    break;
                }
            }
        }
        return false;
    }

    private boolean processStartFile() {
        Property prop;
        if (!this.skel.isEmpty(true)) {
            DocumentPart dp = new DocumentPart(this.otherId.createId(), false, this.skel);
            this.skel = new GenericSkeleton();
            this.queue.add(new Event(EventType.DOCUMENT_PART, dp));
        }
        StartSubDocument startSubDoc = new StartSubDocument(this.startDocId, this.otherId.createId());
        this.storeStartElementFile(startSubDoc);
        String tmp = this.reader.getAttributeValue(null, "original");
        if (tmp == null) {
            throw new OkapiIllegalFilterOperationException("Missing attribute 'original'.");
        }
        startSubDoc.setName(tmp);
        tmp = this.reader.getAttributeValue(null, "source-language");
        if (tmp == null) {
            throw new OkapiIllegalFilterOperationException("Missing attribute 'source-language'.");
        }
        LocaleId tmpLang = LocaleId.fromString(tmp);
        if (!tmpLang.equals(this.srcLang)) {
            this.logger.warn("The source language declared in <file> is '{}' not '{}'.", (Object)tmp, (Object)this.srcLang);
        }
        if ((prop = startSubDoc.getProperty("targetLanguage")) != null) {
            tmpLang = LocaleId.fromString(prop.getValue());
            if (this.params.getOverrideTargetLanguage()) {
                prop.setValue(this.trgLang.toBCP47());
            } else if (!tmpLang.sameLanguageAs(this.trgLang)) {
                this.logger.warn("The target language declared in <file> is '{}' not '{}'. '{}' will be used.", prop.getValue(), this.trgLang, prop.getValue());
                this.trgLang = tmpLang;
            }
        }
        if ((tmp = this.reader.getAttributeValue(null, "datatype")) != null) {
            if (tmp.equals("x-undefined")) {
                tmp = null;
            } else if (tmp.equals("html")) {
                tmp = "text/html";
            } else if (tmp.equals("xml")) {
                tmp = "text/xml";
            }
            startSubDoc.setMimeType(tmp);
        }
        if ((tmp = this.reader.getAttributeValue(null, PROP_BUILDNUM)) != null) {
            startSubDoc.setProperty(new Property(PROP_BUILDNUM, tmp, true));
        }
        if ((tmp = this.annotatorsRef.peek()) != null) {
            GenericAnnotations.addAnnotations(startSubDoc, new GenericAnnotations(new GenericAnnotation("its-annotators", "annotatorsValue", tmp)));
        }
        ITSProvenanceAnnotations prov = this.itsFilterHandler.readITSProvenance();
        ITSProvenanceAnnotations.addAnnotations(startSubDoc, prov);
        startSubDoc.setSkeleton(this.skel);
        this.queue.add(new Event(EventType.START_SUBDOCUMENT, startSubDoc));
        return true;
    }

    private boolean processEndFile() {
        Ending ending = new Ending(this.otherId.createId());
        ending.setSkeleton(this.skel);
        this.queue.add(new Event(EventType.END_SUBDOCUMENT, ending));
        return true;
    }

    private void storeStartElement(boolean updateLangWithTarget, boolean addApprovedIfNeeded) {
        this.pushAnnotatorsRef();
        String prefix = this.reader.getPrefix();
        if (!prefix.equals("its")) {
            this.storeElementName(prefix);
            boolean ps = this.preserveSpaces.peek();
            String itsLQIRef = "";
            String itsProvRef = "";
            int count = this.reader.getAttributeCount();
            for (int i = 0; i < count; ++i) {
                if (!this.reader.isAttributeSpecified(i)) continue;
                String attrPrefix = this.reader.getAttributePrefix(i);
                String attrName = (attrPrefix == null || attrPrefix.length() == 0 ? "" : attrPrefix + ":") + this.reader.getAttributeLocalName(i);
                String attrValue = this.reader.getAttributeValue(i);
                if (attrName.equals("xml:lang") && updateLangWithTarget) {
                    attrValue = this.trgLang.toBCP47();
                }
                if (attrName.equals("xml:space")) {
                    ps = attrValue.equals("preserve");
                }
                if (this.reader.getAttributeLocalName(i).equals("approved")) {
                    this.skel.addValuePlaceholder(this.tu, "approved", this.trgLang);
                    addApprovedIfNeeded = false;
                    continue;
                }
                if (attrName.equals("its:locQualityIssuesRef")) {
                    itsLQIRef = " its:locQualityIssuesRef=\"" + attrValue + "\"";
                    continue;
                }
                if (attrName.equals("its:provenanceRecordsRef")) {
                    itsProvRef = " its:provenanceRecordsRef=\"" + attrValue + "\"";
                    continue;
                }
                this.skel.append(" ");
                this.skel.append(attrName);
                this.skel.append("=\"");
                this.skel.append(Util.escapeToXML(attrValue.replace("\n", this.lineBreak), 3, this.params.getEscapeGT(), null));
                this.skel.append("\"");
            }
            if (this.reader.getLocalName().equals("trans-unit")) {
                this.skel.addValuePlaceholder(this.tu, "locQualityIssuesRef", LocaleId.EMPTY);
                this.tu.setProperty(new Property("locQualityIssuesRef", itsLQIRef));
                this.skel.addValuePlaceholder(this.tu, "provenanceRecordsRef", LocaleId.EMPTY);
                this.tu.setProperty(new Property("provenanceRecordsRef", itsProvRef));
            } else if (this.reader.getLocalName().equals("source")) {
                this.itsLQISource = this.skel.addValuePlaceholder(this.tu, "locQualityIssuesRef", LocaleId.EMPTY);
                this.itsProvSource = this.skel.addValuePlaceholder(this.tu, "provenanceRecordsRef", LocaleId.EMPTY);
            } else if (this.reader.getLocalName().equals("target")) {
                this.itsLQITarget = this.skel.addValuePlaceholder(this.tu, "locQualityIssuesRef", LocaleId.EMPTY);
                this.itsProvTarget = this.skel.addValuePlaceholder(this.tu, "provenanceRecordsRef", LocaleId.EMPTY);
            }
            if (addApprovedIfNeeded) {
                this.skel.addValuePlaceholder(this.tu, "approved", this.trgLang);
            }
            this.skel.append(">");
            this.preserveSpaces.push(ps);
        }
    }

    private void storeStartElementFile(StartSubDocument startSubDoc) {
        this.pushAnnotatorsRef();
        this.storeElementName(this.reader.getPrefix());
        boolean ps = this.preserveSpaces.peek();
        boolean hasTargetlanguage = false;
        String itsProvRef = "";
        int count = this.reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            if (!this.reader.isAttributeSpecified(i)) continue;
            String attrPrefix = this.reader.getAttributePrefix(i);
            String attrName = (attrPrefix == null || attrPrefix.length() == 0 ? "" : attrPrefix + ":") + this.reader.getAttributeLocalName(i);
            String attrValue = this.reader.getAttributeValue(i);
            if (this.reader.getAttributeLocalName(i).equals("target-language")) {
                hasTargetlanguage = true;
                startSubDoc.setProperty(new Property("targetLanguage", attrValue, false));
                this.skel.append(" ");
                this.skel.append(attrName);
                this.skel.append("=\"");
                this.skel.addValuePlaceholder(startSubDoc, "targetLanguage", LocaleId.EMPTY);
                this.skel.append("\"");
                continue;
            }
            if (this.reader.getAttributeLocalName(i).equals("source-language")) {
                startSubDoc.setProperty(new Property("sourceLanguage", attrValue));
                this.skel.append(" ");
                this.skel.append(attrName);
                this.skel.append("=\"");
                this.skel.addValuePlaceholder(startSubDoc, "sourceLanguage", LocaleId.EMPTY);
                this.skel.append("\"");
                continue;
            }
            if (attrName.equals("its:provenanceRecordsRef")) {
                itsProvRef = " its:provenanceRecordsRef=\"" + attrValue + "\"";
                continue;
            }
            this.skel.append(" ");
            this.skel.append(attrName);
            this.skel.append("=\"");
            this.skel.append(Util.escapeToXML(attrValue.replace("\n", this.lineBreak), 3, this.params.getEscapeGT(), null));
            this.skel.append("\"");
            if (!attrName.equals("xml:space")) continue;
            ps = attrValue.equals("preserve");
        }
        this.skel.addValuePlaceholder(startSubDoc, "provenanceRecordsRef", LocaleId.EMPTY);
        startSubDoc.setProperty(new Property("provenanceRecordsRef", itsProvRef));
        if (this.params.getAddTargetLanguage() && !hasTargetlanguage) {
            startSubDoc.setProperty(new Property("targetLanguage", this.trgLang.toBCP47(), false));
            this.skel.append(" target-language=\"");
            this.skel.addValuePlaceholder(startSubDoc, "targetLanguage", LocaleId.EMPTY);
            this.skel.append("\"");
        }
        this.skel.append(">");
        this.preserveSpaces.push(ps);
    }

    private void storeStartElementGroup(StartGroup group) {
        this.pushAnnotatorsRef();
        this.storeElementName(this.reader.getPrefix());
        boolean ps = this.preserveSpaces.peek();
        String itsProvRef = "";
        int count = this.reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            if (!this.reader.isAttributeSpecified(i)) continue;
            String attrPrefix = this.reader.getAttributePrefix(i);
            String attrName = (attrPrefix == null || attrPrefix.length() == 0 ? "" : attrPrefix + ":") + this.reader.getAttributeLocalName(i);
            String attrValue = this.reader.getAttributeValue(i);
            if (attrName.equals("xml:space")) {
                ps = attrValue.equals("preserve");
            }
            if (attrName.equals("its:provenanceRecordsRef")) {
                itsProvRef = " its:provenanceRecordsRef=\"" + attrValue + "\"";
                continue;
            }
            this.skel.append(" ");
            this.skel.append(attrName);
            this.skel.append("=\"");
            this.skel.append(Util.escapeToXML(attrValue.replace("\n", this.lineBreak), 3, this.params.getEscapeGT(), null));
            this.skel.append("\"");
        }
        this.skel.addValuePlaceholder(group, "provenanceRecordsRef", LocaleId.EMPTY);
        group.setProperty(new Property("provenanceRecordsRef", itsProvRef));
        this.skel.append(">");
        this.preserveSpaces.push(ps);
    }

    private void storeElementName(String prefix) {
        if (prefix == null || prefix.length() == 0) {
            this.skel.append("<" + this.reader.getLocalName());
        } else {
            this.skel.append("<" + prefix + ":" + this.reader.getLocalName());
        }
        int count = this.reader.getNamespaceCount();
        for (int i = 0; i < count; ++i) {
            prefix = this.reader.getNamespacePrefix(i);
            this.skel.append(" xmlns");
            if (!Util.isEmpty(prefix)) {
                this.skel.append(":" + prefix);
            }
            this.skel.append("=\"");
            this.skel.append(this.reader.getNamespaceURI(i));
            this.skel.append("\"");
        }
    }

    private void storeEndElement() {
        String prefix = this.reader.getPrefix();
        if (!prefix.equals("its")) {
            if (prefix != null && prefix.length() > 0) {
                this.skel.append("</" + prefix + ":" + this.reader.getLocalName() + ">");
            } else {
                this.skel.append("</" + this.reader.getLocalName() + ">");
            }
            this.preserveSpaces.pop();
        }
        this.popAnnotatorsRef();
    }

    private boolean processTransUnit() {
        try {
            if (!this.skel.isEmpty(true)) {
                DocumentPart dp = new DocumentPart(this.otherId.createId(), false, this.skel);
                this.skel = new GenericSkeleton();
                this.queue.add(new Event(EventType.DOCUMENT_PART, dp));
            }
            this.sourceDone = false;
            this.targetDone = false;
            this.altTransDone = false;
            this.segSourceDone = false;
            this.altTrans = null;
            this.processAltTrans = false;
            this.inAltTrans = false;
            this.segSourceDone = false;
            this.tu = new TextUnit(String.valueOf(++this.tuId));
            this.storeStartElement(false, true);
            String tmp = this.reader.getAttributeValue(null, "translate");
            if (tmp != null) {
                this.tu.setIsTranslatable(tmp.equals("yes"));
            }
            if ((tmp = this.reader.getAttributeValue(null, "id")) == null) {
                throw new OkapiIllegalFilterOperationException("Missing attribute 'id'.");
            }
            this.tu.setId(tmp);
            tmp = this.reader.getAttributeValue(null, "resname");
            if (tmp != null) {
                this.tu.setName(tmp);
            } else if (this.params.getFallbackToID()) {
                this.tu.setName(this.tu.getId());
            }
            tmp = this.reader.getAttributeValue(null, PROP_EXTRADATA);
            if (tmp != null) {
                this.tu.setProperty(new Property(PROP_EXTRADATA, tmp, true));
            }
            this.approved = -1;
            tmp = this.reader.getAttributeValue(null, "approved");
            if (tmp != null) {
                this.approved = 0;
                if (tmp.equals("yes")) {
                    this.approved = 1;
                }
            }
            this.itsFilterHandler.readTextUnitITSAttributes(this.tu);
            this.tu.setType(this.reader.getAttributeValue(null, "restype"));
            while (this.reader.hasNext()) {
                int eventType = this.reader.next();
                switch (eventType) {
                    case 1: {
                        String name = this.reader.getLocalName();
                        if ("source".equals(name)) {
                            this.storeStartElement(false, false);
                            this.processSource(false);
                            this.storeEndElement();
                            break;
                        }
                        if ("target".equals(name)) {
                            this.addSegSourceIfNeeded();
                            this.storeStartElement(this.params.getOverrideTargetLanguage(), false);
                            this.processTarget();
                            this.storeEndElement();
                            break;
                        }
                        if ("seg-source".equals(name)) {
                            this.skel.add("[@#$SEGSRC$#@]");
                            this.skel.attachParent(this.tu);
                            this.storeStartElement(false, false);
                            this.processSource(true);
                            this.storeEndElement();
                            this.skel.flushPart();
                            this.segSourceDone = true;
                            if (!this.tu.getSource().hasBeenSegmented()) break;
                            this.tu.setProperty(new Property(PROP_WASSEGMENTED, "true", true));
                            break;
                        }
                        if ("note".equals(name)) {
                            this.addTargetIfNeeded();
                            this.storeStartElement(false, false);
                            this.processNote();
                            this.storeEndElement();
                            break;
                        }
                        if ("alt-trans".equals(name)) {
                            this.addTargetIfNeeded();
                            this.storeStartElement(false, false);
                            this.processStartAltTrans();
                            break;
                        }
                        this.addTargetIfNeeded();
                        this.storeStartElement(false, false);
                        break;
                    }
                    case 2: {
                        String name = this.reader.getLocalName();
                        if ("trans-unit".equals(name)) {
                            this.addTargetIfNeeded();
                            this.storeEndElement();
                            if (this.altTrans != null) {
                                this.altTrans.sort();
                            }
                            if (this.params.getIgnoreInputSegmentation()) {
                                this.tu.removeAllSegmentations();
                            }
                            this.tu.setSkeleton(this.skel);
                            this.tu.setMimeType("application/x-xliff+xml");
                            this.queue.add(new Event(EventType.TEXT_UNIT, this.tu));
                            return true;
                        }
                        if ("alt-trans".equals(name)) {
                            this.inAltTrans = false;
                        }
                        this.storeEndElement();
                        break;
                    }
                    case 4: 
                    case 6: 
                    case 12: {
                        if (!this.targetDone) {
                            tmp = this.reader.getText();
                            for (int i = 0; i < tmp.length(); ++i) {
                                if (Character.isWhitespace(tmp.charAt(i))) continue;
                                this.addTargetIfNeeded();
                                break;
                            }
                        }
                        this.skel.append(Util.escapeToXML(this.reader.getText().replace("\n", this.lineBreak), 0, this.params.getEscapeGT(), null));
                        break;
                    }
                    case 5: {
                        this.skel.append("<!--" + this.reader.getText().replace("\n", this.lineBreak) + "-->");
                        break;
                    }
                    case 3: {
                        this.skel.append("<?" + this.reader.getPITarget() + " " + this.reader.getPIData() + "?>");
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
        return false;
    }

    private void processSource(boolean isSegSource) {
        if (this.sourceDone) {
            String tmp = this.reader.getAttributeValue("http://www.w3.org/XML/1998/namespace", "lang");
            LocaleId lang = tmp == null ? this.srcLang : LocaleId.fromString(tmp);
            TextContainer tc = this.processContent(isSegSource ? "seg-source" : "source", true);
            if (!this.preserveSpaces.peek().booleanValue()) {
                tc.unwrap(true, false);
            }
            if (this.inAltTrans) {
                if (this.processAltTrans && !isSegSource) {
                    AltTranslation alt = this.altTrans.add(lang, null, null, tc.getFirstContent(), null, this.altTransMatchType, 0, this.altTransOrigin);
                    alt.getEntry().setPreserveWhitespaces(this.preserveSpaces.peek());
                    alt.setEngine(this.altTransEngine);
                    if (this.altTransQuality > 0) {
                        alt.setCombinedScore(this.altTransQuality);
                    }
                }
            } else {
                TextContainer cont = tc.clone();
                cont.getSegments().joinAll();
                if (cont.compareTo(this.tu.getSource(), true) != 0) {
                    this.logger.warn("The <seg-source> content for the entry id='{}' is different from its <source>. The un-segmented content of <source> will be used.", (Object)this.tu.getId());
                } else {
                    GenericAnnotations.addAnnotations(tc, this.tu.getSource().getAnnotation(GenericAnnotations.class));
                    ITSLQIAnnotations.addAnnotations(tc, this.tu.getSource().getAnnotation(ITSLQIAnnotations.class));
                    ITSProvenanceAnnotations.addAnnotations(tc, this.tu.getSource().getAnnotation(ITSProvenanceAnnotations.class));
                    tc.setProperty(this.tu.getSource().getProperty("locQualityIssuesRef"));
                    tc.setProperty(this.tu.getSource().getProperty("provenanceRecordsRef"));
                    tc.setHasBeenSegmentedFlag(true);
                    this.tu.setSource(tc);
                    this.itsLQISource.setParent(tc);
                    this.itsProvSource.setParent(tc);
                }
            }
        } else {
            String tmp = this.reader.getAttributeValue(null, "coord");
            if (tmp != null) {
                this.tu.setSourceProperty(new Property("coordinates", tmp, true));
            }
            GenericAnnotations anns = this.itsFilterHandler.readTextContainerITSAttributes();
            ITSLQIAnnotations lqiAnn = this.itsFilterHandler.readITSLQI();
            ITSProvenanceAnnotations provAnn = this.itsFilterHandler.readITSProvenance();
            String itsLQIRef = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "locQualityIssuesRef");
            String itsProvRef = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "provenanceRecordsRef");
            this.skel.addContentPlaceholder(this.tu);
            TextContainer tc = this.processContent(isSegSource ? "seg-source" : "source", false);
            if (!this.preserveSpaces.peek().booleanValue()) {
                tc.unwrap(true, false);
            }
            this.tu.setPreserveWhitespaces(this.preserveSpaces.peek());
            tc.setProperty(new Property("locQualityIssuesRef", lqiAnn != null && itsLQIRef != null ? " its:locQualityIssuesRef=\"" + itsLQIRef + "\"" : ""));
            tc.setProperty(new Property("provenanceRecordsRef", provAnn != null && itsProvRef != null ? " its:provenanceRecordsRef=\"" + itsProvRef + "\"" : ""));
            GenericAnnotations.addAnnotations(tc, anns);
            ITSLQIAnnotations.addAnnotations(tc, lqiAnn);
            ITSProvenanceAnnotations.addAnnotations(tc, provAnn);
            this.itsLQISource.setParent(tc);
            this.itsProvSource.setParent(tc);
            this.tu.setSource(tc);
            this.sourceDone = true;
        }
    }

    private void processTarget() {
        if (this.targetDone) {
            String tmp = this.reader.getAttributeValue("http://www.w3.org/XML/1998/namespace", "lang");
            LocaleId lang = tmp == null ? this.trgLang : LocaleId.fromString(tmp);
            TextContainer tc = this.processContent("target", true);
            if (!this.preserveSpaces.peek().booleanValue()) {
                tc.unwrap(true, false);
            }
            if (this.inAltTrans && this.processAltTrans) {
                AltTranslation alt = this.altTrans.getLast();
                if (alt != null && alt.getTargetLocale() != null) {
                    alt = null;
                }
                if (alt == null) {
                    alt = this.altTrans.add(this.srcLang, null, null, null, null, this.altTransMatchType, 0, this.altTransOrigin);
                    alt.getEntry().setPreserveWhitespaces(this.preserveSpaces.peek());
                    alt.setEngine(this.altTransEngine);
                    if (this.altTransQuality > 0) {
                        alt.setCombinedScore(this.altTransQuality);
                    }
                }
                if (tc.contentIsOneSegment()) {
                    alt.setTarget(lang, tc.getFirstContent());
                } else {
                    alt.setTarget(lang, tc.getUnSegmentedContentCopy());
                }
                alt.getEntry().setPreserveWhitespaces(this.preserveSpaces.peek());
                alt.setFromOriginal(true);
            }
        } else {
            String stateValue = this.reader.getAttributeValue(null, "state");
            String coordValue = this.reader.getAttributeValue(null, "coord");
            GenericAnnotations anns = this.itsFilterHandler.readTextContainerITSAttributes();
            ITSLQIAnnotations lqiAnn = this.itsFilterHandler.readITSLQI();
            ITSProvenanceAnnotations provAnn = this.itsFilterHandler.readITSProvenance();
            String itsLQIRef = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "locQualityIssuesRef");
            String itsProvRef = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "provenanceRecordsRef");
            this.skel.addContentPlaceholder(this.tu, this.trgLang);
            TextContainer tc = this.processContent("target", false);
            if (!this.preserveSpaces.peek().booleanValue()) {
                tc.unwrap(true, false);
            }
            this.tu.setPreserveWhitespaces(this.preserveSpaces.peek());
            tc.setProperty(new Property("locQualityIssuesRef", lqiAnn != null && itsLQIRef != null ? " its:locQualityIssuesRef=\"" + itsLQIRef + "\"" : ""));
            tc.setProperty(new Property("provenanceRecordsRef", provAnn != null && itsProvRef != null ? " its:provenanceRecordsRef=\"" + itsProvRef + "\"" : ""));
            GenericAnnotations.addAnnotations(tc, anns);
            ITSLQIAnnotations.addAnnotations(tc, lqiAnn);
            ITSProvenanceAnnotations.addAnnotations(tc, provAnn);
            this.itsLQITarget.setParent(tc);
            this.itsProvTarget.setParent(tc);
            this.tu.setTarget(this.trgLang, tc);
            if (stateValue != null) {
                this.tu.setTargetProperty(this.trgLang, new Property("state", stateValue, true));
            }
            if (coordValue != null) {
                this.tu.setTargetProperty(this.trgLang, new Property("coordinates", coordValue, true));
            }
            if (this.approved > -1) {
                this.tu.setTargetProperty(this.trgLang, new Property("approved", this.approved == 1 ? "yes" : "no", false));
            }
            this.targetDone = true;
        }
    }

    private void processStartAltTrans() {
        this.inAltTrans = true;
        this.processAltTrans = true;
        String tmp = this.reader.getAttributeValue(null, "alttranstype");
        if (tmp != null && !tmp.equals(ALTTRANSTYPE_PROPOSAL)) {
            this.processAltTrans = false;
            return;
        }
        String mid = this.reader.getAttributeValue(null, "mid");
        this.altTransQuality = -1;
        tmp = this.reader.getAttributeValue(null, "match-quality");
        if (!Util.isEmpty(tmp) && Character.isDigit(tmp.charAt(0))) {
            if (tmp.endsWith("%")) {
                tmp = tmp.substring(0, tmp.length() - 1);
            }
            try {
                this.altTransQuality = Integer.valueOf(tmp);
                if (this.altTransQuality < 1) {
                    this.altTransQuality = -1;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        this.altTransMatchType = MatchType.UKNOWN;
        tmp = this.reader.getAttributeValue("okapi-framework:xliff-extensions", "matchType");
        if (!Util.isEmpty(tmp)) {
            this.altTransMatchType = MatchType.valueOf(tmp);
        }
        if (this.altTransMatchType.equals((Object)MatchType.UKNOWN)) {
            if (this.altTransQuality > 99) {
                this.altTransMatchType = MatchType.EXACT;
            } else if (this.altTransQuality > 0) {
                this.altTransMatchType = MatchType.FUZZY;
            }
        }
        this.altTransOrigin = "SourceDoc";
        tmp = this.reader.getAttributeValue(null, "origin");
        if (!Util.isEmpty(tmp)) {
            this.altTransOrigin = tmp;
        }
        this.altTransEngine = this.reader.getAttributeValue("okapi-framework:xliff-extensions", "engine");
        TextContainer tc = this.tu.getTarget(this.trgLang);
        if (tc == null) {
            tc = this.tu.createTarget(this.trgLang, false, 4);
        }
        if (mid == null) {
            this.altTrans = tc.getAnnotation(AltTranslationsAnnotation.class);
            if (this.altTrans == null) {
                this.altTrans = new AltTranslationsAnnotation();
                tc.setAnnotation(this.altTrans);
            }
        } else {
            Segment seg = tc.getSegments().get(mid);
            if (seg == null) {
                this.logger.warn("An <alt-trans> element for an unknown segment '{}' was detected. It will be ignored.", (Object)mid);
                this.processAltTrans = false;
                return;
            }
            this.altTrans = seg.getAnnotation(AltTranslationsAnnotation.class);
            if (this.altTrans == null) {
                this.altTrans = new AltTranslationsAnnotation();
                seg.setAnnotation(this.altTrans);
            }
        }
    }

    private void addSegSourceIfNeeded() {
        if (!this.segSourceDone) {
            this.skel.add("[@#$SEGSRC$#@]");
            this.skel.attachParent(this.tu);
            this.skel.flushPart();
            this.segSourceDone = true;
        }
    }

    private void addAltTransMarker() {
        if (this.altTransDone) {
            return;
        }
        this.skel.add("[@#$ALTTRANS$#@]");
        this.skel.attachParent(this.tu);
        this.skel.flushPart();
        this.altTransDone = true;
    }

    private void addTargetIfNeeded() {
        if (!this.sourceDone) {
            throw new OkapiIllegalFilterOperationException("Element <source> missing or not placed properly.");
        }
        if (this.targetDone) {
            this.addAltTransMarker();
            return;
        }
        this.addSegSourceIfNeeded();
        if (this.srcLang.equals(this.trgLang)) {
            return;
        }
        this.skel.append("<target xml:lang=\"");
        this.skel.append(this.trgLang.toString());
        this.skel.append("\">");
        this.skel.addContentPlaceholder(this.tu, this.trgLang);
        this.skel.append("</target>");
        this.skel.append(this.lineBreak);
        this.targetDone = true;
        this.addAltTransMarker();
    }

    private TextContainer processContent(String tagName, boolean store) {
        try {
            boolean changeFirstPart = false;
            TextContainer content = new TextContainer();
            ISegments segments = content.getSegments();
            int id = 0;
            this.autoMid = -1;
            Stack<Integer> idStack = new Stack<Integer>();
            ArrayList<Integer> annIds = new ArrayList<Integer>();
            idStack.push(id);
            Segment segment = null;
            int segIdStack = -1;
            TextFragment current = new TextFragment();
            current.invalidate();
            while (this.reader.hasNext()) {
                int eventType = this.reader.next();
                switch (eventType) {
                    case 4: 
                    case 6: 
                    case 12: {
                        current.append(this.reader.getText());
                        if (!store) break;
                        this.skel.append(Util.escapeToXML(this.reader.getText(), 0, this.params.getEscapeGT(), null));
                        break;
                    }
                    case 2: {
                        String name = this.reader.getLocalName();
                        if (name.equals(tagName)) {
                            if (!current.isEmpty()) {
                                content.append(current, !content.hasBeenSegmented());
                            }
                            return content;
                        }
                        if (name.equals("mrk") && (Integer)idStack.peek() == segIdStack) {
                            current = new TextFragment();
                            current.invalidate();
                            idStack.pop();
                            segIdStack = -1;
                            String oriId = segment.getId();
                            segments.append(segment, !content.hasBeenSegmented());
                            if (changeFirstPart && content.count() == 2) {
                                changeFirstPart = false;
                                content.changePart(0);
                                segment.forceId(oriId);
                            }
                            if (store) {
                                this.storeEndElement();
                                break;
                            }
                            this.popAnnotatorsRef();
                            break;
                        }
                        if (!name.equals("g") && !name.equals("mrk")) break;
                        if (store) {
                            this.storeEndElement();
                        } else {
                            this.popAnnotatorsRef();
                        }
                        Code code = current.append(TextFragment.TagType.CLOSING, name, "");
                        id = (Integer)idStack.pop();
                        code.setId(id);
                        String tmp = this.reader.getPrefix();
                        if (tmp != null && tmp.length() > 0) {
                            code.setOuterData("</" + tmp + ":" + name + ">");
                        } else {
                            code.setOuterData("</" + name + ">");
                        }
                        if (!name.equals("mrk")) break;
                        int n = -1;
                        n = annIds.indexOf(id);
                        if (n == -1) break;
                        annIds.remove(n);
                        Code oc = current.getCode(current.getIndex(id));
                        GenericAnnotations.addAnnotations(code, oc.getGenericAnnotations());
                        code.setType("_annotation_");
                        break;
                    }
                    case 1: {
                        Code code;
                        if (store) {
                            this.storeStartElement(false, false);
                        } else {
                            this.pushAnnotatorsRef();
                        }
                        String name = this.reader.getLocalName();
                        if (name.equals("mrk")) {
                            String type = this.reader.getAttributeValue(null, "mtype");
                            if (type != null && type.equals("seg")) {
                                if (!current.isEmpty()) {
                                    content.append(current, !content.hasBeenSegmented());
                                    changeFirstPart = !content.hasBeenSegmented();
                                }
                                idStack.push(++id);
                                segIdStack = id;
                                segment = new Segment();
                                segment.id = this.reader.getAttributeValue(null, "mid");
                                current = segment.text;
                                current.invalidate();
                                break;
                            }
                            if (type != null && type.equals("protected")) {
                                int mid = this.retrieveId(id, this.reader.getAttributeValue(null, "mid"), false, true);
                                code = this.appendCode(TextFragment.TagType.PLACEHOLDER, mid, name, name, store, current);
                                code.setDeleteable(false);
                                break;
                            }
                        }
                        if (name.equals("g")) {
                            id = this.retrieveId(id, this.reader.getAttributeValue(null, "id"), false, false);
                            idStack.push(id);
                            code = current.append(TextFragment.TagType.OPENING, name, "", id);
                            code.setOuterData(this.buildStartCode());
                            break;
                        }
                        if (name.equals("mrk")) {
                            int mid = this.retrieveId(id, this.reader.getAttributeValue(null, "mid"), false, true);
                            idStack.push(mid);
                            code = current.append(TextFragment.TagType.OPENING, name, "", mid);
                            GenericAnnotations anns = this.itsFilterHandler.readInlineCodeITSAttributes();
                            if (anns != null) {
                                annIds.add(mid);
                                GenericAnnotations.addAnnotations(code, anns);
                                code.setType("_annotation_");
                            }
                            code.setOuterData(this.buildStartCode());
                            break;
                        }
                        if (name.equals("x")) {
                            id = this.retrieveId(id, this.reader.getAttributeValue(null, "id"), false, false);
                            this.appendCode(TextFragment.TagType.PLACEHOLDER, id, name, name, store, current);
                            break;
                        }
                        if (name.equals("bx")) {
                            id = this.retrieveId(id, this.reader.getAttributeValue(null, "id"), false, false);
                            this.appendCode(TextFragment.TagType.OPENING, id, name, "Xpt", store, current);
                            break;
                        }
                        if (name.equals("ex")) {
                            id = this.retrieveId(id, this.reader.getAttributeValue(null, "id"), true, false);
                            this.appendCode(TextFragment.TagType.CLOSING, id, name, "Xpt", store, current);
                            break;
                        }
                        if (name.equals("bpt")) {
                            id = this.retrieveId(id, this.reader.getAttributeValue(null, "id"), false, false);
                            this.appendCode(TextFragment.TagType.OPENING, id, name, "Xpt", store, current);
                            break;
                        }
                        if (name.equals("ept")) {
                            id = this.retrieveId(id, this.reader.getAttributeValue(null, "id"), true, false);
                            this.appendCode(TextFragment.TagType.CLOSING, id, name, "Xpt", store, current);
                            break;
                        }
                        if (name.equals("ph")) {
                            id = this.retrieveId(id, this.reader.getAttributeValue(null, "id"), false, false);
                            this.appendCode(TextFragment.TagType.PLACEHOLDER, id, name, name, store, current);
                            break;
                        }
                        if (!name.equals("it")) break;
                        id = this.retrieveId(id, this.reader.getAttributeValue(null, "id"), false, false);
                        String tmp = this.reader.getAttributeValue(null, "pos");
                        TextFragment.TagType tt = TextFragment.TagType.PLACEHOLDER;
                        if (tmp == null) {
                            this.logger.error("Missing pos attribute for <it> element.");
                        } else if (tmp.equals("close")) {
                            tt = TextFragment.TagType.CLOSING;
                        } else if (tmp.equals("open")) {
                            tt = TextFragment.TagType.OPENING;
                        } else {
                            this.logger.error("Invalid value '{}' for pos attribute.", (Object)tmp);
                        }
                        this.appendCode(tt, id, name, name, store, current);
                    }
                }
            }
            return content;
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
    }

    private String buildStartCode() {
        int i;
        String prefix = this.reader.getPrefix();
        StringBuilder tmpg = new StringBuilder();
        if (prefix != null && prefix.length() > 0) {
            tmpg.append("<" + prefix + ":" + this.reader.getLocalName());
        } else {
            tmpg.append("<" + this.reader.getLocalName());
        }
        int count = this.reader.getNamespaceCount();
        for (i = 0; i < count; ++i) {
            prefix = this.reader.getNamespacePrefix(i);
            tmpg.append(" xmlns");
            if (!Util.isEmpty(prefix)) {
                tmpg.append(":" + prefix);
            }
            tmpg.append("=\"");
            tmpg.append(this.reader.getNamespaceURI(i));
            tmpg.append("\"");
        }
        count = this.reader.getAttributeCount();
        for (i = 0; i < count; ++i) {
            if (!this.reader.isAttributeSpecified(i)) continue;
            prefix = this.reader.getAttributePrefix(i);
            tmpg.append(" ");
            if (prefix != null && prefix.length() != 0) {
                tmpg.append(prefix + ":");
            }
            tmpg.append(this.reader.getAttributeLocalName(i));
            tmpg.append("=\"");
            tmpg.append(Util.escapeToXML(this.reader.getAttributeValue(i), 3, this.params.getEscapeGT(), null));
            tmpg.append("\"");
        }
        tmpg.append(">");
        return tmpg.toString();
    }

    private int retrieveId(int currentIdValue, String id, boolean useMinusOneasDefault, boolean useAutoMid) {
        if (id == null || id.length() == 0) {
            if (useAutoMid) {
                return --this.autoMid;
            }
            return useMinusOneasDefault ? -1 : ++currentIdValue;
        }
        try {
            return Integer.valueOf(id);
        }
        catch (NumberFormatException e) {
            return id.hashCode();
        }
    }

    private Code appendCode(TextFragment.TagType tagType, int id, String tagName, String type, boolean store, TextFragment content) {
        try {
            String prefix;
            int endStack = 1;
            StringBuilder innerCode = new StringBuilder();
            StringBuilder outerCode = null;
            outerCode = new StringBuilder();
            outerCode.append("<" + tagName);
            int count = this.reader.getAttributeCount();
            for (int i = 0; i < count; ++i) {
                if (!this.reader.isAttributeSpecified(i)) continue;
                prefix = this.reader.getAttributePrefix(i);
                outerCode.append(" ");
                if (prefix != null && prefix.length() != 0) {
                    outerCode.append(prefix + ":");
                }
                outerCode.append(this.reader.getAttributeLocalName(i));
                outerCode.append("=\"");
                outerCode.append(Util.escapeToXML(this.reader.getAttributeValue(i), 3, this.params.getEscapeGT(), null));
                outerCode.append("\"");
            }
            outerCode.append(">");
            while (this.reader.hasNext()) {
                int eventType = this.reader.next();
                switch (eventType) {
                    case 1: {
                        int i;
                        if (store) {
                            this.storeStartElement(false, false);
                        } else {
                            this.pushAnnotatorsRef();
                        }
                        StringBuilder tmpg = new StringBuilder();
                        if (this.reader.getLocalName().equals("sub")) {
                            this.logger.warn("A <sub> element was detected. It will be included in its parent code as <sub> is currently not supported.");
                        } else if (tagName.equals(this.reader.getLocalName())) {
                            ++endStack;
                        }
                        prefix = this.reader.getPrefix();
                        if (prefix == null || prefix.length() == 0) {
                            tmpg.append("<" + this.reader.getLocalName());
                        } else {
                            tmpg.append("<" + prefix + ":" + this.reader.getLocalName());
                        }
                        count = this.reader.getNamespaceCount();
                        for (i = 0; i < count; ++i) {
                            prefix = this.reader.getNamespacePrefix(i);
                            tmpg.append(" xmlns");
                            if (!Util.isEmpty(prefix)) {
                                tmpg.append(":" + prefix);
                            }
                            tmpg.append("=\"");
                            tmpg.append(this.reader.getNamespaceURI(i));
                            tmpg.append("\"");
                        }
                        count = this.reader.getAttributeCount();
                        for (i = 0; i < count; ++i) {
                            if (!this.reader.isAttributeSpecified(i)) continue;
                            prefix = this.reader.getAttributePrefix(i);
                            tmpg.append(" ");
                            if (prefix != null && prefix.length() != 0) {
                                tmpg.append(prefix + ":");
                            }
                            tmpg.append(this.reader.getAttributeLocalName(i));
                            tmpg.append("=\"");
                            tmpg.append(Util.escapeToXML(this.reader.getAttributeValue(i), 3, this.params.getEscapeGT(), null));
                            tmpg.append("\"");
                        }
                        tmpg.append(">");
                        innerCode.append(tmpg.toString());
                        outerCode.append(tmpg.toString());
                        break;
                    }
                    case 2: {
                        if (store) {
                            this.storeEndElement();
                        } else {
                            this.popAnnotatorsRef();
                        }
                        if (tagName.equals(this.reader.getLocalName()) && --endStack == 0) {
                            Code code = content.append(tagType, type, innerCode.toString(), id);
                            if (innerCode.length() == 0) {
                                outerCode.insert(outerCode.length() - 1, '/');
                            } else {
                                outerCode.append("</" + tagName + ">");
                            }
                            code.setOuterData(outerCode.toString());
                            return code;
                        }
                        prefix = this.reader.getPrefix();
                        if (prefix == null || prefix.length() == 0) {
                            innerCode.append("</" + this.reader.getLocalName() + ">");
                            outerCode.append("</" + this.reader.getLocalName() + ">");
                            break;
                        }
                        innerCode.append("</" + prefix + ":" + this.reader.getLocalName() + ">");
                        outerCode.append("</" + prefix + ":" + this.reader.getLocalName() + ">");
                        break;
                    }
                    case 4: 
                    case 6: 
                    case 12: {
                        innerCode.append(this.reader.getText());
                        outerCode.append(Util.escapeToXML(this.reader.getText(), 0, this.params.getEscapeGT(), null));
                        if (!store) break;
                        this.skel.append(Util.escapeToXML(this.reader.getText(), 0, this.params.getEscapeGT(), null));
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
        return null;
    }

    private void processNote() {
        try {
            String dest = this.reader.getAttributeValue(null, "annotates");
            if (dest == null) {
                dest = "";
            }
            Property prop = null;
            StringBuilder tmp = new StringBuilder();
            prop = dest.equals("source") ? this.tu.getSourceProperty("note") : (dest.equals("target") ? this.tu.getTargetProperty(this.trgLang, "note") : this.tu.getProperty("note"));
            if (prop == null) {
                prop = new Property("note", "", true);
            } else {
                tmp.append(prop.getValue());
                tmp.append("\n---\n");
            }
            while (this.reader.hasNext()) {
                int eventType = this.reader.next();
                switch (eventType) {
                    case 4: 
                    case 6: 
                    case 12: {
                        this.skel.append(Util.escapeToXML(this.reader.getText(), 0, this.params.getEscapeGT(), null));
                        tmp.append(this.reader.getText());
                        break;
                    }
                    case 2: {
                        String name = this.reader.getLocalName();
                        if (!name.equals("note")) break;
                        prop.setValue(tmp.toString());
                        if (dest.equals("source")) {
                            this.tu.setSourceProperty(prop);
                        } else if (dest.equals("target")) {
                            this.tu.setTargetProperty(this.trgLang, prop);
                        } else {
                            this.tu.setProperty(prop);
                        }
                        return;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
    }

    private boolean processStartGroup() {
        String mergeTrans = this.reader.getAttributeValue(null, "merge-trans");
        if (mergeTrans != null && mergeTrans.equals("yes")) {
            this.storeStartElement(false, false);
            this.parentIds.push(null);
            return false;
        }
        String grpId = this.reader.getAttributeValue(null, "id");
        if (grpId == null || this.groupUsedIds.contains(grpId)) {
            grpId = this.groupId.createIdNotInList(this.groupUsedIds);
        } else {
            this.groupId.setLastId(grpId);
        }
        this.groupUsedIds.add(grpId);
        StartGroup group = new StartGroup(this.parentIds.peek().toString(), grpId);
        group.setSkeleton(this.skel);
        this.parentIds.push(this.groupId.getLastId());
        this.queue.add(new Event(EventType.START_GROUP, group));
        String tmp = this.reader.getAttributeValue(null, "resname");
        if (tmp != null) {
            group.setName(tmp);
        } else if (this.params.getFallbackToID()) {
            group.setName(this.reader.getAttributeValue(null, "id"));
        }
        group.setType(this.reader.getAttributeValue(null, "restype"));
        this.storeStartElementGroup(group);
        ITSProvenanceAnnotations prov = this.itsFilterHandler.readITSProvenance();
        ITSProvenanceAnnotations.addAnnotations(group, prov);
        return true;
    }

    private boolean processEndGroup() {
        String id = this.parentIds.pop();
        if (id == null) {
            return false;
        }
        Ending ending = new Ending(id);
        ending.setSkeleton(this.skel);
        this.queue.add(new Event(EventType.END_GROUP, ending));
        return true;
    }

    private boolean processStartBinUnit() {
        this.storeStartElement(false, false);
        String tmp = this.reader.getAttributeValue(null, "id");
        if (tmp == null) {
            throw new OkapiIllegalFilterOperationException("Missing attribute 'id'.");
        }
        StartGroup group = new StartGroup(this.parentIds.peek().toString(), this.groupId.createId());
        group.setSkeleton(this.skel);
        this.parentIds.push(this.groupId.getLastId());
        this.queue.add(new Event(EventType.START_GROUP, group));
        tmp = this.reader.getAttributeValue(null, "resname");
        if (tmp != null) {
            group.setName(tmp);
        } else if (this.params.getFallbackToID()) {
            group.setName(this.reader.getAttributeValue(null, "id"));
        }
        group.setType(this.reader.getAttributeValue(null, "restype"));
        return true;
    }

    private boolean processEndBinUnit() {
        String id = this.parentIds.pop();
        Ending ending = new Ending(id);
        ending.setSkeleton(this.skel);
        this.queue.add(new Event(EventType.END_GROUP, ending));
        return true;
    }

    private void pushAnnotatorsRef() {
        String val = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "annotatorsRef");
        if (val != null) {
            Map<String, String> oldMap = ITSContent.annotatorsRefToMap(this.annotatorsRef.peek());
            Map<String, String> newMap = ITSContent.annotatorsRefToMap(val);
            oldMap.putAll(newMap);
            val = ITSContent.mapToAnnotatorsRef(oldMap);
        } else {
            val = this.annotatorsRef.peek();
        }
        this.annotatorsRef.push(val);
    }

    private String popAnnotatorsRef() {
        return this.annotatorsRef.pop();
    }
}

