/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xliff;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.annotation.GenericAnnotations;
import net.sf.okapi.common.annotation.ITSLQIAnnotations;
import net.sf.okapi.common.annotation.ITSProvenanceAnnotations;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.filters.xliff.its.IITSDataStore;
import net.sf.okapi.filters.xliff.its.ITSStandoffManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XLIFFITSFilterExtension {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ITSStandoffManager itsStandoffManager;
    private XMLStreamReader reader;
    private XMLInputFactory xmlFactory;
    private URI docURI;

    public XLIFFITSFilterExtension(XMLInputFactory xmlFactory, IITSDataStore datastore, URI docURI) {
        this.xmlFactory = xmlFactory;
        this.itsStandoffManager = new ITSStandoffManager(datastore);
        this.docURI = docURI;
    }

    public File parseInDocumentITSStandoff(XMLEventReader eventReader, String inStreamCharset) {
        return this.itsStandoffManager.parseXLIFF(eventReader, "", inStreamCharset);
    }

    public static int[] parseXLQIPos(String data, Logger logger) {
        int[] values = new int[]{0, -1, 0, -1};
        String[] items = data.split("\\s", 0);
        if (items.length != 4) {
            logger.warn("Invalid set of values for lqiPos: '{}'.", (Object)data);
        } else {
            try {
                values[0] = Integer.valueOf(items[0]);
                values[1] = Integer.valueOf(items[1]);
                values[2] = Integer.valueOf(items[2]);
                values[3] = Integer.valueOf(items[3]);
            }
            catch (NumberFormatException e) {
                logger.warn("At least one value is invalid in lqiPos: '{}'.", (Object)data);
            }
        }
        return values;
    }

    public void setXLIFFReader(XMLStreamReader reader) {
        this.reader = reader;
    }

    public ITSStandoffManager getITSStandoffManager() {
        return this.itsStandoffManager;
    }

    protected void readTextUnitITSAttributes(ITextUnit resource) {
        GenericAnnotations anns = new GenericAnnotations();
        String val1 = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "locQualityIssuesRef");
        if (val1 != null) {
            ITSLQIAnnotations lqiAnn = this.readITSLQI();
            ITSLQIAnnotations.addAnnotations(resource, lqiAnn);
            anns.addAll(lqiAnn);
        } else {
            val1 = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "locQualityIssueComment");
            String val2 = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "locQualityIssueType");
            if (val1 != null || val2 != null) {
                this.logger.warn("ITS Localization Quality Issue data category is to be used only on the main source and target and on mrk.");
            }
        }
        ITSProvenanceAnnotations provAnn = this.readITSProvenance();
        ITSProvenanceAnnotations.addAnnotations(resource, provAnn);
        anns.addAll(provAnn);
        anns.add(this.readITSExternalResource());
        anns.add(this.readITSLocaleFilter());
        val1 = this.reader.getAttributeValue("http://www.w3.org/ns/its-xliff/", "domains");
        if (val1 != null) {
            anns.add(new GenericAnnotation("its-domain", "domainValue", val1));
        }
        if (anns.size() > 0) {
            GenericAnnotations.addAnnotations(resource, anns);
        }
    }

    protected GenericAnnotations readTextContainerITSAttributes() {
        GenericAnnotations anns = new GenericAnnotations();
        anns.addAll(this.readITSLQI());
        anns.addAll(this.readITSProvenance());
        anns.add(this.readITSAllowedCharacters());
        anns.add(this.readITSStorageSize());
        return anns.size() > 0 ? anns : null;
    }

    protected GenericAnnotations readInlineCodeITSAttributes() {
        GenericAnnotations anns = new GenericAnnotations();
        anns.addAll(this.readITSLQI());
        anns.add(this.readITSAllowedCharacters());
        anns.add(this.readITSStorageSize());
        anns.add(this.readITSExternalResource());
        anns.add(this.readITSLocaleFilter());
        String mtype = this.reader.getAttributeValue(null, "mtype");
        if (mtype != null) {
            String taClassRef;
            String val1;
            if (mtype.equals("term")) {
                String info = this.reader.getAttributeValue("http://www.w3.org/ns/its-xliff/", "termInfo");
                String infoRef = this.reader.getAttributeValue("http://www.w3.org/ns/its-xliff/", "termInfoRef");
                if (info != null && infoRef != null) {
                    this.logger.error("Cannot have both termInfo and termInfoRef on the same element. termInfo will be used.");
                } else if (infoRef != null) {
                    info = "REF:" + infoRef;
                }
                val1 = this.reader.getAttributeValue("http://www.w3.org/ns/its-xliff/", "termConfidence");
                Double conf = null;
                if (val1 != null) {
                    conf = Double.parseDouble(val1);
                }
                anns.add(new GenericAnnotation("its-term", "termInfo", info, "termConfidence", conf));
            }
            if ((taClassRef = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "taClassRef")) != null) {
                taClassRef = "REF:" + taClassRef;
            }
            String taSource = null;
            String taIdent = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "taIdentRef");
            if (taIdent != null) {
                taIdent = "REF:" + taIdent;
            } else {
                taIdent = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "taIdent");
                taSource = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "taSource");
            }
            if (taClassRef != null || taIdent != null) {
                val1 = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "taConfidence");
                Double conf = null;
                if (val1 != null) {
                    conf = Double.parseDouble(val1);
                }
                anns.add(new GenericAnnotation("its-ta", "taClass", taClassRef, "taSource", taSource, "taIdent", taIdent, "taConfidence", conf));
            }
            if ((val1 = this.reader.getAttributeValue(null, "comment")) != null) {
                anns.add(new GenericAnnotation("its-ln", "lnValue", val1));
            }
        }
        return anns.size() > 0 ? anns : null;
    }

    protected ITSLQIAnnotations readITSLQI() {
        ITSLQIAnnotations lqiAnns = new ITSLQIAnnotations();
        String val1 = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "locQualityIssuesRef");
        if (val1 != null) {
            String r = XLIFFITSFilterExtension.getResourcePart(val1);
            if (!r.equals("")) {
                this.fetchStandoffData(r);
            }
            this.itsStandoffManager.addLQIAnnotation(lqiAnns, val1);
        } else {
            val1 = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "locQualityIssueComment");
            String val2 = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "locQualityIssueType");
            if (val1 != null || val2 != null) {
                GenericAnnotation ann = new GenericAnnotation("its-lqi", "lqiComment", val1, "lqiType", val2);
                val1 = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "locQualityIssueSeverity");
                if (val1 != null) {
                    ann.setDouble("lqiSeverity", Double.parseDouble(val1));
                }
                if ((val1 = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "locQualityIssueProfileRef")) != null) {
                    ann.setString("lqiProfileRef", val1);
                }
                if ((val1 = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "locQualityIssueEnabled")) != null) {
                    ann.setBoolean("lqiEnabled", val1.equals("yes"));
                }
                if ((val1 = this.reader.getAttributeValue("okapi-framework:xliff-extensions", "lqiPos")) != null) {
                    int[] values = XLIFFITSFilterExtension.parseXLQIPos(val1, this.logger);
                    ann.setInteger("lqiXStart", values[0]);
                    ann.setInteger("lqiXEnd", values[1]);
                    ann.setInteger("lqiXTrgStart", values[2]);
                    ann.setInteger("lqiXTrgEnd", values[3]);
                }
                if ((val1 = this.reader.getAttributeValue("okapi-framework:xliff-extensions", "lqiCodes")) != null) {
                    ann.setString("lqiXCodes", val1);
                }
                if ((val1 = this.reader.getAttributeValue("okapi-framework:xliff-extensions", "lqiSegId")) != null) {
                    ann.setString("lqiXSegId", val1);
                }
                lqiAnns.add(ann);
            }
        }
        return lqiAnns.size() > 0 ? lqiAnns : null;
    }

    protected ITSProvenanceAnnotations readITSProvenance() {
        ITSProvenanceAnnotations provAnns = new ITSProvenanceAnnotations();
        String val1 = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "provenanceRecordsRef");
        if (val1 != null) {
            String r = XLIFFITSFilterExtension.getResourcePart(val1);
            if (!r.equals("")) {
                this.fetchStandoffData(r);
            }
            this.itsStandoffManager.addProvAnnotation(provAnns, val1);
        }
        return provAnns.size() > 0 ? provAnns : null;
    }

    protected GenericAnnotation readITSAllowedCharacters() {
        String val1 = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "allowedCharacters");
        return val1 == null ? null : new GenericAnnotation("its-allowedchars", "allowedcharsValue", val1);
    }

    protected GenericAnnotation readITSStorageSize() {
        GenericAnnotation ann = null;
        String val1 = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "storageSize");
        if (val1 != null) {
            String lb;
            String enc = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "storageEncoding");
            if (enc == null) {
                enc = "UTF-8";
            }
            if ((lb = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "lineBreakType")) == null) {
                lb = "lf";
            }
            ann = new GenericAnnotation("its-storagesize", "storagesizeSize", Integer.parseInt(val1), "storagesizeEncoding", enc, "storagesizeLinebreak", lb);
        }
        return ann;
    }

    protected GenericAnnotation readITSExternalResource() {
        String val1 = this.reader.getAttributeValue("http://www.w3.org/ns/its-xliff/", "externalResourceRef");
        return val1 == null ? null : new GenericAnnotation("its-externalres", "its-externalresValue", val1);
    }

    protected GenericAnnotation readITSLocaleFilter() {
        String val1 = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "localeFilterList");
        if (val1 != null) {
            String val2 = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "localeFilterType");
            if (val2 != null) {
                if (val2.equals("exclude")) {
                    val1 = "!" + val1;
                } else if (val2.equals("include")) {
                    this.logger.warn("Invalid value for ITS localeFilterType ({}).", (Object)val2);
                    return null;
                }
            }
            return new GenericAnnotation("its-locfilter", "its-locfilterValue", val1);
        }
        return null;
    }

    private void fetchStandoffData(String resource) {
        if (!this.itsStandoffManager.alreadyParsed(resource)) {
            URL resourceURL;
            try {
                resourceURL = new URL(resource);
            }
            catch (MalformedURLException ex) {
                if (this.docURI != null) {
                    try {
                        resourceURL = this.docURI.resolve(resource).toURL();
                    }
                    catch (MalformedURLException ex1) {
                        this.logger.warn("Resource '" + resource + "' not a valid URL", ex);
                        throw new OkapiIOException("Bad uri for resource: " + resource, ex1);
                    }
                }
                throw new OkapiIOException("Resource '" + resource + "' not a valid URL", ex);
            }
            try {
                InputStream is = resourceURL.openStream();
                String charset = "UTF-8";
                BOMNewlineEncodingDetector detector = new BOMNewlineEncodingDetector(is, charset);
                detector.detectBom();
                if (detector.isAutodetected()) {
                    charset = detector.getEncoding();
                }
                InputStreamReader externalResource = new InputStreamReader(is, charset);
                File tmp = this.itsStandoffManager.parseXLIFF(this.xmlFactory.createXMLEventReader(externalResource), resource, charset);
                tmp.delete();
            }
            catch (MalformedURLException ex) {
                throw new OkapiIOException("Bad url for resource: " + resource, ex);
            }
            catch (IOException ex) {
                throw new OkapiIOException("Cannot find resource: " + resource, ex);
            }
            catch (XMLStreamException ex) {
                throw new OkapiIOException("Cannot open XML document.\n", ex);
            }
        }
    }

    protected static String getResourcePart(String uriRef) {
        int pn = uriRef.lastIndexOf(35);
        return pn > 0 ? uriRef.substring(0, pn) : "";
    }

    protected static String getFragmentIdPart(String uriRef) {
        int pn = uriRef.lastIndexOf(35);
        return uriRef.substring(pn + 1);
    }
}

