/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xliff.its;

import java.util.Iterator;
import javax.xml.stream.events.Attribute;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.annotation.IssueAnnotation;
import net.sf.okapi.common.annotation.IssueType;
import net.sf.okapi.filters.xliff.XLIFFITSFilterExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ITSLQI {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private IssueAnnotation ann = new IssueAnnotation();

    public ITSLQI(Iterator<Attribute> attrs) {
        while (attrs.hasNext()) {
            Attribute attr = attrs.next();
            String prefix = attr.getName().getPrefix();
            String name = attr.getName().getLocalPart();
            String ns = attr.getName().getNamespaceURI();
            String value = attr.getValue();
            String prefixedName = name;
            if (!prefix.isEmpty() && !prefix.equals("its")) {
                prefixedName = prefix + ":" + name;
            }
            if (ns.isEmpty() || ns.equals("http://www.w3.org/2005/11/its")) {
                if (name.equals("locQualityIssueType")) {
                    this.ann.setITSType(value);
                    continue;
                }
                if (name.equals("locQualityIssueComment")) {
                    this.ann.setComment(value);
                    continue;
                }
                if (name.equals("locQualityIssueSeverity")) {
                    this.ann.setSeverity(Double.parseDouble(value));
                    continue;
                }
                if (name.equals("locQualityIssueProfileRef")) {
                    this.ann.setProfileRef(value);
                    continue;
                }
                if (name.equals("locQualityIssueEnabled")) {
                    this.ann.setEnabled(value.equals("yes"));
                    continue;
                }
                this.logger.warn("Unknown attribute '{}'.", (Object)prefixedName);
                continue;
            }
            if (ns.equals("okapi-framework:xliff-extensions")) {
                if (name.equals("lqiType")) {
                    this.ann.setIssueType(IssueType.valueOf(value));
                    continue;
                }
                if (name.equals("lqiPos")) {
                    int[] positions = XLIFFITSFilterExtension.parseXLQIPos(value, this.logger);
                    this.ann.setSourcePosition(positions[0], positions[1]);
                    this.ann.setTargetPosition(positions[2], positions[3]);
                    continue;
                }
                if (name.equals("lqiCodes")) {
                    this.ann.setCodes(value);
                    continue;
                }
                if (name.equals("lqiSegId")) {
                    this.ann.setsegId(value);
                    continue;
                }
                this.logger.warn("Unknown attribute '{}'.", (Object)prefixedName);
                continue;
            }
            this.logger.warn("Unknown attribute '{}'.", (Object)prefixedName);
        }
    }

    public String getType() {
        return this.ann.getITSType();
    }

    public double getSeverity() {
        return this.ann.getSeverity();
    }

    public String getComment() {
        return this.ann.getComment();
    }

    public String getProfileRef() {
        return this.ann.getProfileRef();
    }

    public boolean getEnabled() {
        return this.ann.getEnabled();
    }

    public GenericAnnotation getAnnotation() {
        if (this.ann.getFieldCount() == 0) {
            return null;
        }
        return this.ann;
    }
}

