/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xliff.its;

import java.util.Iterator;
import javax.xml.stream.events.Attribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITSProvenance {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String person;
    private String org;
    private String tool;
    private String revPerson;
    private String revOrg;
    private String revTool;
    private String provRef;

    public ITSProvenance(Iterator<Attribute> attrs) {
        while (attrs.hasNext()) {
            Attribute attr = attrs.next();
            String prefix = attr.getName().getPrefix();
            String name = attr.getName().getLocalPart();
            String value = attr.getValue();
            if (!prefix.isEmpty() && !prefix.equals("its")) {
                name = prefix + ":" + name;
            }
            if (name.equals("person")) {
                this.setPerson(value);
                continue;
            }
            if (name.equals("personRef")) {
                this.setPerson("REF:" + value);
                continue;
            }
            if (name.equals("org")) {
                this.setOrg(value);
                continue;
            }
            if (name.equals("orgRef")) {
                this.setOrg("REF:" + value);
                continue;
            }
            if (name.equals("tool")) {
                this.setTool(value);
                continue;
            }
            if (name.equals("toolRef")) {
                this.setTool("REF:" + value);
                continue;
            }
            if (name.equals("revPerson")) {
                this.setRevPerson(value);
                continue;
            }
            if (name.equals("revPersonRef")) {
                this.setRevPerson("REF:" + value);
                continue;
            }
            if (name.equals("revOrg")) {
                this.setRevOrg(value);
                continue;
            }
            if (name.equals("revOrgRef")) {
                this.setRevOrg("REF:" + value);
                continue;
            }
            if (name.equals("revTool")) {
                this.setRevTool(value);
                continue;
            }
            if (name.equals("revToolRef")) {
                this.setRevTool("REF:" + value);
                continue;
            }
            if (name.equals("provRef")) {
                this.provRef = value;
                continue;
            }
            this.logger.warn("Unrecognized ITS Provenance attribute: " + name);
        }
    }

    public String getPerson() {
        return this.person;
    }

    public final void setPerson(String person) {
        if (this.person != null) {
            this.logger.warn("Provenance person redefined from \"" + this.person + "\" to \"" + person + "\"");
        }
        this.person = person;
    }

    public String getOrg() {
        return this.org;
    }

    public final void setOrg(String org) {
        if (this.org != null) {
            this.logger.warn("Provenance org redefined from \"" + this.org + "\" to \"" + org + "\"");
        }
        this.org = org;
    }

    public String getTool() {
        return this.tool;
    }

    public final void setTool(String tool) {
        if (this.tool != null) {
            this.logger.warn("Provenance tool redefined from \"" + this.tool + "\" to \"" + tool + "\"");
        }
        this.tool = tool;
    }

    public String getRevPerson() {
        return this.revPerson;
    }

    public final void setRevPerson(String revPerson) {
        if (this.revPerson != null) {
            this.logger.warn("Provenance revPerson redefined from \"" + this.revPerson + "\" to \"" + revPerson + "\"");
        }
        this.revPerson = revPerson;
    }

    public String getRevOrg() {
        return this.revOrg;
    }

    public final void setRevOrg(String revOrg) {
        if (this.revOrg != null) {
            this.logger.warn("Provenance revOrg redefined from \"" + this.revOrg + "\" to \"" + revOrg + "\"");
        }
        this.revOrg = revOrg;
    }

    public String getRevTool() {
        return this.revTool;
    }

    public final void setRevTool(String revTool) {
        if (this.revTool != null) {
            this.logger.warn("Provenance revTool redefined from \"" + this.revTool + "\" to \"" + revTool + "\"");
        }
        this.revTool = revTool;
    }

    public String getProvRef() {
        return this.provRef;
    }
}

