/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xliff.its;

import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.stream.events.Attribute;
import net.sf.okapi.filters.xliff.its.ITSProvenance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITSProvenanceCollection {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String resource;
    private String xmlid;
    private String xmlns;
    private String version;
    private LinkedList<ITSProvenance> records = new LinkedList();

    public ITSProvenanceCollection(Iterator<Attribute> attrs, String resource) {
        this.resource = resource;
        while (attrs.hasNext()) {
            Attribute attr = attrs.next();
            String prefix = attr.getName().getPrefix();
            String name = attr.getName().getLocalPart();
            String value = attr.getValue();
            if (!prefix.isEmpty()) {
                name = prefix + ":" + name;
            }
            if (name.equals("xml:id")) {
                this.xmlid = value;
                continue;
            }
            if (name.equals("xmlns:its")) {
                this.xmlns = value;
                continue;
            }
            if (name.equals("version")) {
                this.version = value;
                continue;
            }
            this.logger.warn("Unrecognized attribute: " + name);
        }
    }

    public void addProv(Iterator<Attribute> attrs) {
        this.records.add(new ITSProvenance(attrs));
    }

    public String getXMLId() {
        return this.xmlid;
    }

    public String getURI() {
        return this.resource + "#" + this.xmlid;
    }

    public Iterator<ITSProvenance> iterator() {
        return this.records.iterator();
    }
}

