/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.longhornapi.impl.rest;

import java.io.InputStream;
import java.net.URI;
import net.sf.okapi.lib.longhornapi.LonghornFile;
import net.sf.okapi.lib.longhornapi.impl.rest.RESTProject;

public class RESTFile
implements LonghornFile {
    private RESTProject project;
    private Filetype type;
    private String relativePath;

    protected RESTFile() {
    }

    protected RESTFile(RESTProject project, Filetype type, String relativePath) {
        this.project = project;
        this.type = type;
        this.relativePath = relativePath;
    }

    @Override
    public InputStream openStream() {
        try {
            URI remoteFile = new URI(this.project.getProjectURI() + this.getPathRelativeToProject());
            return remoteFile.toURL().openStream();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getPathRelativeToProject() {
        switch (this.type) {
            case input: {
                return "/inputFiles/" + this.relativePath;
            }
            case output: {
                return "/outputFiles/" + this.relativePath;
            }
        }
        throw new RuntimeException("Illegal type: " + (Object)((Object)this.type));
    }

    @Override
    public InputStream openStreamToZip() {
        try {
            URI remoteFile = new URI(this.project.getProjectURI() + "/outputFile.zip/" + this.relativePath + ".zip");
            return remoteFile.toURL().openStream();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getRelativePath() {
        return this.relativePath;
    }

    public String toString() {
        return this.getPathRelativeToProject();
    }

    public static enum Filetype {
        input,
        output;

    }
}

