/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.persistence.beans;

import net.sf.okapi.common.ClassUtil;
import net.sf.okapi.lib.persistence.IPersistenceBean;
import net.sf.okapi.lib.persistence.IPersistenceSession;
import net.sf.okapi.lib.persistence.PersistenceBean;

public class FactoryBean
extends PersistenceBean<Object> {
    private String className;
    private long reference;
    private Object content;

    @Override
    protected Object createObject(IPersistenceSession session) {
        return null;
    }

    @Override
    protected void fromObject(Object obj, IPersistenceSession session) {
    }

    @Override
    protected void setObject(Object obj, IPersistenceSession session) {
    }

    @Override
    public <T> T get(Class<T> classRef, IPersistenceSession session) {
        if (this.reference != 0L) {
            return classRef.cast(session.getObject(this.reference));
        }
        return classRef.cast(this.validateContent(session) ? ((IPersistenceBean)this.content).get(classRef, session) : null);
    }

    private boolean validateContent(IPersistenceSession session) {
        if (this.content == null) {
            return false;
        }
        if (this.className == null) {
            return false;
        }
        boolean res = this.content instanceof IPersistenceBean;
        if (!res) {
            if (session == null) {
                return false;
            }
            this.content = session.convert(this.content, session.getBeanClass(this.className));
            res = this.content instanceof IPersistenceBean;
        }
        return res;
    }

    @Override
    public IPersistenceBean<Object> set(Object obj, IPersistenceSession session) {
        if (obj == null) {
            return this;
        }
        this.className = ClassUtil.getQualifiedClassName(obj);
        long rid = session.getRefIdForObject(obj);
        IPersistenceBean<?> bean = session.uncacheBean(obj);
        if (bean == null && rid != 0L) {
            this.content = null;
            this.reference = rid;
            session.setRefIdForObject(this, this.getRefId());
            session.setReference(this.getRefId(), rid);
            return this;
        }
        if (bean == null) {
            bean = obj instanceof IPersistenceBean ? (IPersistenceBean<?>)obj : session.createBean(ClassUtil.getClass(obj));
        }
        this.reference = 0L;
        this.content = bean;
        session.setRefIdForObject(obj, bean.getRefId());
        session.setSerialized(obj);
        return bean instanceof FactoryBean ? this : bean.set(obj, session);
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public void setContent(Object content) {
        this.content = content;
    }

    public Object getContent() {
        return this.content;
    }

    public void setReference(long reference) {
        this.reference = reference;
    }

    public long getReference() {
        return this.reference;
    }
}

