/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.persistence.beans;

import net.sf.okapi.common.ClassUtil;
import net.sf.okapi.lib.persistence.IPersistenceBean;
import net.sf.okapi.lib.persistence.IPersistenceSession;
import net.sf.okapi.lib.persistence.PersistenceBean;

public class ReferenceBean
extends PersistenceBean<Object> {
    private long reference;
    private String className;

    @Override
    protected Object createObject(IPersistenceSession session) {
        IPersistenceBean<?> proxy;
        Object obj = session.getObject(this.reference);
        if (obj == null && (proxy = session.getProxy(this.className)) != null) {
            obj = proxy.get(session.getClass(this.className), session);
        }
        return obj;
    }

    @Override
    protected void fromObject(Object obj, IPersistenceSession session) {
        if (obj == null) {
            return;
        }
        this.className = ClassUtil.getQualifiedClassName(obj);
        session.setRefIdForObject(this, this.getRefId());
        long rid = session.getRefIdForObject(obj);
        if (rid != 0L) {
            this.reference = rid;
            session.setReference(this.getRefId(), rid);
            return;
        }
        IPersistenceBean<?> bean = obj instanceof IPersistenceBean ? (IPersistenceBean<?>)obj : session.createBean(ClassUtil.getClass(obj));
        session.cacheBean(obj, bean);
        this.reference = bean.getRefId();
        session.setReference(this.getRefId(), bean.getRefId());
    }

    @Override
    protected void setObject(Object obj, IPersistenceSession session) {
        if (obj != null) {
            session.setRefIdForObject(obj, this.reference);
        }
    }

    public void setReference(long reference) {
        this.reference = reference;
    }

    public long getReference() {
        return this.reference;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }
}

