/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.verification;

import java.util.List;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.XMLWriter;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.annotation.GenericAnnotations;
import net.sf.okapi.common.annotation.IssueAnnotation;

public class QualityCheckReport {
    private XMLWriter xmlWriter;
    private Type type = Type.HTML;

    public void startReport(String fullPath, Type type) {
        this.type = type;
        this.closeWriter();
        switch (type) {
            case HTML: {
                this.startReportInHTML(fullPath);
                break;
            }
            case XML: {
                this.startReportInXML(fullPath);
            }
        }
    }

    public void processAnnotations(GenericAnnotations annotations) {
        switch (this.type) {
            case HTML: {
                this.reportInHTML(annotations);
                break;
            }
            case XML: {
                this.reportInXML(annotations);
            }
        }
    }

    public void endReport() {
        switch (this.type) {
            case HTML: {
                this.endReportInHTML();
                break;
            }
            case XML: {
                this.endReportInXML();
            }
        }
    }

    public void closeWriter() {
        if (this.xmlWriter != null) {
            this.xmlWriter.close();
            this.xmlWriter = null;
        }
    }

    private void startReportInHTML(String fullPath) {
        this.xmlWriter = new XMLWriter(fullPath);
        this.xmlWriter.writeStartDocument();
        this.xmlWriter.writeStartElement("html");
        this.xmlWriter.writeRawXML("<head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" /><title>Quality Check Report</title><style type=\"text/css\">body { font-family: Verdana; font-size: smaller; }h1 { font-size: 110%; }h2 { font-size: 100%; }h3 { font-size: 100%; }p.s { font-family: Courier New, courier; font-size: 100%;   border: solid 1px; padding: 0.5em; margin-top:-0.7em; border-color: silver; background-color: #C0FFFF; }p.t { font-family: Courier New, courier; font-size: 100%; margin-top:-1.1em;   border: solid 1px; padding: 0.5em; border-color: silver; background-color: #C0FFC0; }span.hi { background-color: #FFFF00; }</style></head>");
        this.xmlWriter.writeStartElement("body");
        this.xmlWriter.writeLineBreak();
        this.xmlWriter.writeElementString("h1", "Quality Check Report");
    }

    private void reportInHTML(GenericAnnotations anns) {
        if (anns == null) {
            return;
        }
        List<GenericAnnotation> list = anns.getAnnotations("its-lqi");
        for (GenericAnnotation ann : list) {
            if (!ann.getBoolean("lqiEnabled").booleanValue()) continue;
            IssueAnnotation ia = null;
            if (!(ann instanceof IssueAnnotation)) continue;
            ia = (IssueAnnotation)ann;
        }
    }

    private void endReportInHTML() {
        this.xmlWriter.writeEndElementLineBreak();
        this.xmlWriter.writeEndElementLineBreak();
        this.xmlWriter.writeEndDocument();
        this.closeWriter();
    }

    private void startReportInXML(String fullPath) {
        this.xmlWriter = new XMLWriter(fullPath);
        this.xmlWriter.writeStartDocument();
        this.xmlWriter.writeStartElement("qualityCheckReport");
        this.xmlWriter.writeLineBreak();
        this.xmlWriter.writeStartElement("issues");
        this.xmlWriter.writeLineBreak();
    }

    private void reportInXML(GenericAnnotations anns) {
        if (anns == null) {
            return;
        }
        List<GenericAnnotation> list = anns.getAnnotations("its-lqi");
        for (GenericAnnotation ann : list) {
            if (!ann.getBoolean("lqiEnabled").booleanValue()) continue;
            IssueAnnotation ia = null;
            if (ann instanceof IssueAnnotation) {
                ia = (IssueAnnotation)ann;
            }
            this.xmlWriter.writeStartElement("issue");
            this.xmlWriter.writeLineBreak();
            this.xmlWriter.writeElementString("segId", ia == null ? "" : ia.getSegId());
            this.xmlWriter.writeElementString("severity", Util.formatDouble(ann.getDouble("lqiSeverity")));
            this.xmlWriter.writeElementString("issueType", ia == null ? "" : ia.getIssueType().toString());
            this.xmlWriter.writeElementString("message", ann.getString("lqiComment"));
            this.xmlWriter.writeEndElementLineBreak();
        }
    }

    private void endReportInXML() {
        this.xmlWriter.writeEndElementLineBreak();
        this.xmlWriter.writeEndElementLineBreak();
        this.xmlWriter.writeEndDocument();
        this.closeWriter();
    }

    public static enum Type {
        HTML,
        XML;

    }
}

