/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.lib.xliff.Res;
import net.sf.okapi.lib.xliff.Util;
import org.oasisopen.xliff.v2.ICMarker;
import org.oasisopen.xliff.v2.IMarker;
import org.oasisopen.xliff.v2.MarkerType;
import org.oasisopen.xliff.v2.OriginalDataStyle;

public class CMarker
implements ICMarker {
    private static final long serialVersionUID = 64L;
    private static final int CANDELETE = 1;
    private static final int CANCOPY = 2;
    private static final int CANREORDER = 4;
    private static final Pattern TYPEPATTERN = Pattern.compile("(.+?)(/((.+?):(.+?)))?");
    private Matcher typeMatcher;
    private String internalId;
    private MarkerType markerType;
    private String id;
    private String originalData;
    private OriginalDataStyle originalDataStyle = OriginalDataStyle.OUTSIDE;
    private int hints = 7;
    private boolean canOverlap;
    private String disp;
    private String equiv;
    private String type;
    private String subFlows;
    private String dataRef;

    public CMarker(MarkerType markerType, String id, String originalData) {
        if (markerType == null) {
            throw new RuntimeException(Res.t("markerTypeCantBeNull"));
        }
        if (id == null) {
            throw new RuntimeException(Res.t("idCantBeNull"));
        }
        this.markerType = markerType;
        this.id = id;
        this.internalId = Util.toInternalId(id, markerType);
        this.originalData = originalData;
    }

    @Override
    public CMarker deepCopy() {
        CMarker copy = new CMarker(this.markerType, this.id, this.originalData);
        this.setOriginalDataStyle(this.originalDataStyle);
        copy.canOverlap = this.canOverlap;
        copy.disp = this.disp;
        copy.hints = this.hints;
        copy.equiv = this.equiv;
        copy.dataRef = this.dataRef;
        copy.type = this.type;
        copy.subFlows = this.subFlows;
        copy.internalId = Util.toInternalId(copy.id, copy.markerType);
        return copy;
    }

    @Override
    public String getOriginalData() {
        return this.originalData;
    }

    @Override
    public void setOriginalData(String originalData) {
        this.originalData = originalData;
    }

    @Override
    public boolean hasOriginalData() {
        return !Util.isNullOrEmpty(this.originalData);
    }

    @Override
    public String getNid() {
        return this.getDataRef();
    }

    @Override
    public String getDataRef() {
        return this.dataRef;
    }

    @Override
    public void setNid(String nid) {
        this.setDataRef(nid);
    }

    @Override
    public void setDataRef(String dataRef) {
        this.dataRef = dataRef;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getInternalId() {
        return this.internalId;
    }

    @Override
    public MarkerType getMarkerType() {
        return this.markerType;
    }

    @Override
    public void setMarkerType(MarkerType markerType) {
        this.markerType = markerType;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.typeMatcher = null;
        this.type = type;
    }

    @Override
    public String getDisp() {
        return this.disp;
    }

    @Override
    public void setDisp(String disp) {
        this.disp = disp;
    }

    @Override
    public String getEquiv() {
        return this.equiv;
    }

    @Override
    public void setEquiv(String equiv) {
        this.equiv = equiv;
    }

    @Override
    public String getSubFlows() {
        return this.subFlows;
    }

    @Override
    public void setSubFlows(String subFlows) {
        this.subFlows = subFlows;
    }

    @Override
    public boolean getCanCopy() {
        return (this.hints & 2) == 2;
    }

    @Override
    public void setCanCopy(boolean canCopy) {
        this.hints = canCopy ? (this.hints |= 2) : (this.hints &= 0xFFFFFFFD);
    }

    @Override
    public boolean getCanDelete() {
        return (this.hints & 1) == 1;
    }

    @Override
    public void setCanDelete(boolean canDelete) {
        this.hints = canDelete ? (this.hints |= 1) : (this.hints &= 0xFFFFFFFE);
    }

    @Override
    public boolean getCanOverlap() {
        return this.canOverlap;
    }

    @Override
    public void setCanOverlap(boolean canOverlap) {
        this.canOverlap = canOverlap;
    }

    @Override
    public boolean getCanReorder() {
        return (this.hints & 4) == 4;
    }

    @Override
    public void setCanReorder(boolean canReorder) {
        this.hints = canReorder ? (this.hints |= 4) : (this.hints &= 0xFFFFFFFB);
    }

    @Override
    public boolean equals(IMarker marker) {
        if (marker == null) {
            throw new NullPointerException("The parameter 'marker' must not be null.");
        }
        if (this == marker) {
            return true;
        }
        if (!(marker instanceof ICMarker)) {
            return false;
        }
        ICMarker code = (ICMarker)marker;
        if (this.markerType.compareTo(code.getMarkerType()) != 0) {
            return false;
        }
        if (Util.compareAllowingNull(this.id, code.getId()) != 0) {
            return false;
        }
        if (Util.compareAllowingNull(this.type, code.getType()) != 0) {
            return false;
        }
        if (Util.compareAllowingNull(this.subFlows, code.getSubFlows()) != 0) {
            return false;
        }
        if (Util.compareAllowingNull(this.originalData, code.getOriginalData()) != 0) {
            return false;
        }
        if (Util.compareAllowingNull(this.disp, code.getDisp()) != 0) {
            return false;
        }
        if (Util.compareAllowingNull(this.equiv, code.getEquiv()) != 0) {
            return false;
        }
        if (code.getCanCopy() != this.getCanCopy()) {
            return false;
        }
        if (code.getCanDelete() != this.getCanDelete()) {
            return false;
        }
        if (code.getCanReorder() != this.getCanReorder()) {
            return false;
        }
        if (Util.compareAllowingNull(this.internalId, code.getInternalId()) != 0) {
            return false;
        }
        return this.markerType == MarkerType.PLACEHOLDER || this.canOverlap == code.getCanOverlap();
    }

    @Override
    public boolean isAnnotation() {
        return false;
    }

    @Override
    public boolean isCode() {
        return true;
    }

    @Override
    public OriginalDataStyle getOriginalDataStyle() {
        return this.originalDataStyle;
    }

    @Override
    public void setOriginalDataStyle(OriginalDataStyle originalDataStyle) {
        this.originalDataStyle = originalDataStyle;
    }

    @Override
    public String getCategoryInType() {
        if (this.type == null) {
            return null;
        }
        if (this.typeMatcher == null) {
            this.typeMatcher = TYPEPATTERN.matcher(this.type);
            this.typeMatcher.matches();
        }
        return this.typeMatcher.group(1);
    }

    @Override
    public String getSubCategoryInType() {
        if (this.type == null) {
            return null;
        }
        if (this.typeMatcher == null) {
            this.typeMatcher = TYPEPATTERN.matcher(this.type);
            this.typeMatcher.matches();
        }
        if (this.typeMatcher.groupCount() > 2) {
            return this.typeMatcher.group(3);
        }
        return null;
    }

    @Override
    public String getSubCategoryPrefixInType() {
        if (this.type == null) {
            return null;
        }
        if (this.typeMatcher == null) {
            this.typeMatcher = TYPEPATTERN.matcher(this.type);
            this.typeMatcher.matches();
        }
        if (this.typeMatcher.groupCount() > 3) {
            return this.typeMatcher.group(4);
        }
        return null;
    }

    @Override
    public String getSubCategoryValueInType() {
        if (this.type == null) {
            return null;
        }
        if (this.typeMatcher == null) {
            this.typeMatcher = TYPEPATTERN.matcher(this.type);
            this.typeMatcher.matches();
        }
        if (this.typeMatcher.groupCount() > 4) {
            return this.typeMatcher.group(5);
        }
        return null;
    }
}

