/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff;

import java.security.InvalidParameterException;
import net.sf.okapi.lib.xliff.DataStore;
import net.sf.okapi.lib.xliff.Fragment;
import org.oasisopen.xliff.v2.ICandidate;
import org.oasisopen.xliff.v2.IDataStore;
import org.oasisopen.xliff.v2.IFragment;

public class Candidate
implements ICandidate {
    private static final long serialVersionUID = 64L;
    private IFragment source;
    private IFragment target;
    private IDataStore store = new DataStore();
    private float similarity = -1.0f;
    private String type;
    private String origin;

    public Candidate() {
        this.source = new Fragment(this.store, false);
        this.target = new Fragment(this.store, true);
    }

    public Candidate(String sourceContent, String targetContent) {
        this.source = new Fragment(this.store, false, sourceContent);
        this.target = new Fragment(this.store, true, targetContent);
    }

    @Override
    public IFragment getSource() {
        return this.source;
    }

    @Override
    public IFragment getTarget() {
        return this.target;
    }

    @Override
    public float getSimilarity() {
        return this.similarity;
    }

    @Override
    public void setSimilarity(float similarity) {
        if (similarity < -1.0f || similarity > 100.0f) {
            throw new RuntimeException("Invalid similarity value.");
        }
        this.similarity = similarity;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        if (type != null && "|tm|mt|am|ib|cb|".indexOf("|" + type + "|") == -1) {
            throw new RuntimeException(String.format("Invalid match type value ('%s').", type));
        }
        this.type = type;
    }

    @Override
    public IDataStore getDataStore() {
        return this.store;
    }

    @Override
    public void setSource(IFragment fragment) {
        if (fragment == null) {
            throw new InvalidParameterException("Fragment cannot be null");
        }
        if (this.store != fragment.getDataStore()) {
            throw new RuntimeException("The fragment passed in setSource must use the same codes store.");
        }
        this.source = fragment;
    }

    @Override
    public void setTarget(IFragment fragment) {
        if (fragment == null) {
            throw new InvalidParameterException("Fragment cannot be null");
        }
        if (this.store != fragment.getDataStore()) {
            throw new RuntimeException("The fragment passed in setTarget must use the same codes store.");
        }
        this.target = fragment;
    }

    @Override
    public String getOrigin() {
        return this.origin;
    }

    @Override
    public void setOrigin(String origin) {
        this.origin = origin;
    }
}

