/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import net.sf.okapi.lib.xliff.ExtendedAttributes;
import org.oasisopen.xliff.v2.ExtendedChildType;
import org.oasisopen.xliff.v2.IExtendedAttributes;
import org.oasisopen.xliff.v2.IExtendedChild;
import org.oasisopen.xliff.v2.IExtendedContent;
import org.oasisopen.xliff.v2.IExtendedElement;

public class ExtendedElement
implements IExtendedElement {
    private static final long serialVersionUID = 64L;
    private QName qName;
    private IExtendedAttributes attrs;
    private ArrayList<IExtendedChild> children;
    private NamespaceContext nsContext;

    public ExtendedElement(QName qName, NamespaceContext nsContext) {
        this.qName = qName;
        this.nsContext = nsContext;
    }

    @Override
    public QName getQName() {
        return this.qName;
    }

    @Override
    public IExtendedAttributes getAttributes() {
        if (this.attrs == null) {
            this.attrs = new ExtendedAttributes();
        }
        return this.attrs;
    }

    @Override
    public void setExtendedAttributes(IExtendedAttributes attributes) {
        this.attrs = attributes;
    }

    @Override
    public ExtendedChildType getType() {
        return ExtendedChildType.ELEMENT;
    }

    @Override
    public List<IExtendedChild> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        return this.children;
    }

    @Override
    public IExtendedElement getFirstChildElement(String namespaceURI, String localName) {
        if (this.children == null) {
            return null;
        }
        QName qn = new QName(namespaceURI, localName);
        for (IExtendedChild child : this.children) {
            if (child.getType() != ExtendedChildType.ELEMENT || !((IExtendedElement)child).getQName().equals(qn)) continue;
            return (IExtendedElement)child;
        }
        return null;
    }

    @Override
    public IExtendedElement getFirstChildElement() {
        if (this.children == null) {
            return null;
        }
        for (IExtendedChild child : this.children) {
            if (child.getType() != ExtendedChildType.ELEMENT) continue;
            return (IExtendedElement)child;
        }
        return null;
    }

    @Override
    public IExtendedContent getFirstChildContent() {
        if (this.children == null) {
            return null;
        }
        for (IExtendedChild child : this.children) {
            if (child.getType() == ExtendedChildType.ELEMENT) continue;
            return (IExtendedContent)child;
        }
        return null;
    }

    @Override
    public IExtendedChild addChild(IExtendedChild child) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(child);
        return child;
    }
}

