/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.common.removetarget;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.TextInputPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    private static final String TUS_FOR_TARGET_REMOVAL = "tusForTargetRemoval";
    private static final String TARGET_LOCALES_TO_KEEP = "targetLocalesToKeep";
    private static final String FILTER_BASED_ON_IDS = "filterBasedOnIds";
    private static final String REMOVE_TU_IF_NO_TARGET = "removeTUIfNoTarget";
    private String tusForTargetRemoval;
    private String targetLocalesToKeep;
    private boolean filterBasedOnIds;
    private boolean removeTUIfNoTarget;

    public Parameters() {
        this.reset();
    }

    @Override
    public void reset() {
        this.tusForTargetRemoval = "";
        this.targetLocalesToKeep = "";
        this.filterBasedOnIds = true;
        this.removeTUIfNoTarget = false;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.tusForTargetRemoval = this.buffer.getString(TUS_FOR_TARGET_REMOVAL, this.tusForTargetRemoval);
        this.targetLocalesToKeep = this.buffer.getString(TARGET_LOCALES_TO_KEEP, this.targetLocalesToKeep);
        this.filterBasedOnIds = this.buffer.getBoolean(FILTER_BASED_ON_IDS, this.filterBasedOnIds);
        this.removeTUIfNoTarget = this.buffer.getBoolean(REMOVE_TU_IF_NO_TARGET, this.removeTUIfNoTarget);
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setString(TUS_FOR_TARGET_REMOVAL, this.tusForTargetRemoval);
        this.buffer.setString(TARGET_LOCALES_TO_KEEP, this.targetLocalesToKeep);
        this.buffer.setBoolean(FILTER_BASED_ON_IDS, this.filterBasedOnIds);
        this.buffer.setBoolean(REMOVE_TU_IF_NO_TARGET, this.removeTUIfNoTarget);
        return this.buffer.toString();
    }

    public void setTusForTargetRemoval(String tusForTargetRemoval) {
        this.tusForTargetRemoval = tusForTargetRemoval;
    }

    public String getTusForTargetRemoval() {
        return this.tusForTargetRemoval;
    }

    public void setTargetLocalesToKeep(String targetLocalesToKeep) {
        this.targetLocalesToKeep = targetLocalesToKeep;
    }

    public String getTargetLocalesToKeep() {
        return this.targetLocalesToKeep;
    }

    public boolean isFilterBasedOnIds() {
        return this.filterBasedOnIds;
    }

    public void setFilterBasedOnIds(boolean filterBasedOnIds) {
        this.filterBasedOnIds = filterBasedOnIds;
    }

    public boolean isRemoveTUIfNoTarget() {
        return this.removeTUIfNoTarget;
    }

    public void setRemoveTUIfNoTarget(boolean removeTUIfNoTarget) {
        this.removeTUIfNoTarget = removeTUIfNoTarget;
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(TUS_FOR_TARGET_REMOVAL, "Comma-delimited list of ids of the text units where targets are to be removed (empty - remove all targets)", null);
        desc.add(TARGET_LOCALES_TO_KEEP, "Comma-delimited list of locales of the text units of targets that should be kept (empty - keep all targets)", null);
        desc.add(FILTER_BASED_ON_IDS, "If true filter on ID's, if false filter on locales (you cannot filter on both)", null);
        desc.add(REMOVE_TU_IF_NO_TARGET, "If true remove the Text Unit if it has no remaining targets, if false do nothing", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Remove Target Options", true, false);
        desc.addCheckboxPart(paramsDesc.get(FILTER_BASED_ON_IDS));
        desc.addCheckboxPart(paramsDesc.get(REMOVE_TU_IF_NO_TARGET));
        TextInputPart tip = desc.addTextInputPart(paramsDesc.get(TUS_FOR_TARGET_REMOVAL));
        tip.setAllowEmpty(true);
        tip = desc.addTextInputPart(paramsDesc.get(TARGET_LOCALES_TO_KEEP));
        tip.setAllowEmpty(true);
        return desc;
    }
}

