/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.common.skeletonconversion;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.IReferenceable;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.MultiEvent;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.common.skeleton.ResourceSimplifier;
import net.sf.okapi.steps.common.tufiltering.ITextUnitFilter;
import net.sf.okapi.steps.common.tufiltering.TuFilteringStep;

public class SkeletonConversionStep
extends TuFilteringStep {
    private ResourceSimplifier simplifier;
    private ISkeletonWriter writer;
    private EncoderManager em;

    public SkeletonConversionStep() {
    }

    public SkeletonConversionStep(ITextUnitFilter tuFilter) {
        super(tuFilter);
    }

    @Override
    protected Event handleStartDocument(Event event) {
        StartDocument sd = event.getStartDocument();
        this.writer = sd.getFilterWriter().getSkeletonWriter();
        if (this.writer instanceof GenericSkeletonWriter) {
            this.simplifier = new ResourceSimplifier((GenericSkeletonWriter)this.writer, sd.getEncoding(), sd.getLocale());
        }
        this.em = sd.getFilterWriter().getEncoderManager();
        this.writer.processStartDocument(sd.getLocale(), sd.getEncoding(), null, this.em, sd);
        return super.handleStartDocument(event);
    }

    private void convertTu(ITextUnit tu, MultiEvent me) {
        String str = this.writer.processTextUnit(tu);
        TextUnit newTu = new TextUnit(tu.getId());
        newTu.setIsTranslatable(false);
        me.addEvent(new Event(EventType.TEXT_UNIT, newTu));
        me.addEvent(new Event(EventType.DOCUMENT_PART, new DocumentPart(String.format("dp_%s_conv", tu.getId()), false, new GenericSkeleton(str))));
    }

    @Override
    public Event handleEvent(Event event) {
        IResource res = event.getResource();
        if (res instanceof IReferenceable && ((IReferenceable)((Object)res)).isReferent()) {
            this.simplifier.convert(event);
        }
        return super.handleEvent(event);
    }

    @Override
    protected Event processFiltered(Event tuEvent) {
        ITextUnit tu = tuEvent.getTextUnit();
        if (tu.isReferent()) {
            return tuEvent;
        }
        Event e = this.simplifier.convert(tuEvent);
        MultiEvent newMe = new MultiEvent();
        if (e.isTextUnit()) {
            this.convertTu(tu, newMe);
        } else if (e.isMultiEvent()) {
            MultiEvent me = e.getMultiEvent();
            for (Event event : me) {
                if (event.isTextUnit()) {
                    tu = event.getTextUnit();
                    this.convertTu(tu, newMe);
                    continue;
                }
                newMe.addEvent(event);
            }
        }
        return new Event(EventType.MULTI_EVENT, newMe);
    }
}

