/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.desegmentation;

import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.steps.desegmentation.Parameters;
import net.sf.okapi.steps.segmentation.RenumberingUtil;

@UsingParameters(value=Parameters.class)
public class DesegmentationStep
extends BasePipelineStep {
    private Parameters params = new Parameters();
    private List<LocaleId> targetLocales;

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALES)
    public void setTargetLocales(List<LocaleId> targetLocales) {
        this.targetLocales = targetLocales;
    }

    public List<LocaleId> getTargetLocales() {
        return this.targetLocales;
    }

    @Override
    public String getName() {
        return "Desegmentation";
    }

    @Override
    public String getDescription() {
        return "Joins all segments into a single content. Expects: filter events. Sends back: filter events.";
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    protected Event handleTextUnit(Event event) {
        ITextUnit tu = event.getTextUnit();
        if (!tu.isTranslatable()) {
            return event;
        }
        if (this.params.getDesegmentSource() && tu.getSource().hasBeenSegmented()) {
            if (this.params.getRenumberCodes()) {
                RenumberingUtil.renumberCodesForDesegmentation(tu.getSource());
            }
            tu.getSource().getSegments().joinAll();
        }
        if (this.params.getDesegmentTarget() && this.targetLocales != null) {
            for (LocaleId targetLocale : this.targetLocales) {
                TextContainer cont = tu.getTarget(targetLocale);
                if (cont == null || !cont.hasBeenSegmented()) continue;
                if (this.params.getRenumberCodes()) {
                    RenumberingUtil.renumberCodesForDesegmentation(cont);
                }
                cont.getSegments().joinAll();
            }
        }
        return event;
    }
}

