/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.desegmentation;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

@EditorFor(value=Parameters.class)
public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    private static final String DESEGMENTSOURCE = "desegmentSource";
    private static final String DESEGMENTTARGET = "desegmentTarget";
    private static final String RENUMBERCODES = "renumberCodes";
    private boolean desegmentSource;
    private boolean desegmentTarget;
    public boolean renumberCodes;

    public Parameters() {
        this.reset();
    }

    public boolean getDesegmentSource() {
        return this.desegmentSource;
    }

    public void setDesegmentSource(boolean desegmentSource) {
        this.desegmentSource = desegmentSource;
    }

    public boolean getDesegmentTarget() {
        return this.desegmentTarget;
    }

    public void setDesegmentTarget(boolean desegmentTarget) {
        this.desegmentTarget = desegmentTarget;
    }

    public boolean getRenumberCodes() {
        return this.renumberCodes;
    }

    public void setRenumberCodes(boolean renumberCodes) {
        this.renumberCodes = renumberCodes;
    }

    @Override
    public void reset() {
        this.desegmentSource = true;
        this.desegmentTarget = true;
        this.renumberCodes = false;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.desegmentSource = this.buffer.getBoolean(DESEGMENTSOURCE, this.desegmentSource);
        this.desegmentTarget = this.buffer.getBoolean(DESEGMENTTARGET, this.desegmentTarget);
        this.renumberCodes = this.buffer.getBoolean(RENUMBERCODES, this.renumberCodes);
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setBoolean(DESEGMENTSOURCE, this.desegmentSource);
        this.buffer.setBoolean(DESEGMENTTARGET, this.desegmentTarget);
        this.buffer.setBoolean(RENUMBERCODES, this.renumberCodes);
        return this.buffer.toString();
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(DESEGMENTSOURCE, "Join all segments of the source text", null);
        desc.add(DESEGMENTTARGET, "Join all segments of the target text", null);
        desc.add(RENUMBERCODES, "Restore original IDs to renumbered codes", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("Desegmentation", true, false);
        desc.addCheckboxPart(paramDesc.get(DESEGMENTSOURCE));
        desc.addCheckboxPart(paramDesc.get(DESEGMENTTARGET));
        desc.addCheckboxPart(paramDesc.get(RENUMBERCODES));
        return desc;
    }
}

