/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.linebreakconversion;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.ListSelectionPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    private static final String LINEBREAK = "lineBreak";
    private String lineBreak;

    public String getLineBreak() {
        return this.lineBreak;
    }

    public void setLineBreak(String lineBreak) {
        this.lineBreak = lineBreak;
    }

    public Parameters() {
        this.reset();
    }

    @Override
    public void reset() {
        this.lineBreak = System.getProperty("line.separator");
        if (this.lineBreak == null) {
            this.lineBreak = "\r\n";
        }
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.lineBreak = this.buffer.getString(LINEBREAK, this.lineBreak);
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setString(LINEBREAK, this.lineBreak);
        return this.buffer.toString();
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(LINEBREAK, "Convert line-breaks to the following type", "Select the new type of line-break for the output.");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("Line-Break Conversion", true, false);
        String[] values = new String[]{"\r\n", "\n", "\r"};
        String[] labels = new String[]{"DOS/Windows (Carriage-Return + Line-Feed, \\r\\n, 0x0D+0x0A)", "Unix/Linux (Line-Feed, \\n, 0x0A)", "Macintosh (Carriage-Return, \\r, 0x0D)"};
        ListSelectionPart lsp = desc.addListSelectionPart(paramDesc.get(LINEBREAK), values);
        lsp.setChoicesLabels(labels);
        lsp.setListType(0);
        return desc;
    }
}

