/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.msbatchtranslation;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.PathInputPart;
import net.sf.okapi.common.uidescription.SeparatorPart;
import net.sf.okapi.common.uidescription.SpinInputPart;
import net.sf.okapi.common.uidescription.TextInputPart;
import net.sf.okapi.common.uidescription.TextLabelPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    private static final String CLIENTID = "clientId";
    private static final String SECRET = "secret";
    private static final String CATEGORY = "category";
    private static final String CONFIGPATH = "configPath";
    private static final String ANNOTATE = "annotate";
    private static final String MAKETMX = "makeTmx";
    private static final String TMXPATH = "tmxPath";
    private static final String MARKASMT = "markAsMT";
    private static final String MAXEVENTS = "maxEvents";
    private static final String MAXMATCHES = "maxMatches";
    private static final String THRESHOLD = "threshold";
    private static final String FILLTARGET = "fillTarget";
    private static final String FILLTARGETTHRESHOLD = "fillTargetThreshold";
    private static final String ONLYWHENWITHOUTCANDIDATE = "onlyWhenWithoutCandidate";
    private static final String SENDTMX = "sendTmx";
    private String clientId;
    private String secret;
    private String category;
    private String configPath;
    private String tmxPath;
    private boolean markAsMT;
    private int maxEvents;
    private int maxMatches;
    private int threshold;
    private boolean makeTmx;
    private boolean annotate;
    private boolean fillTarget;
    private int fillTargetThreshold;
    private boolean onlyWhenWithoutCandidate;
    private boolean sendTmx;

    public Parameters() {
        this.reset();
        this.toString();
    }

    public Parameters(String initialData) {
        this.fromString(initialData);
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.clientId = this.buffer.getEncodedString(CLIENTID, this.clientId);
        this.secret = this.buffer.getEncodedString(SECRET, this.secret);
        this.category = this.buffer.getEncodedString(CATEGORY, this.category);
        this.configPath = this.buffer.getString(CONFIGPATH, this.configPath);
        this.tmxPath = this.buffer.getString(TMXPATH, this.tmxPath);
        this.markAsMT = this.buffer.getBoolean(MARKASMT, this.markAsMT);
        this.maxEvents = this.buffer.getInteger(MAXEVENTS, this.maxEvents);
        this.maxMatches = this.buffer.getInteger(MAXMATCHES, this.maxMatches);
        this.threshold = this.buffer.getInteger(THRESHOLD, this.threshold);
        this.makeTmx = this.buffer.getBoolean(MAKETMX, this.makeTmx);
        this.sendTmx = this.buffer.getBoolean(SENDTMX, this.sendTmx);
        this.annotate = this.buffer.getBoolean(ANNOTATE, this.annotate);
        this.fillTarget = this.buffer.getBoolean(FILLTARGET, this.fillTarget);
        this.fillTargetThreshold = this.buffer.getInteger(FILLTARGETTHRESHOLD, this.fillTargetThreshold);
        this.onlyWhenWithoutCandidate = this.buffer.getBoolean(ONLYWHENWITHOUTCANDIDATE, this.onlyWhenWithoutCandidate);
    }

    @Override
    public void reset() {
        this.clientId = "";
        this.secret = "";
        this.category = "";
        this.tmxPath = "${rootDir}/tmFromMS.tmx";
        this.configPath = "";
        this.markAsMT = true;
        this.maxEvents = 20;
        this.maxMatches = 1;
        this.threshold = 80;
        this.makeTmx = false;
        this.annotate = true;
        this.fillTarget = true;
        this.fillTargetThreshold = 95;
        this.onlyWhenWithoutCandidate = true;
        this.sendTmx = false;
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setString(CLIENTID, this.clientId);
        this.buffer.setEncodedString(SECRET, this.secret);
        this.buffer.setEncodedString(CATEGORY, this.category);
        this.buffer.setString(CONFIGPATH, this.configPath);
        this.buffer.setString(TMXPATH, this.tmxPath);
        this.buffer.setBoolean(MARKASMT, this.markAsMT);
        this.buffer.setInteger(MAXEVENTS, this.maxEvents);
        this.buffer.setInteger(MAXMATCHES, this.maxMatches);
        this.buffer.setInteger(THRESHOLD, this.threshold);
        this.buffer.setBoolean(MAKETMX, this.makeTmx);
        this.buffer.setBoolean(SENDTMX, this.sendTmx);
        this.buffer.setBoolean(ANNOTATE, this.annotate);
        this.buffer.setBoolean(FILLTARGET, this.fillTarget);
        this.buffer.setInteger(FILLTARGETTHRESHOLD, this.fillTargetThreshold);
        this.buffer.setBoolean(ONLYWHENWITHOUTCANDIDATE, this.onlyWhenWithoutCandidate);
        return this.buffer.toString();
    }

    public boolean getFillTarget() {
        return this.fillTarget;
    }

    public void setFillTarget(boolean fillTarget) {
        this.fillTarget = fillTarget;
    }

    public int getFillTargetThreshold() {
        return this.fillTargetThreshold;
    }

    public void setFillTargetThreshold(int fillTargetThreshold) {
        this.fillTargetThreshold = fillTargetThreshold;
    }

    public boolean getMarkAsMT() {
        return this.markAsMT;
    }

    public void setMarkAsMT(boolean markAsMT) {
        this.markAsMT = markAsMT;
    }

    public int getMaxEvents() {
        return this.maxEvents;
    }

    public void setMaxEvents(int maxEvents) {
        this.maxEvents = maxEvents;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public int getMaxMatches() {
        return this.maxMatches;
    }

    public void setMaxMatches(int maxMatches) {
        this.maxMatches = maxMatches;
    }

    public String getTmxPath() {
        return this.tmxPath;
    }

    public void setTmxPath(String tmxPath) {
        this.tmxPath = tmxPath;
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public void setConfigPath(String configPath) {
        this.configPath = configPath;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getCategory() {
        return this.category;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public boolean getMakeTmx() {
        return this.makeTmx;
    }

    public void setMakeTmx(boolean makeTmx) {
        this.makeTmx = makeTmx;
    }

    public boolean getAnnotate() {
        return this.annotate;
    }

    public void setAnnotate(boolean annotate) {
        this.annotate = annotate;
    }

    public boolean getOnlyWhenWithoutCandidate() {
        return this.onlyWhenWithoutCandidate;
    }

    public void setOnlyWhenWithoutCandidate(boolean onlyWhenWithoutCandidate) {
        this.onlyWhenWithoutCandidate = onlyWhenWithoutCandidate;
    }

    public boolean getSendTmx() {
        return this.sendTmx;
    }

    public void setSendTmx(boolean sendTmx) {
        this.sendTmx = sendTmx;
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(CLIENTID, "Client ID", "Client ID in Microsoft Azure Marketplace");
        desc.add(SECRET, "Client Secret", "Client Secret from Microsoft Azure Marketplace");
        desc.add(CATEGORY, "Category", "Category code if accessing a trained system");
        desc.add(CONFIGPATH, "Engine mapping", "Full path of the properties file listing the engines");
        desc.add(MAXEVENTS, "Events buffer", "Number of events to store before sending a query");
        desc.add(MAXMATCHES, "Maximum matches", "Maximum number of matches allowed");
        desc.add(THRESHOLD, "Threshold", "Score below which matches are not retained");
        desc.add(ONLYWHENWITHOUTCANDIDATE, "Query only entries without existing candidate", null);
        desc.add(TMXPATH, null, "Full path of the new TMX document to create");
        desc.add(MARKASMT, "Mark the generated translation as machine translation results", null);
        desc.add(MAKETMX, "Generate a TMX document", null);
        desc.add(SENDTMX, "Send the TMX document to the next step", null);
        desc.add(ANNOTATE, "Annotate the text units with the translations", null);
        desc.add(FILLTARGET, "Fill the target with the best translation candidate", null);
        desc.add(FILLTARGETTHRESHOLD, "Fill threshold", "Fill the target when the best candidate is equal or above this score");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Microsoft Batch Translation Settings");
        TextLabelPart tlp = desc.addTextLabelPart("Powered by Microsoft\u00ae Translator");
        tlp.setVertical(true);
        SeparatorPart sp = desc.addSeparatorPart();
        sp.setVertical(true);
        TextInputPart tip = desc.addTextInputPart(paramsDesc.get(CLIENTID));
        tip.setPassword(false);
        tip = desc.addTextInputPart(paramsDesc.get(SECRET));
        tip.setPassword(true);
        tip = desc.addTextInputPart(paramsDesc.get(CATEGORY));
        tip.setAllowEmpty(true);
        tip.setPassword(false);
        PathInputPart pip1 = desc.addPathInputPart(paramsDesc.get(CONFIGPATH), "Config Path", false);
        pip1.setBrowseFilters("MS HUB Config (*.properties)\tAll Files (*.*)", "*.properties\t*.*");
        pip1.setVertical(false);
        pip1.setWithLabel(true);
        pip1.setAllowEmpty(true);
        sp = desc.addSeparatorPart();
        sp.setVertical(true);
        SpinInputPart sip = desc.addSpinInputPart(paramsDesc.get(MAXEVENTS));
        sip.setRange(1, 999);
        sip = desc.addSpinInputPart(paramsDesc.get(MAXMATCHES));
        sip.setRange(1, 100);
        sip = desc.addSpinInputPart(paramsDesc.get(THRESHOLD));
        sip.setRange(1, 100);
        CheckboxPart cbp = desc.addCheckboxPart(paramsDesc.get(ONLYWHENWITHOUTCANDIDATE));
        cbp.setVertical(true);
        sp = desc.addSeparatorPart();
        sp.setVertical(true);
        cbp = desc.addCheckboxPart(paramsDesc.get(ANNOTATE));
        cbp.setVertical(true);
        CheckboxPart master = desc.addCheckboxPart(paramsDesc.get(MAKETMX));
        master.setVertical(true);
        PathInputPart pip = desc.addPathInputPart(paramsDesc.get(TMXPATH), "TMX Path", true);
        pip.setBrowseFilters("TMX Documents (*.tmx)\tAll Files (*.*)", "*.tmx\t*.*");
        pip.setVertical(true);
        pip.setWithLabel(false);
        pip.setMasterPart(master, true);
        cbp = desc.addCheckboxPart(paramsDesc.get(SENDTMX));
        cbp.setVertical(true);
        cbp.setMasterPart(master, true);
        cbp = desc.addCheckboxPart(paramsDesc.get(MARKASMT));
        cbp.setVertical(true);
        cbp.setMasterPart(master, true);
        sp = desc.addSeparatorPart();
        sp.setVertical(true);
        cbp = desc.addCheckboxPart(paramsDesc.get(FILLTARGET));
        cbp.setVertical(true);
        sip = desc.addSpinInputPart(paramsDesc.get(FILLTARGETTHRESHOLD));
        sip.setRange(1, 100);
        sip.setMasterPart(cbp, true);
        return desc;
    }
}

