/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.paraaligner;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

@EditorFor(value=Parameters.class)
public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    private static final String OUTPUT_ONE_TO_ONE_MATCHES_ONLY = "outputOneToOneMatchesOnly";
    private static final String USE_SKELETON_ALIGNMENT = "useSkeletonAlignment";
    private boolean outputOneToOneMatchesOnly;
    private boolean useSkeletonAlignment;

    public Parameters() {
        this.reset();
    }

    public boolean isOutputOneToOneMatchesOnly() {
        return this.outputOneToOneMatchesOnly;
    }

    public void setOutputOneToOneMatchesOnly(boolean outputOneToOneMatchesOnly) {
        this.outputOneToOneMatchesOnly = outputOneToOneMatchesOnly;
    }

    public boolean isUseSkeletonAlignment() {
        return this.useSkeletonAlignment;
    }

    public void setUseSkeletonAlignment(boolean useSkeletonAlignment) {
        this.useSkeletonAlignment = useSkeletonAlignment;
    }

    @Override
    public void reset() {
        this.outputOneToOneMatchesOnly = true;
        this.useSkeletonAlignment = false;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.outputOneToOneMatchesOnly = this.buffer.getBoolean(OUTPUT_ONE_TO_ONE_MATCHES_ONLY, this.outputOneToOneMatchesOnly);
        this.useSkeletonAlignment = this.buffer.getBoolean(USE_SKELETON_ALIGNMENT, this.useSkeletonAlignment);
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setBoolean(OUTPUT_ONE_TO_ONE_MATCHES_ONLY, this.outputOneToOneMatchesOnly);
        this.buffer.setBoolean(USE_SKELETON_ALIGNMENT, this.useSkeletonAlignment);
        return this.buffer.toString();
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(OUTPUT_ONE_TO_ONE_MATCHES_ONLY, "Output 1-1 Matches Only?", "Ouput only 1-1 aligned paragraphs?");
        desc.add(USE_SKELETON_ALIGNMENT, "Use Skeleton Alignment? (Experimental)", "Use Skeleton alignment? (Experimental)");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Paragraph Aligner", true, false);
        desc.addCheckboxPart(paramsDesc.get(OUTPUT_ONE_TO_ONE_MATCHES_ONLY));
        desc.addCheckboxPart(paramsDesc.get(USE_SKELETON_ALIGNMENT));
        return desc;
    }
}

