/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rainbowkit.omegat;

import java.io.File;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.XMLWriter;
import net.sf.okapi.steps.rainbowkit.common.IMergeable;
import net.sf.okapi.steps.rainbowkit.omegat.Options;
import net.sf.okapi.steps.rainbowkit.xliff.XLIFFPackageWriter;

public class OmegaTPackageWriter
extends XLIFFPackageWriter
implements IMergeable {
    public static final String OKAPI_HOME = "OKAPI_HOME";
    Options options = new Options();
    Map<String, String> movedFiles;
    private static String[] RENAME_FILES = new String[]{"tm" + File.separator + "unapproved.tmx", "tm" + File.separator + "alternate.tmx", "tm" + File.separator + "leverage.tmx"};

    public OmegaTPackageWriter() {
        this.extractionType = "omegat";
    }

    @Override
    protected void processStartBatch() {
        this.setForOmegat(true);
        this.manifest.setSubDirectories("original", "source", "target", "done", "tm", true);
        this.setTMXInfo(true, this.manifest.getPackageRoot() + "omegat" + File.separator + "project_save.tmx", true, true);
        super.processStartBatch();
    }

    @Override
    protected void processEndBatch() {
        Util.createDirectories(this.manifest.getPackageRoot() + "omegat/");
        Util.createDirectories(this.manifest.getPackageRoot() + "glossary/");
        Util.createDirectories(this.manifest.getTempTargetDirectory());
        Util.createDirectories(this.manifest.getTempTmDirectory());
        this.createOmegaTProject();
        super.processEndBatch();
    }

    @Override
    protected void processStartDocument(Event event) {
        if (!Util.isEmpty(this.params.getWriterOptions())) {
            this.options.fromString(this.params.getWriterOptions());
        }
        super.processStartDocument(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createOmegaTProject() {
        String projectSaveFile = this.manifest.getPackageRoot() + "omegat.project";
        if (new File(projectSaveFile).isFile()) {
            return;
        }
        XMLWriter XR = null;
        try {
            XR = new XMLWriter(projectSaveFile);
            XR.writeStartDocument();
            XR.writeStartElement("omegat");
            XR.writeStartElement("project");
            XR.writeAttributeString("version", "1.0");
            XR.writeStartElement("source_dir");
            XR.writeRawXML("__DEFAULT__");
            XR.writeEndElementLineBreak();
            XR.writeStartElement("target_dir");
            XR.writeRawXML("__DEFAULT__");
            XR.writeEndElementLineBreak();
            XR.writeStartElement("tm_dir");
            XR.writeRawXML("__DEFAULT__");
            XR.writeEndElementLineBreak();
            XR.writeStartElement("glossary_dir");
            XR.writeRawXML("__DEFAULT__");
            XR.writeEndElementLineBreak();
            XR.writeStartElement("dictionary_dir");
            XR.writeRawXML("__DEFAULT__");
            XR.writeEndElementLineBreak();
            XR.writeStartElement("source_lang");
            XR.writeRawXML(this.manifest.getSourceLocale().toString());
            XR.writeEndElementLineBreak();
            XR.writeStartElement("target_lang");
            XR.writeRawXML(this.manifest.getTargetLocale().toString());
            XR.writeEndElementLineBreak();
            XR.writeStartElement("sentence_seg");
            XR.writeRawXML(this.getPreSegmented() ? "false" : (this.options.getAllowSegmentation() ? "true" : "false"));
            XR.writeEndElementLineBreak();
            if (this.options.getIncludePostProcessingHook()) {
                String jarPath = null;
                String home = System.getenv().get(OKAPI_HOME);
                if (home != null) {
                    String jarRelPath = "lib" + File.separator + "rainbow.jar";
                    File jar = new File(home, jarRelPath);
                    try {
                        if (jar.exists() && jar.isFile()) {
                            jarPath = String.format("${%s}%s%s", OKAPI_HOME, home.endsWith(File.separator) ? "" : File.separator, jarRelPath);
                        }
                    }
                    catch (SecurityException e) {
                        // empty catch block
                    }
                }
                if (jarPath == null) {
                    try {
                        File jar = new File(ClassLoader.getSystemResource("rainbow.jar").toURI());
                        jarPath = jar.getAbsolutePath();
                    }
                    catch (NullPointerException e) {
                    }
                    catch (URISyntaxException e) {
                        // empty catch block
                    }
                }
                if (jarPath != null) {
                    String externalCmd = String.format("java %s -jar \"%s\" -x TranslationKitPostProcessing -np \"${projectRoot}manifest.rkm\" -fc okf_rainbowkit-noprompt", System.getProperty("os.name").contains("OS X") ? "-XstartOnFirstThread" : "", jarPath);
                    XR.writeStartElement("external_command");
                    XR.writeString(externalCmd);
                    XR.writeEndElementLineBreak();
                }
            }
            XR.writeEndElementLineBreak();
            XR.writeEndElement();
        }
        finally {
            if (XR != null) {
                XR.writeEndDocument();
                XR.close();
            }
        }
    }

    @Override
    public void prepareForMerge(String dir) {
        this.movedFiles = new HashMap<String, String>();
        if (!dir.endsWith(File.separator)) {
            dir = dir + File.separator;
        }
        String tmDir = dir + "tm" + File.separator;
        Util.createDirectories(tmDir);
        String projSave = dir + "omegat" + File.separator + "project_save.tmx";
        if (new File(projSave).isFile()) {
            String moveTo = this.uniqueName(tmDir + "project_save.tmx", "-orig");
            Util.copyFile(projSave, moveTo, true);
            this.movedFiles.put(projSave, moveTo);
        }
        for (String file : RENAME_FILES) {
            if (!new File(dir + file).isFile()) continue;
            String moveFrom = dir + file;
            String moveTo = this.uniqueName(dir + file, "-orig");
            Util.copyFile(moveFrom, moveTo, true);
            this.movedFiles.put(moveFrom, moveTo);
        }
        File manifest = new File(dir + "manifest.rkm");
        if (manifest.isFile()) {
            manifest.delete();
        }
        Util.deleteDirectory(dir + "original", false);
        Util.deleteDirectory(dir + "source", false);
        Util.deleteDirectory(dir + "target", false);
    }

    private String uniqueName(String path, String suffix) {
        int lastDot = path.lastIndexOf(".");
        String base = path.substring(0, lastDot);
        String ext = path.substring(lastDot);
        File newFile = new File(base + suffix + ext);
        int n = 1;
        while (newFile.isFile()) {
            newFile = new File(base + suffix + "-" + n + ext);
            ++n;
        }
        return newFile.toString();
    }

    @Override
    public void doPostMerge() {
        if (this.movedFiles == null || this.movedFiles.size() == 0) {
            return;
        }
        for (Map.Entry<String, String> e : this.movedFiles.entrySet()) {
            if (new File(e.getKey()).exists()) continue;
            Util.copyFile(e.getValue(), e.getKey(), true);
        }
    }
}

