/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rainbowkit.omegat;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

public class Options
extends BaseParameters
implements IEditorDescriptionProvider {
    private static final String ALLOWSEGMENTATION = "allowSegmentation";
    private static final String INCLUDEPOSTPROCESSINGHOOK = "includePostProcessingHook";
    private boolean allowSegmentation;
    private boolean includePostProcessingHook;

    public Options() {
        this.reset();
    }

    @Override
    public void reset() {
        this.allowSegmentation = true;
        this.includePostProcessingHook = true;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.allowSegmentation = this.buffer.getBoolean(ALLOWSEGMENTATION, this.allowSegmentation);
        this.includePostProcessingHook = this.buffer.getBoolean(INCLUDEPOSTPROCESSINGHOOK, this.includePostProcessingHook);
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setParameter(ALLOWSEGMENTATION, this.allowSegmentation);
        this.buffer.setParameter(INCLUDEPOSTPROCESSINGHOOK, this.includePostProcessingHook);
        return this.buffer.toString();
    }

    public boolean getAllowSegmentation() {
        return this.allowSegmentation;
    }

    public boolean getIncludePostProcessingHook() {
        return this.includePostProcessingHook;
    }

    public void setAllowSegmentation(boolean allowSegmentation) {
        this.allowSegmentation = allowSegmentation;
    }

    public void setIncludePostProcessingHook(boolean includePostProcessingHook) {
        this.includePostProcessingHook = includePostProcessingHook;
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(ALLOWSEGMENTATION, "Allow segmentation in the OmegaT project", "Allow or not segmentation in the project. Ignored if there is a segmentation step.");
        desc.add(INCLUDEPOSTPROCESSINGHOOK, "Include post-processing hook", "Set up the project so that OmegaT's \"Create Translated Documents\" command will automatically trigger Okapi's Translation Kit Post-Processing pipeline.");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("OmegaT Project", true, false);
        desc.addCheckboxPart(paramsDesc.get(ALLOWSEGMENTATION));
        desc.addCheckboxPart(paramsDesc.get(INCLUDEPOSTPROCESSINGHOOK));
        return desc;
    }
}

