/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rainbowkit.transifex;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.XMLWriter;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.filters.po.POWriter;
import net.sf.okapi.filters.rainbowkit.MergingInfo;
import net.sf.okapi.lib.transifex.TransifexClient;
import net.sf.okapi.steps.rainbowkit.common.BasePackageWriter;
import net.sf.okapi.steps.rainbowkit.transifex.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransifexPackageWriter
extends BasePackageWriter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private POWriter potWriter;
    private POWriter trgWriter;

    public TransifexPackageWriter() {
        super("transifex");
        this.setSupporstOneOutputPerInput(false);
    }

    @Override
    protected void processStartBatch() {
        this.manifest.setSubDirectories("original", "uploads", "downloads", "done", null, true);
        this.setTMXInfo(false, null, true, true);
        super.processStartBatch();
    }

    @Override
    protected void processEndBatch() {
        super.processEndBatch();
        XMLWriter report = null;
        PrintWriter pw = null;
        Parameters options = new Parameters();
        if (!Util.isEmpty(this.params.getWriterOptions())) {
            options.fromString(this.params.getWriterOptions());
        }
        try {
            pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.manifest.getPackageRoot() + options.getProjectId() + ".txp"), "UTF-8"));
            pw.println("host=" + options.getServer());
            pw.println("user=" + options.getUser());
            pw.println("projectId=" + options.getProjectId());
            pw.println("sourceLocale=" + this.manifest.getSourceLocale().toString());
            pw.println("targetLocale=" + this.manifest.getTargetLocale().toString());
            String reportPath = this.manifest.getPackageRoot() + "linksToTransifex.html";
            report = new XMLWriter(reportPath);
            report.writeStartDocument();
            report.writeRawXML("<h1>Transifex Package Summary</h1>");
            report.writeLineBreak();
            report.writeRawXML(String.format("<p>Resources uploaded to Transifex in the project <b><a target='_blank' href='%s'>%s</a></b></p>", options.getServer() + "projects/p/" + options.getProjectId() + "/", options.getProjectName()));
            report.writeLineBreak();
            report.writeRawXML("<table border='1' cellspacing='0' cellpadding='5'>");
            report.writeRawXML("<tr><th>Transifex Resource</th><th>Original Source File</th></tr>");
            report.writeLineBreak();
            TransifexClient cli = new TransifexClient(options.getServer());
            cli.setProject(options.getProjectId());
            cli.setCredentials(options.getUser(), options.getPassword());
            String[] res1 = cli.createProject(options.getProjectId(), options.getProjectName(), null, null);
            if (res1[0] == null) {
                this.logger.error(res1[1]);
                return;
            }
            for (int id : this.manifest.getItems().keySet()) {
                MergingInfo info = this.manifest.getItem(id);
                if (info.getExtractionType().equals("none")) continue;
                String poPath = this.manifest.getTempSourceDirectory() + info.getRelativeInputPath() + ".po";
                String resourceFile = Util.getFilename(poPath, true);
                String subdir = Util.getDirectoryName(info.getRelativeInputPath());
                if (!subdir.isEmpty()) {
                    resourceFile = Util.makeId(subdir) + "_" + resourceFile;
                }
                if ((res1 = cli.putSourceResource(poPath, this.manifest.getSourceLocale(), resourceFile))[0] == null) {
                    this.logger.error(res1[1]);
                    return;
                }
                info.setResourceId(res1[1]);
                pw.println(res1[1]);
                report.writeRawXML(String.format("<tr><td><a target='_blank' href=\"%s\">%s</a></td>", options.getServer() + res1[0].substring(1), resourceFile));
                report.writeRawXML(String.format("<td>%s</td></tr>", info.getRelativeInputPath()));
                report.writeLineBreak();
                poPath = this.makeTargetPath(info);
                String[] res2 = cli.putTargetResource(poPath, this.manifest.getTargetLocale(), res1[1], resourceFile);
                if (res2[0] != null) continue;
                this.logger.error(res2[1]);
            }
            report.writeRawXML("</table>");
            report.writeRawXML("<p>For more information about this package, see: <a target='_blank' href='http://www.opentag.com/okapi/wiki/index.php?title=Rainbow_TKit_-_Transifex_Project'>Rainbow TKit - Transifex Project</a>.");
            report.writeRawXML("<p><font size='2'>Note: This report was generated when creating the translation package, the Transifex project may have been updated with other files since.</font></p>");
            report.close();
            if (this.params.getOutputManifest()) {
                this.manifest.save(null);
            }
            Util.openURL("file:///" + reportPath);
        }
        catch (IOException e) {
            throw new OkapiIOException("Error at the end of the batch.\n" + e.getMessage(), e);
        }
        finally {
            if (report != null) {
                report.close();
            }
            if (pw != null) {
                pw.close();
            }
        }
    }

    @Override
    protected void processStartDocument(Event event) {
        super.processStartDocument(event);
        this.potWriter = new POWriter();
        net.sf.okapi.filters.po.Parameters params = (net.sf.okapi.filters.po.Parameters)this.potWriter.getParameters();
        params.setOutputGeneric(true);
        this.potWriter.setMode(true, true, true);
        this.potWriter.setOptions(this.manifest.getSourceLocale(), "UTF-8");
        MergingInfo item = this.manifest.getItem(this.docId);
        String path = this.manifest.getTempSourceDirectory() + item.getRelativeInputPath() + ".po";
        this.potWriter.setOutput(path);
        this.trgWriter = new POWriter();
        params = (net.sf.okapi.filters.po.Parameters)this.trgWriter.getParameters();
        params.setOutputGeneric(true);
        this.trgWriter.setMode(true, false, false);
        this.trgWriter.setOptions(this.manifest.getTargetLocale(), "UTF-8");
        path = this.makeTargetPath(item);
        this.trgWriter.setOutput(path);
        this.potWriter.handleEvent(event);
        this.trgWriter.handleEvent(event);
    }

    @Override
    protected Event processEndDocument(Event event) {
        this.potWriter.handleEvent(event);
        this.trgWriter.handleEvent(event);
        this.close();
        return event;
    }

    @Override
    protected void processStartSubDocument(Event event) {
        this.potWriter.handleEvent(event);
        this.trgWriter.handleEvent(event);
    }

    @Override
    protected void processEndSubDocument(Event event) {
        this.potWriter.handleEvent(event);
        this.trgWriter.handleEvent(event);
    }

    @Override
    protected void processTextUnit(Event event) {
        ITextUnit tu = event.getTextUnit();
        if (!tu.isTranslatable()) {
            return;
        }
        this.potWriter.handleEvent(event);
        this.trgWriter.handleEvent(event);
        this.writeTMXEntries(event.getTextUnit());
    }

    @Override
    public void close() {
        if (this.potWriter != null) {
            this.potWriter.close();
            this.potWriter = null;
        }
        if (this.trgWriter != null) {
            this.trgWriter.close();
            this.trgWriter = null;
        }
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    private String makeTargetPath(MergingInfo item) {
        String ex = Util.getExtension(item.getRelativeInputPath());
        String sd = Util.getDirectoryName(item.getRelativeInputPath());
        String fn = Util.getFilename(item.getRelativeInputPath(), false);
        return this.manifest.getTempSourceDirectory() + (sd.isEmpty() ? "" : sd + "/") + fn + "_" + this.manifest.getTargetLocale().toPOSIXLocaleId() + ex + ".po";
    }
}

