/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rainbowkit.xliff;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

public class Options
extends BaseParameters
implements IEditorDescriptionProvider {
    private static final String PLACEHOLDERMODE = "placeholderMode";
    private static final String INCLUDENOTRANSLATE = "includeNoTranslate";
    private static final String SETAPPROVEDASNOTRANSLATE = "setApprovedAsNoTranslate";
    private static final String COPYSOURCE = "copySource";
    private static final String INCLUDEALTTRANS = "includeAltTrans";
    private static final String INCLUDECODEATTRS = "includeCodeAttrs";
    private static final String INCLUDEITS = "includeIts";
    private boolean placeholderMode;
    private boolean includeNoTranslate;
    private boolean setApprovedAsNoTranslate;
    private boolean copySource;
    private boolean includeAltTrans;
    private boolean includeCodeAttrs;
    private boolean includeIts;

    public Options() {
        this.reset();
    }

    @Override
    public void reset() {
        this.placeholderMode = true;
        this.includeNoTranslate = true;
        this.setApprovedAsNoTranslate = false;
        this.copySource = true;
        this.includeAltTrans = true;
        this.includeCodeAttrs = false;
        this.includeIts = true;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.placeholderMode = this.buffer.getBoolean(PLACEHOLDERMODE, this.placeholderMode);
        this.includeNoTranslate = this.buffer.getBoolean(INCLUDENOTRANSLATE, this.includeNoTranslate);
        this.setApprovedAsNoTranslate = this.buffer.getBoolean(SETAPPROVEDASNOTRANSLATE, this.setApprovedAsNoTranslate);
        this.copySource = this.buffer.getBoolean(COPYSOURCE, this.copySource);
        this.includeAltTrans = this.buffer.getBoolean(INCLUDEALTTRANS, this.includeAltTrans);
        this.includeCodeAttrs = this.buffer.getBoolean(INCLUDECODEATTRS, this.includeCodeAttrs);
        this.includeIts = this.buffer.getBoolean(INCLUDEITS, this.includeIts);
        if (!this.includeNoTranslate) {
            this.setApprovedAsNoTranslate = false;
        }
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setParameter(PLACEHOLDERMODE, this.placeholderMode);
        this.buffer.setBoolean(INCLUDENOTRANSLATE, this.includeNoTranslate);
        this.buffer.setBoolean(SETAPPROVEDASNOTRANSLATE, this.setApprovedAsNoTranslate);
        this.buffer.setBoolean(COPYSOURCE, this.copySource);
        this.buffer.setBoolean(INCLUDEALTTRANS, this.includeAltTrans);
        this.buffer.setBoolean(INCLUDECODEATTRS, this.includeCodeAttrs);
        this.buffer.setBoolean(INCLUDEITS, this.includeIts);
        return this.buffer.toString();
    }

    public boolean getPlaceholderMode() {
        return this.placeholderMode;
    }

    public void setPlaceholderMode(boolean placeholderMode) {
        this.placeholderMode = placeholderMode;
    }

    public boolean getIncludeNoTranslate() {
        return this.includeNoTranslate;
    }

    public void setIncludeNoTranslate(boolean includeNoTranslate) {
        this.includeNoTranslate = includeNoTranslate;
    }

    public boolean getSetApprovedAsNoTranslate() {
        return this.setApprovedAsNoTranslate;
    }

    public void setSetApprovedAsNoTranslate(boolean setApprovedAsNoTranslate) {
        this.setApprovedAsNoTranslate = setApprovedAsNoTranslate;
    }

    public boolean getCopySource() {
        return this.copySource;
    }

    public void setCopySource(boolean copySource) {
        this.copySource = copySource;
    }

    public boolean getIncludeAltTrans() {
        return this.includeAltTrans;
    }

    public void setIncludeAltTrans(boolean includeAltTrans) {
        this.includeAltTrans = includeAltTrans;
    }

    public boolean getIncludeCodeAttrs() {
        return this.includeCodeAttrs;
    }

    public void setIncludeCodeAttrs(boolean includeCodeAttrs) {
        this.includeCodeAttrs = includeCodeAttrs;
    }

    public boolean getIncludeIts() {
        return this.includeIts;
    }

    public void setIncludeIts(boolean includeIts) {
        this.includeIts = includeIts;
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(PLACEHOLDERMODE, "Use <g></g> and <x/> notation", null);
        desc.add(INCLUDENOTRANSLATE, "Include non-translatable text units", null);
        desc.add(SETAPPROVEDASNOTRANSLATE, "Set approved entries as non-translatable", null);
        desc.add(COPYSOURCE, "Copy source text in target if no target is available", null);
        desc.add(INCLUDEALTTRANS, "Include <alt-trans> elements", null);
        desc.add(INCLUDECODEATTRS, "Include extended code attributes", null);
        desc.add(INCLUDEITS, "Include ITS markup", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Generic XLIFF Package", true, false);
        CheckboxPart cbp1 = desc.addCheckboxPart(paramsDesc.get(INCLUDENOTRANSLATE));
        CheckboxPart cbp2 = desc.addCheckboxPart(paramsDesc.get(SETAPPROVEDASNOTRANSLATE));
        cbp2.setMasterPart(cbp1, true);
        desc.addCheckboxPart(paramsDesc.get(PLACEHOLDERMODE));
        desc.addCheckboxPart(paramsDesc.get(COPYSOURCE));
        desc.addCheckboxPart(paramsDesc.get(INCLUDEALTTRANS));
        desc.addCheckboxPart(paramsDesc.get(INCLUDECODEATTRS));
        desc.addCheckboxPart(paramsDesc.get(INCLUDEITS));
        return desc;
    }
}

