/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rainbowkit.xliff;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filterwriter.XLIFFWriter;
import net.sf.okapi.common.filterwriter.XLIFFWriterParameters;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.filters.rainbowkit.MergingInfo;
import net.sf.okapi.steps.rainbowkit.common.BasePackageWriter;
import net.sf.okapi.steps.rainbowkit.xliff.Options;

public class XLIFFPackageWriter
extends BasePackageWriter {
    protected XLIFFWriter writer;
    private boolean preSegmented = false;
    private boolean forOmegat = false;
    private String rawDocPath;

    public XLIFFPackageWriter() {
        super("xliff");
    }

    public boolean getPreSegmented() {
        return this.preSegmented;
    }

    public void setForOmegat(boolean forOmegat) {
        this.forOmegat = forOmegat;
    }

    @Override
    protected void processStartBatch() {
        this.manifest.setSubDirectories("original", "work", "work", "done", null, false);
        this.setTMXInfo(true, null, this.forOmegat, true);
        super.processStartBatch();
    }

    @Override
    protected void processStartDocument(Event event) {
        super.processStartDocument(event);
        this.writer = new XLIFFWriter();
        this.writer.setOptions(this.manifest.getTargetLocale(), "UTF-8");
        MergingInfo item = this.manifest.getItem(this.docId);
        this.rawDocPath = this.manifest.getTempSourceDirectory() + item.getRelativeInputPath() + ".xlf";
        this.writer.setOutput(this.rawDocPath);
        XLIFFWriterParameters paramsXliff = (XLIFFWriterParameters)this.writer.getParameters();
        Options options = new Options();
        if (this.forOmegat) {
            options.setCopySource(true);
            options.setPlaceholderMode(true);
            options.setIncludeAltTrans(false);
            options.setIncludeCodeAttrs(true);
            paramsXliff.setUseSourceForTranslated(true);
        } else if (!Util.isEmpty(this.params.getWriterOptions())) {
            options.fromString(this.params.getWriterOptions());
        }
        paramsXliff.setPlaceholderMode(options.getPlaceholderMode());
        paramsXliff.setCopySource(options.getCopySource());
        paramsXliff.setIncludeAltTrans(options.getIncludeAltTrans());
        paramsXliff.setSetApprovedAsNoTranslate(options.getSetApprovedAsNoTranslate());
        paramsXliff.setIncludeNoTranslate(options.getIncludeNoTranslate());
        paramsXliff.setIncludeCodeAttrs(options.getIncludeCodeAttrs());
        paramsXliff.setIncludeIts(options.getIncludeIts());
        StartDocument sd = event.getStartDocument();
        this.writer.create(this.rawDocPath, null, this.manifest.getSourceLocale(), this.manifest.getTargetLocale(), sd.getMimeType(), item.getRelativeInputPath(), null);
    }

    @Override
    protected Event processEndDocument(Event event) {
        if (this.writer != null) {
            this.writer.handleEvent(event);
            this.writer.close();
            this.writer = null;
        }
        if (this.params.getSendOutput()) {
            return super.creatRawDocumentEventSet(this.rawDocPath, "UTF-8", this.manifest.getSourceLocale(), this.manifest.getTargetLocale());
        }
        return event;
    }

    @Override
    protected void processStartSubDocument(Event event) {
        this.writer.handleEvent(event);
    }

    @Override
    protected void processEndSubDocument(Event event) {
        this.writer.handleEvent(event);
    }

    @Override
    protected void processStartGroup(Event event) {
        this.writer.handleEvent(event);
    }

    @Override
    protected void processEndGroup(Event event) {
        this.writer.handleEvent(event);
    }

    @Override
    protected void processTextUnit(Event event) {
        event = this.writer.handleEvent(event);
        this.writeTMXEntries(event.getTextUnit());
        if (!this.preSegmented) {
            this.preSegmented = event.getTextUnit().getSource().hasBeenSegmented();
        }
    }

    @Override
    public void close() {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }
}

