/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.sentencealigner;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.PathInputPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    private static final String GENERATETMX = "generateTMX";
    private static final String TMXOUTPUTPATH = "tmxOutputPath";
    private static final String COLLAPSEWHITESPACE = "collapseWhitespace";
    private static final String OUTPUT_ONE_TO_ONE_MATCHES_ONLY = "outputOneTOneMatchesOnly";
    private boolean generateTMX;
    private String tmxOutputPath;
    private boolean segmentSource;
    private boolean useCustomSourceRules;
    private String customSourceRulesPath;
    private boolean segmentTarget;
    private boolean useCustomTargetRules;
    private String customTargetRulesPath;
    private boolean collapseWhitespace;
    private boolean outputOneTOneMatchesOnly;
    private boolean forceSimpleOneToOneAlignment;

    public Parameters() {
        this.reset();
    }

    public boolean isGenerateTMX() {
        return this.generateTMX;
    }

    public void setGenerateTMX(boolean generateTMX) {
        this.generateTMX = generateTMX;
    }

    public String getTmxOutputPath() {
        return this.tmxOutputPath;
    }

    public void setTmxOutputPath(String tmxOutputPath) {
        this.tmxOutputPath = tmxOutputPath;
    }

    public boolean isSegmentSource() {
        return this.segmentSource;
    }

    public void setSegmentSource(boolean segmentSource) {
        this.segmentSource = segmentSource;
    }

    public boolean isUseCustomSourceRules() {
        return this.useCustomSourceRules;
    }

    public void setUseCustomSourceRules(boolean useCustomSourceRules) {
        this.useCustomSourceRules = useCustomSourceRules;
    }

    public String getCustomSourceRulesPath() {
        return this.customSourceRulesPath;
    }

    public void setCustomSourceRulesPath(String customSourceRulesPath) {
        this.customSourceRulesPath = customSourceRulesPath;
    }

    public boolean isSegmentTarget() {
        return this.segmentTarget;
    }

    public void setSegmentTarget(boolean segmentTarget) {
        this.segmentTarget = segmentTarget;
    }

    public boolean isUseCustomTargetRules() {
        return this.useCustomTargetRules;
    }

    public void setUseCustomTargetRules(boolean useCustomTargetRules) {
        this.useCustomTargetRules = useCustomTargetRules;
    }

    public String getCustomTargetRulesPath() {
        return this.customTargetRulesPath;
    }

    public void setCustomTargetRulesPath(String customTargetRulesPath) {
        this.customTargetRulesPath = customTargetRulesPath;
    }

    public boolean isCollapseWhitespace() {
        return this.collapseWhitespace;
    }

    public void setCollapseWhitespace(boolean collapseWhitespace) {
        this.collapseWhitespace = collapseWhitespace;
    }

    public boolean isOutputOneTOneMatchesOnly() {
        return this.outputOneTOneMatchesOnly;
    }

    public void setOutputOneTOneMatchesOnly(boolean outputOneTOneMatchesOnly) {
        this.outputOneTOneMatchesOnly = outputOneTOneMatchesOnly;
    }

    public boolean isForceSimpleOneToOneAlignment() {
        return this.forceSimpleOneToOneAlignment;
    }

    public void setForceSimpleOneToOneAlignment(boolean forceSimpleOneToOneAlignment) {
        this.forceSimpleOneToOneAlignment = forceSimpleOneToOneAlignment;
    }

    @Override
    public void reset() {
        this.tmxOutputPath = "aligned.tmx";
        this.generateTMX = true;
        this.segmentSource = true;
        this.useCustomSourceRules = false;
        this.customSourceRulesPath = "";
        this.segmentTarget = true;
        this.useCustomTargetRules = false;
        this.customTargetRulesPath = "";
        this.collapseWhitespace = false;
        this.outputOneTOneMatchesOnly = false;
        this.forceSimpleOneToOneAlignment = false;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.generateTMX = this.buffer.getBoolean(GENERATETMX, this.generateTMX);
        this.tmxOutputPath = this.buffer.getString(TMXOUTPUTPATH, this.tmxOutputPath);
        this.segmentSource = this.buffer.getBoolean("segmentSource", this.segmentSource);
        this.useCustomSourceRules = this.buffer.getBoolean("useCustomSourceRules", this.useCustomSourceRules);
        this.customSourceRulesPath = this.buffer.getString("customSourceRulesPath", this.customSourceRulesPath);
        this.segmentTarget = this.buffer.getBoolean("segmentTarget", this.segmentTarget);
        this.useCustomTargetRules = this.buffer.getBoolean("useCustomTargetRules", this.useCustomTargetRules);
        this.customTargetRulesPath = this.buffer.getString("customTargetRulesPath", this.customTargetRulesPath);
        this.collapseWhitespace = this.buffer.getBoolean(COLLAPSEWHITESPACE, this.collapseWhitespace);
        this.outputOneTOneMatchesOnly = this.buffer.getBoolean(OUTPUT_ONE_TO_ONE_MATCHES_ONLY, this.outputOneTOneMatchesOnly);
        this.forceSimpleOneToOneAlignment = this.buffer.getBoolean("forceSimpleOneToOneAlignment", this.forceSimpleOneToOneAlignment);
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setBoolean(GENERATETMX, this.generateTMX);
        this.buffer.setParameter(TMXOUTPUTPATH, this.tmxOutputPath);
        this.buffer.setBoolean("segmentSource", this.segmentSource);
        this.buffer.setBoolean("useCustomSourceRules", this.useCustomSourceRules);
        this.buffer.setParameter("customSourceRulesPath", this.customSourceRulesPath);
        this.buffer.setBoolean("segmentTarget", this.segmentTarget);
        this.buffer.setBoolean("useCustomTargetRules", this.useCustomTargetRules);
        this.buffer.setString("customTargetRulesPath", this.customTargetRulesPath);
        this.buffer.setBoolean(COLLAPSEWHITESPACE, this.collapseWhitespace);
        this.buffer.setBoolean(OUTPUT_ONE_TO_ONE_MATCHES_ONLY, this.outputOneTOneMatchesOnly);
        this.buffer.setBoolean("forceSimpleOneToOneAlignment", this.forceSimpleOneToOneAlignment);
        return this.buffer.toString();
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(GENERATETMX, "Generate the following TMX document:", "If generateTMX is false generate bilingual TextUnits, otherwise (true) output a TMX file");
        desc.add(TMXOUTPUTPATH, "TMX output path", "Full path of the output TMX file");
        desc.add("segmentSource", "Segment the source content (overriding possible existing segmentation)", null);
        desc.add("useCustomSourceRules", "Use custom source segmentation rules (instead of the default ones)", null);
        desc.add("customSourceRulesPath", "SRX path for the source", "Full path of the SRX document to use for the source");
        desc.add("segmentTarget", "Segment the target content (overriding possible existing segmentation)", null);
        desc.add("useCustomTargetRules", "Use custom target segmentation rules (instead of the default ones)", null);
        desc.add("customTargetRulesPath", "SRX path for the target", "Full path of the SRX document to use for the target");
        desc.add(COLLAPSEWHITESPACE, "Collapse whitspace", "Collapse whitespace (space, newline etc.) to a single space before segmentation and alignment");
        desc.add(OUTPUT_ONE_TO_ONE_MATCHES_ONLY, "Output 1-1 matches only", "Ouput only 1-1 sentence aligned matches");
        desc.add("forceSimpleOneToOneAlignment", "Force Simple One to One Alignment", "If the number of sentences are the same then align one to one. Otherwise collapse the sentences and align");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Sentence Aligner", true, false);
        CheckboxPart cbp = desc.addCheckboxPart(paramsDesc.get(GENERATETMX));
        PathInputPart pip = desc.addPathInputPart(paramsDesc.get(TMXOUTPUTPATH), "TMX Document to Generate", true);
        pip.setBrowseFilters("TMX Documents (*.tmx)\tAll Files (*.*)", "*.tmx\t*.*");
        pip.setWithLabel(false);
        pip.setMasterPart(cbp, true);
        desc.addSeparatorPart();
        CheckboxPart cbp1 = desc.addCheckboxPart(paramsDesc.get("segmentSource"));
        CheckboxPart cbp2 = desc.addCheckboxPart(paramsDesc.get("useCustomSourceRules"));
        cbp2.setMasterPart(cbp1, true);
        pip = desc.addPathInputPart(paramsDesc.get("customSourceRulesPath"), "Segmentation Rules for Source", false);
        pip.setBrowseFilters("SRX Documents (*.srx)\tAll Files (*.*)", "*.srx\t*.*");
        pip.setWithLabel(false);
        pip.setMasterPart(cbp2, true);
        desc.addSeparatorPart();
        cbp1 = desc.addCheckboxPart(paramsDesc.get("segmentTarget"));
        cbp2 = desc.addCheckboxPart(paramsDesc.get("useCustomTargetRules"));
        cbp2.setMasterPart(cbp1, true);
        pip = desc.addPathInputPart(paramsDesc.get("customTargetRulesPath"), "Segmentation Rules for Target", false);
        pip.setBrowseFilters("SRX Documents (*.srx)\tAll Files (*.*)", "*.srx\t*.*");
        pip.setWithLabel(false);
        pip.setMasterPart(cbp2, true);
        desc.addSeparatorPart();
        desc.addCheckboxPart(paramsDesc.get(COLLAPSEWHITESPACE));
        desc.addSeparatorPart();
        desc.addCheckboxPart(paramsDesc.get(OUTPUT_ONE_TO_ONE_MATCHES_ONLY));
        desc.addSeparatorPart();
        desc.addCheckboxPart(paramsDesc.get("forceSimpleOneToOneAlignment"));
        return desc;
    }
}

