/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.termextraction;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.ReferenceParameter;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.PathInputPart;
import net.sf.okapi.common.uidescription.SpinInputPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    private static final String OUTPUTPATH = "outputPath";
    private static final String AUTOOPEN = "autoOpen";
    private static final String MINWORDSPERTERM = "minWordsPerTerm";
    private static final String MAXWORDSPERTERM = "maxWordsPerTerm";
    private static final String MINOCCURRENCES = "minOccurrences";
    private static final String STOPWORDSPATH = "stopWordsPath";
    private static final String NOTSTARTWORDSPATH = "notStartWordsPath";
    private static final String NOTENDWORDSPATH = "notEndWordsPath";
    private static final String KEEPCASE = "keepCase";
    private static final String REMOVESUBTERMS = "removeSubTerms";
    private static final String SORTBYOCCURRENCE = "sortByOccurrence";
    private static final String USETERMINOLOGYANNOTATIONS = "useTerminologyAnnotations";
    private static final String USETEXTANALYSISANNOTATIONS = "useTextAnalysisAnnotations";
    private static final String USESTATISTICS = "useStatistics";
    private String outputPath;
    private boolean autoOpen;
    private int minWordsPerTerm;
    private int maxWordsPerTerm;
    private int minOccurrences;
    private String stopWordsPath;
    private String notStartWordsPath;
    private String notEndWordsPath;
    private boolean keepCase;
    private boolean removeSubTerms;
    private boolean sortByOccurrence;
    private boolean useTerminologyAnnotations;
    private boolean useTextAnalysisAnnotations;
    private boolean useStatistics;

    public Parameters() {
        this.reset();
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public int getMinWordsPerTerm() {
        return this.minWordsPerTerm;
    }

    public void setMinWordsPerTerm(int minWordsPerTerm) {
        this.minWordsPerTerm = minWordsPerTerm;
    }

    public int getMaxWordsPerTerm() {
        return this.maxWordsPerTerm;
    }

    public void setMaxWordsPerTerm(int maxWordsPerTerm) {
        this.maxWordsPerTerm = maxWordsPerTerm;
    }

    public int getMinOccurrences() {
        return this.minOccurrences;
    }

    public void setMinOccurrences(int minOccurrences) {
        this.minOccurrences = minOccurrences;
    }

    @ReferenceParameter
    public String getStopWordsPath() {
        return this.stopWordsPath;
    }

    public void setStopWordsPath(String stopWordsPath) {
        this.stopWordsPath = stopWordsPath;
    }

    @ReferenceParameter
    public String getNotStartWordsPath() {
        return this.notStartWordsPath;
    }

    public void setNotStartWordsPath(String notStartWordsPath) {
        this.notStartWordsPath = notStartWordsPath;
    }

    @ReferenceParameter
    public String getNotEndWordsPath() {
        return this.notEndWordsPath;
    }

    public void setNotEndWordsPath(String notEndWordsPath) {
        this.notEndWordsPath = notEndWordsPath;
    }

    public boolean getKeepCase() {
        return this.keepCase;
    }

    public void setKeepCase(boolean keepCase) {
        this.keepCase = keepCase;
    }

    public boolean getRemoveSubTerms() {
        return this.removeSubTerms;
    }

    public void setRemoveSubTerms(boolean removeSubTerms) {
        this.removeSubTerms = removeSubTerms;
    }

    public boolean getSortByOccurrence() {
        return this.sortByOccurrence;
    }

    public void setSortByOccurrence(boolean sortByOccurrence) {
        this.sortByOccurrence = sortByOccurrence;
    }

    public boolean getAutoOpen() {
        return this.autoOpen;
    }

    public void setAutoOpen(boolean autoOpen) {
        this.autoOpen = autoOpen;
    }

    public boolean getUseTextAnalysisAnnotations() {
        return this.useTextAnalysisAnnotations;
    }

    public void setUseTextAnalysisAnnotations(boolean useTextAnalysisAnnotations) {
        this.useTextAnalysisAnnotations = useTextAnalysisAnnotations;
    }

    public boolean getUseTerminologyAnnotations() {
        return this.useTerminologyAnnotations;
    }

    public void setUseTerminologyAnnotations(boolean useTerminologyAnnotations) {
        this.useTerminologyAnnotations = useTerminologyAnnotations;
    }

    public boolean getUseStatistics() {
        return this.useStatistics;
    }

    public void setUseStatistics(boolean useStatistics) {
        this.useStatistics = useStatistics;
    }

    @Override
    public void reset() {
        this.outputPath = "${rootDir}/terms.txt";
        this.autoOpen = false;
        this.minWordsPerTerm = 1;
        this.maxWordsPerTerm = 3;
        this.minOccurrences = 2;
        this.stopWordsPath = "";
        this.notStartWordsPath = "";
        this.notEndWordsPath = "";
        this.keepCase = false;
        this.removeSubTerms = false;
        this.sortByOccurrence = false;
        this.useTerminologyAnnotations = true;
        this.useTextAnalysisAnnotations = true;
        this.useStatistics = true;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.outputPath = this.buffer.getString(OUTPUTPATH, this.outputPath);
        this.minWordsPerTerm = this.buffer.getInteger(MINWORDSPERTERM, this.minWordsPerTerm);
        this.maxWordsPerTerm = this.buffer.getInteger(MAXWORDSPERTERM, this.maxWordsPerTerm);
        this.minOccurrences = this.buffer.getInteger(MINOCCURRENCES, this.minOccurrences);
        this.stopWordsPath = this.buffer.getString(STOPWORDSPATH, this.stopWordsPath);
        this.notStartWordsPath = this.buffer.getString(NOTSTARTWORDSPATH, this.notStartWordsPath);
        this.notEndWordsPath = this.buffer.getString(NOTENDWORDSPATH, this.notEndWordsPath);
        this.keepCase = this.buffer.getBoolean(KEEPCASE, this.keepCase);
        this.removeSubTerms = this.buffer.getBoolean(REMOVESUBTERMS, this.removeSubTerms);
        this.sortByOccurrence = this.buffer.getBoolean(SORTBYOCCURRENCE, this.sortByOccurrence);
        this.autoOpen = this.buffer.getBoolean(AUTOOPEN, this.autoOpen);
        this.useTerminologyAnnotations = this.buffer.getBoolean(USETERMINOLOGYANNOTATIONS, this.useTerminologyAnnotations);
        this.useTextAnalysisAnnotations = this.buffer.getBoolean(USETEXTANALYSISANNOTATIONS, this.useTextAnalysisAnnotations);
        this.useStatistics = this.buffer.getBoolean(USESTATISTICS, this.useStatistics);
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setString(OUTPUTPATH, this.outputPath);
        this.buffer.setInteger(MINWORDSPERTERM, this.minWordsPerTerm);
        this.buffer.setInteger(MAXWORDSPERTERM, this.maxWordsPerTerm);
        this.buffer.setInteger(MINOCCURRENCES, this.minOccurrences);
        this.buffer.setString(STOPWORDSPATH, this.stopWordsPath);
        this.buffer.setString(NOTSTARTWORDSPATH, this.notStartWordsPath);
        this.buffer.setString(NOTENDWORDSPATH, this.notEndWordsPath);
        this.buffer.setBoolean(KEEPCASE, this.keepCase);
        this.buffer.setBoolean(REMOVESUBTERMS, this.removeSubTerms);
        this.buffer.setBoolean(SORTBYOCCURRENCE, this.sortByOccurrence);
        this.buffer.setBoolean(AUTOOPEN, this.autoOpen);
        this.buffer.setBoolean(USETERMINOLOGYANNOTATIONS, this.useTerminologyAnnotations);
        this.buffer.setBoolean(USETEXTANALYSISANNOTATIONS, this.useTextAnalysisAnnotations);
        this.buffer.setBoolean(USESTATISTICS, this.useStatistics);
        return this.buffer.toString();
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(OUTPUTPATH, "Output path", "Full path of the output file");
        desc.add(MINWORDSPERTERM, "Minimum number of words per term", "A term will be made up at least of that many words");
        desc.add(MAXWORDSPERTERM, "Maximum number of words per term", "A term will be made up at the most of that many words");
        desc.add(MINOCCURRENCES, "Minimum number of occurrences per term", "A term will have at least that many occurrences");
        desc.add(STOPWORDSPATH, "Path of the file with stop words (leave empty for default)", "Full path of the file containing stop words");
        desc.add(NOTSTARTWORDSPATH, "Path of the file with not-start words (leave empty for default)", "Full path of the file containing not-start words");
        desc.add(NOTENDWORDSPATH, "Path of the file with not-end words (leave empty for default)", "Full path of the file containing not-end words");
        desc.add(KEEPCASE, "Preserve case differences", null);
        desc.add(REMOVESUBTERMS, "Remove entries that seem to be sub-strings of longer entries", null);
        desc.add(SORTBYOCCURRENCE, "Sort the results by the number of occurrences", null);
        desc.add(SORTBYOCCURRENCE, "Sort the results by the number of occurrences", null);
        desc.add(AUTOOPEN, "Open the result file after completion", null);
        desc.add(USETERMINOLOGYANNOTATIONS, "Use Terminology annotations", null);
        desc.add(USETEXTANALYSISANNOTATIONS, "Use Text Analysis annotations", null);
        desc.add(USESTATISTICS, "Use tokens-grouping statistics", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Term Extraction", true, false);
        PathInputPart pip = desc.addPathInputPart(paramsDesc.get(OUTPUTPATH), "Output File to Generate", true);
        pip.setBrowseFilters("Text Files (*.txt)\tAll Files (*.*)", "*.txt\t*.*");
        desc.addCheckboxPart(paramsDesc.get(AUTOOPEN));
        desc.addCheckboxPart(paramsDesc.get(SORTBYOCCURRENCE));
        desc.addSeparatorPart();
        desc.addCheckboxPart(paramsDesc.get(USETERMINOLOGYANNOTATIONS));
        desc.addCheckboxPart(paramsDesc.get(USETEXTANALYSISANNOTATIONS));
        CheckboxPart cbpUseStats = desc.addCheckboxPart(paramsDesc.get(USESTATISTICS));
        SpinInputPart sip = desc.addSpinInputPart(paramsDesc.get(MINWORDSPERTERM));
        sip.setRange(1, 999);
        sip.setVertical(false);
        sip.setMasterPart(cbpUseStats, true);
        sip = desc.addSpinInputPart(paramsDesc.get(MAXWORDSPERTERM));
        sip.setRange(1, 999);
        sip.setVertical(false);
        sip.setMasterPart(cbpUseStats, true);
        sip = desc.addSpinInputPart(paramsDesc.get(MINOCCURRENCES));
        sip.setRange(1, 999);
        sip.setVertical(false);
        sip.setMasterPart(cbpUseStats, true);
        CheckboxPart cbp = desc.addCheckboxPart(paramsDesc.get(KEEPCASE));
        cbp.setMasterPart(cbpUseStats, true);
        cbp = desc.addCheckboxPart(paramsDesc.get(REMOVESUBTERMS));
        cbp.setMasterPart(cbpUseStats, true);
        pip = desc.addPathInputPart(paramsDesc.get(STOPWORDSPATH), "Stop Words File", false);
        pip.setBrowseFilters("Text Files (*.txt)\tAll Files (*.*)", "*.txt\t*.*");
        pip.setAllowEmpty(true);
        pip.setMasterPart(cbpUseStats, true);
        pip = desc.addPathInputPart(paramsDesc.get(NOTSTARTWORDSPATH), "Not-Start Words File", false);
        pip.setBrowseFilters("Text Files (*.txt)\tAll Files (*.*)", "*.txt\t*.*");
        pip.setAllowEmpty(true);
        pip.setMasterPart(cbpUseStats, true);
        pip = desc.addPathInputPart(paramsDesc.get(NOTENDWORDSPATH), "Not-End Words File", false);
        pip.setBrowseFilters("Text Files (*.txt)\tAll Files (*.*)", "*.txt\t*.*");
        pip.setAllowEmpty(true);
        pip.setMasterPart(cbpUseStats, true);
        return desc;
    }
}

