/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.tmimport;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

@EditorFor(value=Parameters.class)
public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    private static final String TMDIRECTORY = "tmDirectory";
    private static final String OVERWRITESAMESOURCE = "overwriteSameSource";
    private String tmDirectory;
    private boolean overwriteSameSource;

    public Parameters() {
        this.reset();
    }

    public String getTmDirectory() {
        return this.tmDirectory;
    }

    public void setTmDirectory(String tmDirectory) {
        this.tmDirectory = tmDirectory;
    }

    public boolean getOverwriteSameSource() {
        return this.overwriteSameSource;
    }

    public void setOverwriteSameSource(boolean overwriteSameSource) {
        this.overwriteSameSource = overwriteSameSource;
    }

    @Override
    public void reset() {
        this.tmDirectory = "";
        this.overwriteSameSource = false;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.tmDirectory = this.buffer.getString(TMDIRECTORY, this.tmDirectory);
        this.overwriteSameSource = this.buffer.getBoolean(OVERWRITESAMESOURCE, this.overwriteSameSource);
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setString(TMDIRECTORY, this.tmDirectory);
        this.buffer.setBoolean(OVERWRITESAMESOURCE, this.overwriteSameSource);
        return this.buffer.toString();
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(TMDIRECTORY, "Directory of the TM where to import", "Full path of directory of the TM where to import");
        desc.add(OVERWRITESAMESOURCE, "Overwrite if source is the same", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("TM Import", true, false);
        desc.addFolderInputPart(paramDesc.get(TMDIRECTORY), "TM Directory");
        desc.addCheckboxPart(paramDesc.get(OVERWRITESAMESOURCE));
        return desc;
    }
}

