/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xliffkit.writer;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.steps.xliffkit.writer.XLIFFKitWriterStep;

@EditorFor(value=XLIFFKitWriterStep.class)
public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    static final String PLACEHOLDERMODE = "placeholderMode";
    static final String COPYSOURCE = "copySource";
    static final String MESSAGE = "message";
    static final String INCLUDE_NO_TRANSLATE = "includeNoTranslate";
    static final String SET_APPROVED_AS_NO_TRANSLATE = "setApprovedAsNoTranslate";
    static final String OUTPUT_URI = "outputURI";
    static final String INCLUDE_SOURCE = "includeSource";
    static final String INCLUDE_ORIGINAL = "includeOriginal";
    static final String INCLUDE_CODE_ATTRS = "includeCodeAttrs";
    private boolean placeholderMode;
    private boolean copySource;
    private boolean includeNoTranslate;
    private boolean setApprovedAsNoTranslate;
    private String message;
    private String outputURI;
    private boolean includeSource;
    private boolean includeOriginal;
    private boolean includeCodeAttrs;

    public Parameters() {
        this.reset();
    }

    @Override
    public void reset() {
        this.placeholderMode = false;
        this.copySource = true;
        this.includeNoTranslate = true;
        this.setApprovedAsNoTranslate = false;
        this.message = "";
        this.outputURI = "";
        this.includeSource = true;
        this.includeOriginal = false;
        this.includeCodeAttrs = false;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.placeholderMode = this.buffer.getBoolean(PLACEHOLDERMODE, this.placeholderMode);
        this.copySource = this.buffer.getBoolean(COPYSOURCE, this.copySource);
        this.includeNoTranslate = this.buffer.getBoolean(INCLUDE_NO_TRANSLATE, this.includeNoTranslate);
        this.setApprovedAsNoTranslate = this.buffer.getBoolean(SET_APPROVED_AS_NO_TRANSLATE, this.setApprovedAsNoTranslate);
        this.message = this.buffer.getString(MESSAGE, this.message);
        this.outputURI = this.buffer.getString(OUTPUT_URI, this.outputURI);
        this.includeSource = this.buffer.getBoolean(INCLUDE_SOURCE, this.includeSource);
        this.includeOriginal = this.buffer.getBoolean(INCLUDE_ORIGINAL, this.includeOriginal);
        this.includeCodeAttrs = this.buffer.getBoolean(INCLUDE_CODE_ATTRS, this.includeCodeAttrs);
        if (!this.includeNoTranslate) {
            this.setApprovedAsNoTranslate = false;
        }
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setParameter(PLACEHOLDERMODE, this.placeholderMode);
        this.buffer.setBoolean(COPYSOURCE, this.copySource);
        this.buffer.setBoolean(INCLUDE_NO_TRANSLATE, this.includeNoTranslate);
        this.buffer.setBoolean(SET_APPROVED_AS_NO_TRANSLATE, this.setApprovedAsNoTranslate);
        this.buffer.setParameter(MESSAGE, this.message);
        this.buffer.setParameter(OUTPUT_URI, this.outputURI);
        this.buffer.setParameter(INCLUDE_SOURCE, this.includeSource);
        this.buffer.setParameter(INCLUDE_ORIGINAL, this.includeOriginal);
        this.buffer.setParameter(INCLUDE_CODE_ATTRS, this.includeCodeAttrs);
        return this.buffer.toString();
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(PLACEHOLDERMODE, "Use the <g></g> and <x/> notation", null);
        desc.add(COPYSOURCE, "Copy source text in target if no target is available", null);
        desc.add(INCLUDE_NO_TRANSLATE, "Include non-translatable text units", "Include non-translatables");
        desc.add(SET_APPROVED_AS_NO_TRANSLATE, "Set approved entries as non-translatable", "Approved as non-translatable");
        desc.add(MESSAGE, "Description of the XLIFF file", "Description");
        desc.add(OUTPUT_URI, "Directory of the T-kit file", "T-kit Path");
        desc.add(INCLUDE_SOURCE, "Include source files in the T-kit file", "Include source");
        desc.add(INCLUDE_ORIGINAL, "Include original files in the T-kit file", "Include originals");
        desc.add(INCLUDE_CODE_ATTRS, "Include original files in the T-kit file", "Include originals");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription parametersDescription) {
        EditorDescription desc = new EditorDescription("XLIFF Kit Writer Options", true, false);
        desc.addCheckboxPart(parametersDescription.get(PLACEHOLDERMODE));
        desc.addCheckboxPart(parametersDescription.get(COPYSOURCE));
        desc.addCheckboxPart(parametersDescription.get(INCLUDE_NO_TRANSLATE));
        desc.addCheckboxPart(parametersDescription.get(SET_APPROVED_AS_NO_TRANSLATE));
        desc.addTextInputPart(parametersDescription.get(MESSAGE));
        desc.addTextInputPart(parametersDescription.get(OUTPUT_URI));
        desc.addCheckboxPart(parametersDescription.get(INCLUDE_SOURCE));
        desc.addCheckboxPart(parametersDescription.get(INCLUDE_ORIGINAL));
        desc.addCheckboxPart(parametersDescription.get(INCLUDE_CODE_ATTRS));
        return desc;
    }

    public boolean isPlaceholderMode() {
        return this.placeholderMode;
    }

    public void setPlaceholderMode(boolean placeholderMode) {
        this.placeholderMode = placeholderMode;
    }

    public boolean isIncludeNoTranslate() {
        return this.includeNoTranslate;
    }

    public void setIncludeNoTranslate(boolean includeNoTranslate) {
        this.includeNoTranslate = includeNoTranslate;
    }

    public boolean isSetApprovedAsNoTranslate() {
        return this.setApprovedAsNoTranslate;
    }

    public void setSetApprovedAsNoTranslate(boolean setApprovedAsNoTranslate) {
        this.setApprovedAsNoTranslate = setApprovedAsNoTranslate;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getOutputURI() {
        return this.outputURI;
    }

    public void setOutputURI(String outputURI) {
        this.outputURI = outputURI;
    }

    public boolean isIncludeSource() {
        return this.includeSource;
    }

    public void setIncludeSource(boolean includeSource) {
        this.includeSource = includeSource;
    }

    public boolean isIncludeOriginal() {
        return this.includeOriginal;
    }

    public void setIncludeOriginal(boolean includeOriginal) {
        this.includeOriginal = includeOriginal;
    }

    public void setCopySource(boolean copySource) {
        this.copySource = copySource;
    }

    public boolean isCopySource() {
        return this.copySource;
    }

    public void setIncludeCodeAttrs(boolean includeCodeAttrs) {
        this.includeCodeAttrs = includeCodeAttrs;
    }

    public boolean isIncludeCodeAttrs() {
        return this.includeCodeAttrs;
    }
}

