/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.namefind;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.Map;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.namefind.NameEvaluationErrorListener;
import opennlp.tools.cmdline.namefind.TokenNameFinderDetailedFMeasureListener;
import opennlp.tools.cmdline.namefind.TokenNameFinderTrainerTool;
import opennlp.tools.cmdline.namefind.TrainingParams;
import opennlp.tools.cmdline.params.CVParams;
import opennlp.tools.cmdline.params.DetailedFMeasureEvaluatorParams;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.namefind.TokenNameFinderCrossValidator;
import opennlp.tools.namefind.TokenNameFinderEvaluationMonitor;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;

public final class TokenNameFinderCrossValidatorTool
implements CmdLineTool {
    public String getName() {
        return "TokenNameFinderCrossValidator";
    }

    public String getShortDescription() {
        return "K-fold cross validator for the learnable Name Finder";
    }

    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " " + ArgumentParser.createUsage(CVToolParams.class);
    }

    public void run(String[] args) {
        TokenNameFinderCrossValidator validator;
        if (!ArgumentParser.validateArguments(args, CVToolParams.class)) {
            System.err.println(this.getHelp());
            throw new TerminateToolException(1);
        }
        CVToolParams params = ArgumentParser.parse(args, CVToolParams.class);
        TrainingParameters mlParams = CmdLineUtil.loadTrainingParameters(params.getParams(), false);
        byte[] featureGeneratorBytes = TokenNameFinderTrainerTool.openFeatureGeneratorBytes(params.getFeaturegen());
        Map<String, Object> resources = TokenNameFinderTrainerTool.loadResources(params.getResources());
        File trainingDataInFile = params.getData();
        CmdLineUtil.checkInputFile("Training Data", trainingDataInFile);
        Charset encoding = params.getEncoding();
        ObjectStream<NameSample> sampleStream = TokenNameFinderTrainerTool.openSampleData("Training Data", trainingDataInFile, encoding);
        LinkedList<TokenNameFinderEvaluationMonitor> listeners = new LinkedList<TokenNameFinderEvaluationMonitor>();
        if (params.getMisclassified().booleanValue()) {
            listeners.add(new NameEvaluationErrorListener());
        }
        TokenNameFinderDetailedFMeasureListener detailedFListener = null;
        if (params.getDetailedF().booleanValue()) {
            detailedFListener = new TokenNameFinderDetailedFMeasureListener();
            listeners.add(detailedFListener);
        }
        if (mlParams == null) {
            mlParams = new TrainingParameters();
            mlParams.put("Algorithm", "MAXENT");
            mlParams.put("Iterations", Integer.toString(params.getIterations()));
            mlParams.put("Cutoff", Integer.toString(params.getCutoff()));
        }
        try {
            validator = new TokenNameFinderCrossValidator(params.getLang(), params.getType(), mlParams, featureGeneratorBytes, resources, listeners.toArray(new TokenNameFinderEvaluationMonitor[listeners.size()]));
            validator.evaluate(sampleStream, params.getFolds());
        }
        catch (IOException e) {
            CmdLineUtil.printTrainingIoError(e);
            throw new TerminateToolException(-1);
        }
        finally {
            try {
                sampleStream.close();
            }
            catch (IOException e) {}
        }
        System.out.println("done");
        System.out.println();
        if (detailedFListener == null) {
            System.out.println(validator.getFMeasure());
        } else {
            System.out.println(detailedFListener.toString());
        }
    }

    static interface CVToolParams
    extends TrainingParams,
    CVParams,
    DetailedFMeasureEvaluatorParams {
    }
}

