/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.namefind;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.LinkedList;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.PerformanceMonitor;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.namefind.NameEvaluationErrorListener;
import opennlp.tools.cmdline.namefind.TokenNameFinderDetailedFMeasureListener;
import opennlp.tools.cmdline.namefind.TokenNameFinderModelLoader;
import opennlp.tools.cmdline.namefind.TokenNameFinderTrainerTool;
import opennlp.tools.cmdline.params.DetailedFMeasureEvaluatorParams;
import opennlp.tools.cmdline.params.EvaluatorParams;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.namefind.TokenNameFinderEvaluationMonitor;
import opennlp.tools.namefind.TokenNameFinderEvaluator;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.util.ObjectStream;

public final class TokenNameFinderEvaluatorTool
implements CmdLineTool {
    public String getName() {
        return "TokenNameFinderEvaluator";
    }

    public String getShortDescription() {
        return "";
    }

    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " " + ArgumentParser.createUsage(EvalToolParams.class);
    }

    public void run(String[] args) {
        if (!ArgumentParser.validateArguments(args, EvalToolParams.class)) {
            System.err.println(this.getHelp());
            throw new TerminateToolException(1);
        }
        EvalToolParams params = ArgumentParser.parse(args, EvalToolParams.class);
        File testData = params.getData();
        CmdLineUtil.checkInputFile("Test data", testData);
        Charset encoding = params.getEncoding();
        TokenNameFinderModel model = (TokenNameFinderModel)new TokenNameFinderModelLoader().load(params.getModel());
        LinkedList<TokenNameFinderEvaluationMonitor> listeners = new LinkedList<TokenNameFinderEvaluationMonitor>();
        if (params.getMisclassified().booleanValue()) {
            listeners.add(new NameEvaluationErrorListener());
        }
        TokenNameFinderDetailedFMeasureListener detailedFListener = null;
        if (params.getDetailedF().booleanValue()) {
            detailedFListener = new TokenNameFinderDetailedFMeasureListener();
            listeners.add(detailedFListener);
        }
        TokenNameFinderEvaluator evaluator = new TokenNameFinderEvaluator(new NameFinderME(model), listeners.toArray(new TokenNameFinderEvaluationMonitor[listeners.size()]));
        final ObjectStream<NameSample> sampleStream = TokenNameFinderTrainerTool.openSampleData("Test", testData, encoding);
        final PerformanceMonitor monitor = new PerformanceMonitor("sent");
        ObjectStream<NameSample> measuredSampleStream = new ObjectStream<NameSample>(){

            @Override
            public NameSample read() throws IOException {
                monitor.incrementCounter();
                return (NameSample)sampleStream.read();
            }

            @Override
            public void reset() throws IOException {
                sampleStream.reset();
            }

            @Override
            public void close() throws IOException {
                sampleStream.close();
            }
        };
        monitor.startAndPrintThroughput();
        try {
            evaluator.evaluate(measuredSampleStream);
        }
        catch (IOException e) {
            System.err.println("failed");
            System.err.println("Reading test data error " + e.getMessage());
            throw new TerminateToolException(-1);
        }
        finally {
            try {
                measuredSampleStream.close();
            }
            catch (IOException e) {}
        }
        monitor.stopAndPrintFinalResult();
        System.out.println();
        if (detailedFListener == null) {
            System.out.println(evaluator.getFMeasure());
        } else {
            System.out.println(detailedFListener.toString());
        }
    }

    static interface EvalToolParams
    extends EvaluatorParams,
    DetailedFMeasureEvaluatorParams {
    }
}

