/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.namefind;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.namefind.TrainingParams;
import opennlp.tools.cmdline.params.TrainingToolParams;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.namefind.NameSampleDataStream;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenNameFinderTrainerTool
implements CmdLineTool {
    @Override
    public String getName() {
        return "TokenNameFinderTrainer";
    }

    @Override
    public String getShortDescription() {
        return "trainer for the learnable name finder";
    }

    @Override
    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " " + ArgumentParser.createUsage(TrainerToolParams.class);
    }

    static ObjectStream<NameSample> openSampleData(String sampleDataName, File sampleDataFile, Charset encoding) {
        CmdLineUtil.checkInputFile(sampleDataName + " Data", sampleDataFile);
        FileInputStream sampleDataIn = CmdLineUtil.openInFile(sampleDataFile);
        PlainTextByLineStream lineStream = new PlainTextByLineStream(sampleDataIn.getChannel(), encoding);
        return new NameSampleDataStream(lineStream);
    }

    static byte[] openFeatureGeneratorBytes(String featureGenDescriptorFile) {
        if (featureGenDescriptorFile != null) {
            return TokenNameFinderTrainerTool.openFeatureGeneratorBytes(new File(featureGenDescriptorFile));
        }
        return null;
    }

    static byte[] openFeatureGeneratorBytes(File featureGenDescriptorFile) {
        byte[] featureGeneratorBytes = null;
        if (featureGenDescriptorFile != null) {
            FileInputStream bytesIn = CmdLineUtil.openInFile(featureGenDescriptorFile);
            try {
                featureGeneratorBytes = ModelUtil.read(bytesIn);
            }
            catch (IOException e) {
                CmdLineUtil.printTrainingIoError(e);
                throw new TerminateToolException(-1);
            }
            finally {
                try {
                    ((InputStream)bytesIn).close();
                }
                catch (IOException e) {}
            }
        }
        return featureGeneratorBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, Object> loadResources(File resourcePath) {
        HashMap<String, Object> resources = new HashMap<String, Object>();
        if (resourcePath != null) {
            File[] resourceFiles;
            Map<String, ArtifactSerializer> artifactSerializers = TokenNameFinderModel.createArtifactSerializers();
            for (File resourceFile : resourceFiles = resourcePath.listFiles()) {
                String ending;
                ArtifactSerializer serializer;
                String resourceName = resourceFile.getName();
                int lastDot = resourceName.lastIndexOf(46);
                if (lastDot == -1 || (serializer = artifactSerializers.get(ending = resourceName.substring(lastDot + 1))) == null) continue;
                FileInputStream resoruceIn = CmdLineUtil.openInFile(resourceFile);
                try {
                    resources.put(resourceName, serializer.create(resoruceIn));
                }
                catch (InvalidFormatException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        ((InputStream)resoruceIn).close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return resources;
    }

    static Map<String, Object> loadResources(String resourceDirectory) {
        if (resourceDirectory != null) {
            File resourcePath = new File(resourceDirectory);
            return TokenNameFinderTrainerTool.loadResources(resourcePath);
        }
        return new HashMap<String, Object>();
    }

    @Override
    public void run(String[] args) {
        TokenNameFinderModel model;
        if (!ArgumentParser.validateArguments(args, TrainerToolParams.class)) {
            System.err.println(this.getHelp());
            throw new TerminateToolException(1);
        }
        TrainerToolParams params = ArgumentParser.parse(args, TrainerToolParams.class);
        TrainingParameters mlParams = CmdLineUtil.loadTrainingParameters(params.getParams(), true);
        File trainingDataInFile = params.getData();
        File modelOutFile = params.getModel();
        byte[] featureGeneratorBytes = TokenNameFinderTrainerTool.openFeatureGeneratorBytes(params.getFeaturegen());
        Map<String, Object> resources = TokenNameFinderTrainerTool.loadResources(params.getResources());
        CmdLineUtil.checkOutputFile("name finder model", modelOutFile);
        ObjectStream<NameSample> sampleStream = TokenNameFinderTrainerTool.openSampleData("Training", trainingDataInFile, params.getEncoding());
        try {
            model = mlParams == null ? NameFinderME.train(params.getLang(), params.getType(), sampleStream, featureGeneratorBytes, resources, (int)params.getIterations(), (int)params.getCutoff()) : NameFinderME.train(params.getLang(), params.getType(), sampleStream, mlParams, featureGeneratorBytes, resources);
        }
        catch (IOException e) {
            CmdLineUtil.printTrainingIoError(e);
            throw new TerminateToolException(-1);
        }
        finally {
            try {
                sampleStream.close();
            }
            catch (IOException e) {}
        }
        CmdLineUtil.writeModel("name finder", modelOutFile, model);
    }

    static interface TrainerToolParams
    extends TrainingParams,
    TrainingToolParams {
    }
}

