/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.postag;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.CVParams;
import opennlp.tools.cmdline.postag.POSEvaluationErrorListener;
import opennlp.tools.cmdline.postag.POSTaggerTrainerTool;
import opennlp.tools.cmdline.postag.TrainingParams;
import opennlp.tools.postag.POSDictionary;
import opennlp.tools.postag.POSSample;
import opennlp.tools.postag.POSTaggerCrossValidator;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;

public final class POSTaggerCrossValidatorTool
implements CmdLineTool {
    public String getName() {
        return "POSTaggerCrossValidator";
    }

    public String getShortDescription() {
        return "K-fold cross validator for the learnable POS tagger";
    }

    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " " + ArgumentParser.createUsage(CVToolParams.class);
    }

    public void run(String[] args) {
        POSTaggerCrossValidator validator;
        if (!ArgumentParser.validateArguments(args, CVToolParams.class)) {
            System.err.println(this.getHelp());
            throw new TerminateToolException(1);
        }
        CVToolParams params = ArgumentParser.parse(args, CVToolParams.class);
        TrainingParameters mlParams = CmdLineUtil.loadTrainingParameters(params.getParams(), false);
        File trainingDataInFile = params.getData();
        CmdLineUtil.checkInputFile("Training Data", trainingDataInFile);
        ObjectStream<POSSample> sampleStream = POSTaggerTrainerTool.openSampleData("Training Data", trainingDataInFile, params.getEncoding());
        POSEvaluationErrorListener missclassifiedListener = null;
        if (params.getMisclassified().booleanValue()) {
            missclassifiedListener = new POSEvaluationErrorListener();
        }
        if (mlParams == null) {
            mlParams = new TrainingParameters();
            mlParams.put("Algorithm", "MAXENT");
            mlParams.put("Iterations", Integer.toString(params.getIterations()));
            mlParams.put("Cutoff", Integer.toString(params.getCutoff()));
        }
        try {
            POSDictionary tagdict = null;
            if (params.getDict() != null) {
                tagdict = POSDictionary.create(new FileInputStream(params.getDict()));
            }
            validator = new POSTaggerCrossValidator(params.getLang(), mlParams, tagdict, params.getNgram(), missclassifiedListener);
            validator.evaluate(sampleStream, params.getFolds());
        }
        catch (IOException e) {
            CmdLineUtil.printTrainingIoError(e);
            throw new TerminateToolException(-1);
        }
        finally {
            try {
                sampleStream.close();
            }
            catch (IOException e) {}
        }
        System.out.println("done");
        System.out.println();
        System.out.println("Accuracy: " + validator.getWordAccuracy());
    }

    static interface CVToolParams
    extends CVParams,
    TrainingParams {
    }
}

