/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.postag;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.EvaluatorParams;
import opennlp.tools.cmdline.postag.POSEvaluationErrorListener;
import opennlp.tools.cmdline.postag.POSModelLoader;
import opennlp.tools.cmdline.postag.POSTaggerTrainerTool;
import opennlp.tools.postag.POSEvaluator;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSSample;
import opennlp.tools.postag.POSTaggerME;
import opennlp.tools.util.ObjectStream;

public final class POSTaggerEvaluatorTool
implements CmdLineTool {
    public String getName() {
        return "POSTaggerEvaluator";
    }

    public String getShortDescription() {
        return "";
    }

    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " " + ArgumentParser.createUsage(EvaluatorParams.class);
    }

    public void run(String[] args) {
        if (!ArgumentParser.validateArguments(args, EvaluatorParams.class)) {
            System.err.println(this.getHelp());
            throw new TerminateToolException(1);
        }
        EvaluatorParams params = ArgumentParser.parse(args, EvaluatorParams.class);
        File testData = params.getData();
        CmdLineUtil.checkInputFile("Test data", testData);
        Charset encoding = params.getEncoding();
        POSModel model = (POSModel)new POSModelLoader().load(params.getModel());
        POSEvaluationErrorListener missclassifiedListener = null;
        if (params.getMisclassified().booleanValue()) {
            missclassifiedListener = new POSEvaluationErrorListener();
        }
        POSEvaluator evaluator = new POSEvaluator(new POSTaggerME(model), missclassifiedListener);
        System.out.print("Evaluating ... ");
        ObjectStream<POSSample> sampleStream = POSTaggerTrainerTool.openSampleData("Test", testData, encoding);
        try {
            evaluator.evaluate(sampleStream);
        }
        catch (IOException e) {
            System.err.println("failed");
            System.err.println("Reading test data error " + e.getMessage());
            throw new TerminateToolException(-1);
        }
        finally {
            try {
                sampleStream.close();
            }
            catch (IOException e) {}
        }
        System.out.println("done");
        System.out.println();
        System.out.println("Accuracy: " + evaluator.getWordAccuracy());
    }
}

