/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.doccat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import opennlp.tools.tokenize.WhitespaceTokenizer;

public class DocumentSample {
    private final String category;
    private final List<String> text;

    public DocumentSample(String category, String text) {
        this(category, WhitespaceTokenizer.INSTANCE.tokenize(text));
    }

    public DocumentSample(String category, String[] text) {
        if (category == null || text == null) {
            throw new IllegalArgumentException();
        }
        this.category = category;
        this.text = Collections.unmodifiableList(new ArrayList<String>(Arrays.asList(text)));
    }

    public String getCategory() {
        return this.category;
    }

    public String[] getText() {
        return this.text.toArray(new String[this.text.size()]);
    }

    public String toString() {
        StringBuilder sampleString = new StringBuilder();
        sampleString.append(this.category).append('\t');
        for (int i = 0; i < this.text.size(); ++i) {
            sampleString.append(this.text.get(i)).append(' ');
        }
        if (sampleString.length() > 0) {
            sampleString.setLength(sampleString.length() - 1);
        }
        return sampleString.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DocumentSample) {
            DocumentSample a = (DocumentSample)obj;
            return this.getCategory().equals(a.getCategory()) && Arrays.equals(this.getText(), a.getText());
        }
        return false;
    }
}

