/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.Span;
import opennlp.tools.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Conll02NameSampleStream
implements ObjectStream<NameSample> {
    public static final int GENERATE_PERSON_ENTITIES = 1;
    public static final int GENERATE_ORGANIZATION_ENTITIES = 2;
    public static final int GENERATE_LOCATION_ENTITIES = 4;
    public static final int GENERATE_MISC_ENTITIES = 8;
    public static final String DOCSTART = "-DOCSTART-";
    private final LANGUAGE lang;
    private final ObjectStream<String> lineStream;
    private final int types;

    public Conll02NameSampleStream(LANGUAGE lang, ObjectStream<String> lineStream, int types) {
        this.lang = lang;
        this.lineStream = lineStream;
        this.types = types;
    }

    public Conll02NameSampleStream(LANGUAGE lang, InputStream in, int types) {
        this.lang = lang;
        try {
            this.lineStream = new PlainTextByLineStream(in, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        this.types = types;
    }

    static final Span extract(int begin, int end, String beginTag) throws InvalidFormatException {
        String type = beginTag.substring(2);
        if ("PER".equals(type)) {
            type = "person";
        } else if ("LOC".equals(type)) {
            type = "location";
        } else if ("MISC".equals(type)) {
            type = "misc";
        } else if ("ORG".equals(type)) {
            type = "organization";
        } else {
            throw new InvalidFormatException("Unkonw type: " + type);
        }
        return new Span(begin, end, type);
    }

    @Override
    public NameSample read() throws IOException {
        String line;
        ArrayList<String> sentence = new ArrayList<String>();
        ArrayList<String> tags = new ArrayList<String>();
        boolean isClearAdaptiveData = false;
        while ((line = this.lineStream.read()) != null && !StringUtil.isEmpty(line)) {
            if (LANGUAGE.NL.equals((Object)this.lang) && line.startsWith(DOCSTART)) {
                isClearAdaptiveData = true;
                continue;
            }
            String[] fields = line.split(" ");
            if (fields.length == 3) {
                sentence.add(fields[0]);
                tags.add(fields[2]);
                continue;
            }
            throw new IOException("Expected three fields per line in training data!");
        }
        if (LANGUAGE.ES.equals((Object)this.lang)) {
            isClearAdaptiveData = true;
        }
        if (sentence.size() > 0) {
            ArrayList<Span> names = new ArrayList<Span>();
            int beginIndex = -1;
            int endIndex = -1;
            for (int i = 0; i < tags.size(); ++i) {
                String tag = (String)tags.get(i);
                if (tag.endsWith("PER") && (this.types & 1) == 0) {
                    tag = "O";
                }
                if (tag.endsWith("ORG") && (this.types & 2) == 0) {
                    tag = "O";
                }
                if (tag.endsWith("LOC") && (this.types & 4) == 0) {
                    tag = "O";
                }
                if (tag.endsWith("MISC") && (this.types & 8) == 0) {
                    tag = "O";
                }
                if (tag.startsWith("B-")) {
                    if (beginIndex != -1) {
                        names.add(Conll02NameSampleStream.extract(beginIndex, endIndex, (String)tags.get(beginIndex)));
                        beginIndex = -1;
                        endIndex = -1;
                    }
                    beginIndex = i;
                    endIndex = i + 1;
                    continue;
                }
                if (tag.startsWith("I-")) {
                    ++endIndex;
                    continue;
                }
                if (tag.equals("O")) {
                    if (beginIndex == -1) continue;
                    names.add(Conll02NameSampleStream.extract(beginIndex, endIndex, (String)tags.get(beginIndex)));
                    beginIndex = -1;
                    endIndex = -1;
                    continue;
                }
                throw new IOException("Invalid tag: " + tag);
            }
            if (beginIndex != -1) {
                names.add(Conll02NameSampleStream.extract(beginIndex, endIndex, (String)tags.get(beginIndex)));
            }
            return new NameSample(sentence.toArray(new String[sentence.size()]), names.toArray(new Span[names.size()]), isClearAdaptiveData);
        }
        if (line != null) {
            return this.read();
        }
        return null;
    }

    @Override
    public void reset() throws IOException, UnsupportedOperationException {
        this.lineStream.reset();
    }

    @Override
    public void close() throws IOException {
        this.lineStream.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LANGUAGE {
        NL,
        ES;

    }
}

