/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrainingParameters {
    public static final String ALGORITHM_PARAM = "Algorithm";
    public static final String ITERATIONS_PARAM = "Iterations";
    public static final String CUTOFF_PARAM = "Cutoff";
    private Map<String, String> parameters = new HashMap<String, String>();

    public TrainingParameters() {
    }

    public TrainingParameters(InputStream in) throws IOException {
        Properties properties = new Properties();
        properties.load(in);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            this.parameters.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public String algorithm(String namespace) {
        return this.parameters.get(namespace + "." + ALGORITHM_PARAM);
    }

    public String algorithm() {
        return this.parameters.get(ALGORITHM_PARAM);
    }

    public Map<String, String> getSettings(String namespace) {
        HashMap<String, String> trainingParams = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            String key = entry.getKey();
            if (namespace != null) {
                String prefix = namespace + ".";
                if (!key.startsWith(prefix)) continue;
                trainingParams.put(key.substring(prefix.length()), entry.getValue());
                continue;
            }
            if (key.contains(".")) continue;
            trainingParams.put(key, entry.getValue());
        }
        return Collections.unmodifiableMap(trainingParams);
    }

    public Map<String, String> getSettings() {
        return this.getSettings(null);
    }

    public TrainingParameters getParameters(String namespace) {
        TrainingParameters params = new TrainingParameters();
        for (Map.Entry<String, String> entry : this.getSettings(namespace).entrySet()) {
            params.put(entry.getKey(), entry.getValue());
        }
        return params;
    }

    public void put(String namespace, String key, String value) {
        if (namespace == null) {
            this.parameters.put(key, value);
        } else {
            this.parameters.put(namespace + "." + key, value);
        }
    }

    public void put(String key, String value) {
        this.put(null, key, value);
    }

    public void serialize(OutputStream out) throws IOException {
        Properties properties = new Properties();
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            properties.put(entry.getKey(), entry.getValue());
        }
        properties.store(out, null);
    }
}

