/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.RuntimeDelegate;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.ClientResponseFailure;
import org.jboss.resteasy.client.core.BaseClientResponse;
import org.jboss.resteasy.client.core.ClientInterceptorRepositoryImpl;
import org.jboss.resteasy.client.core.ClientMessageBodyWriterContext;
import org.jboss.resteasy.core.interception.ClientExecutionContextImpl;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.specimpl.UriBuilderImpl;
import org.jboss.resteasy.spi.Link;
import org.jboss.resteasy.spi.LinkHeader;
import org.jboss.resteasy.spi.ProviderFactoryDelegate;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.StringConverter;
import org.jboss.resteasy.util.Encode;
import org.jboss.resteasy.util.GenericType;

public class ClientRequest
extends ClientInterceptorRepositoryImpl
implements Cloneable {
    protected ResteasyProviderFactory providerFactory;
    protected UriBuilderImpl uri;
    protected ClientExecutor executor;
    protected MultivaluedMap<String, Object> headers;
    protected MultivaluedMap<String, String> queryParameters;
    protected MultivaluedMap<String, String> formParameters;
    protected MultivaluedMap<String, String> pathParameters;
    protected MultivaluedMap<String, String> matrixParameters;
    protected Object body;
    protected Class bodyType;
    protected Type bodyGenericType;
    protected Annotation[] bodyAnnotations;
    protected MediaType bodyContentType;
    protected boolean followRedirects;
    protected String httpMethod;
    protected String finalUri;
    protected List<String> pathParameterList;
    protected LinkHeader linkHeader;
    protected Map<String, Object> attributes = new HashMap<String, Object>();
    private static String defaultExecutorClasss = "org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor";

    public static void setDefaultExecutorClass(String classname) {
        defaultExecutorClasss = classname;
    }

    public static ClientExecutor getDefaultExecutor() {
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(defaultExecutorClasss);
            return (ClientExecutor)clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ClientRequest(String uriTemplate) {
        this(uriTemplate, ClientRequest.getDefaultExecutor());
    }

    public ClientRequest(String uriTemplate, ClientExecutor executor) {
        this(ClientRequest.getBuilder(uriTemplate), executor);
    }

    public ClientRequest(UriBuilder uri, ClientExecutor executor) {
        this(uri, executor, ResteasyProviderFactory.getInstance());
    }

    public ClientRequest(UriBuilder uri, ClientExecutor executor, ResteasyProviderFactory providerFactory) {
        this.uri = (UriBuilderImpl)uri;
        this.executor = executor;
        this.providerFactory = providerFactory instanceof ProviderFactoryDelegate ? ((ProviderFactoryDelegate)((Object)providerFactory)).getDelegate() : providerFactory;
    }

    public void clear() {
        this.headers = null;
        this.queryParameters = null;
        this.formParameters = null;
        this.pathParameters = null;
        this.matrixParameters = null;
        this.body = null;
        this.bodyType = null;
        this.bodyGenericType = null;
        this.bodyAnnotations = null;
        this.bodyContentType = null;
        this.httpMethod = null;
        this.finalUri = null;
        this.pathParameterList = null;
        this.linkHeader = null;
    }

    private static UriBuilder getBuilder(String uriTemplate) {
        return new UriBuilderImpl().uriTemplate(uriTemplate);
    }

    public boolean followRedirects() {
        return this.followRedirects;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public ClientRequest followRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    public ClientRequest accept(MediaType accepts) {
        return this.header("Accept", accepts.toString());
    }

    public ClientRequest accept(String accept) {
        String curr = (String)this.getHeadersAsObjects().getFirst("Accept");
        curr = curr != null ? curr + "," + accept : accept;
        this.getHeadersAsObjects().putSingle("Accept", curr);
        return this;
    }

    protected String toString(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        StringConverter converter = this.providerFactory.getStringConverter(object.getClass());
        if (converter != null) {
            return converter.toString(object);
        }
        return object.toString();
    }

    protected String toHeaderString(Object object) {
        StringConverter converter = this.providerFactory.getStringConverter(object.getClass());
        if (converter != null) {
            return converter.toString(object);
        }
        RuntimeDelegate.HeaderDelegate<?> delegate = this.providerFactory.createHeaderDelegate(object.getClass());
        if (delegate != null) {
            return delegate.toString(object);
        }
        return object.toString();
    }

    public ClientRequest addLink(Link link) {
        if (this.linkHeader == null) {
            this.linkHeader = new LinkHeader();
        }
        this.linkHeader.getLinks().add(link);
        return this;
    }

    public ClientRequest addLink(String title, String rel, String href, String type) {
        Link link = new Link(title, rel, href, type, null);
        return this.addLink(link);
    }

    public ClientRequest formParameter(String parameterName, Object value) {
        this.getFormParameters().add(parameterName, this.toString(value));
        return this;
    }

    public ClientRequest queryParameter(String parameterName, Object value) {
        this.getQueryParameters().add(parameterName, this.toString(value));
        return this;
    }

    public ClientRequest matrixParameter(String parameterName, Object value) {
        this.getMatrixParameters().add(parameterName, this.toString(value));
        return this;
    }

    public ClientRequest header(String headerName, Object value) {
        this.getHeadersAsObjects().add(headerName, value);
        return this;
    }

    public ClientRequest cookie(String cookieName, Object value) {
        return this.cookie(new Cookie(cookieName, this.toString(value)));
    }

    public ClientRequest cookie(Cookie cookie) {
        return this.header("Cookie", cookie);
    }

    public ClientRequest pathParameter(String parameterName, Object value) {
        this.getPathParameters().add(parameterName, this.toString(value));
        return this;
    }

    public ClientRequest pathParameters(Object ... values) {
        for (Object value : values) {
            this.getPathParameterList().add(this.toString(value));
        }
        return this;
    }

    public ClientRequest body(String contentType, Object data) {
        return this.body(MediaType.valueOf(contentType), data, data.getClass(), null, null);
    }

    public ClientRequest body(MediaType contentType, Object data) {
        return this.body(contentType, data, data.getClass(), null, null);
    }

    public ClientRequest body(MediaType contentType, Object data, GenericType genericType) {
        return this.body(contentType, data, genericType.getType(), genericType.getGenericType(), null);
    }

    public ClientRequest body(MediaType contentType, Object data, Type genericType) {
        return this.body(contentType, data, data.getClass(), genericType, null);
    }

    public ClientRequest body(MediaType contentType, Object data, Class type, Type genericType, Annotation[] annotations) {
        this.body = data;
        this.bodyContentType = contentType;
        this.bodyGenericType = genericType;
        this.bodyType = type;
        this.bodyAnnotations = annotations;
        return this;
    }

    public ResteasyProviderFactory getProviderFactory() {
        return this.providerFactory;
    }

    public ClientExecutor getExecutor() {
        return this.executor;
    }

    public MultivaluedMap<String, String> getHeaders() {
        MultivaluedMapImpl<String, String> rtn = new MultivaluedMapImpl<String, String>();
        if (this.headers == null) {
            return rtn;
        }
        for (Map.Entry entry : this.headers.entrySet()) {
            for (Object obj : (List)entry.getValue()) {
                rtn.add((String)entry.getKey(), this.toHeaderString(obj));
            }
        }
        return rtn;
    }

    public MultivaluedMap<String, Object> getHeadersAsObjects() {
        if (this.headers == null) {
            this.headers = new MultivaluedMapImpl<String, Object>();
        }
        return this.headers;
    }

    public MultivaluedMap<String, String> getQueryParameters() {
        if (this.queryParameters == null) {
            this.queryParameters = new MultivaluedMapImpl<String, String>();
        }
        return this.queryParameters;
    }

    public MultivaluedMap<String, String> getFormParameters() {
        if (this.formParameters == null) {
            this.formParameters = new MultivaluedMapImpl<String, String>();
        }
        return this.formParameters;
    }

    public MultivaluedMap<String, String> getPathParameters() {
        if (this.pathParameters == null) {
            this.pathParameters = new MultivaluedMapImpl<String, String>();
        }
        return this.pathParameters;
    }

    public List<String> getPathParameterList() {
        if (this.pathParameterList == null) {
            this.pathParameterList = new ArrayList<String>();
        }
        return this.pathParameterList;
    }

    public MultivaluedMap<String, String> getMatrixParameters() {
        if (this.matrixParameters == null) {
            this.matrixParameters = new MultivaluedMapImpl<String, String>();
        }
        return this.matrixParameters;
    }

    public Object getBody() {
        return this.body;
    }

    public Class getBodyType() {
        return this.bodyType;
    }

    public Type getBodyGenericType() {
        return this.bodyGenericType;
    }

    public Annotation[] getBodyAnnotations() {
        return this.bodyAnnotations;
    }

    public MediaType getBodyContentType() {
        return this.bodyContentType;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public ClientResponse execute() throws Exception {
        if (this.linkHeader != null) {
            this.header("Link", this.linkHeader);
        }
        if (this.getReaderInterceptorList().isEmpty()) {
            this.setReaderInterceptors(this.providerFactory.getClientMessageBodyReaderInterceptorRegistry().bindForList(null, null));
        }
        if (this.getExecutionInterceptorList().isEmpty()) {
            this.setExecutionInterceptors(this.providerFactory.getClientExecutionInterceptorRegistry().bindForList(null, null));
        }
        BaseClientResponse response = null;
        if (this.getExecutionInterceptorList().isEmpty()) {
            response = (BaseClientResponse)this.executor.execute(this);
        } else {
            ClientExecutionContextImpl ctx = new ClientExecutionContextImpl(this.getExecutionInterceptorList(), this.executor, this);
            response = (BaseClientResponse)ctx.proceed();
        }
        response.setAttributes(this.attributes);
        response.setMessageBodyReaderInterceptors(this.getReaderInterceptors());
        return response;
    }

    public void writeRequestBody(MultivaluedMap<String, Object> headers, OutputStream outputStream) throws IOException {
        MessageBodyWriter writer;
        if (this.body == null) {
            return;
        }
        if (this.getWriterInterceptorList().isEmpty()) {
            this.setWriterInterceptors(this.providerFactory.getClientMessageBodyWriterInterceptorRegistry().bindForList(null, null));
        }
        if ((writer = this.providerFactory.getMessageBodyWriter(this.bodyType, this.bodyGenericType, this.bodyAnnotations, this.bodyContentType)) == null) {
            throw new RuntimeException("could not find writer for content-type " + this.bodyContentType + " type: " + this.bodyType.getName());
        }
        new ClientMessageBodyWriterContext(this.getWriterInterceptors(), writer, this.body, this.bodyType, this.bodyGenericType, this.bodyAnnotations, this.bodyContentType, headers, outputStream, this.attributes).proceed();
    }

    public ClientResponse get() throws Exception {
        return this.httpMethod("GET");
    }

    public <T> T getTarget(Class<T> returnType) throws Exception {
        BaseClientResponse response = (BaseClientResponse)this.get(returnType);
        if (response.getStatus() == 204) {
            return null;
        }
        if (response.getStatus() != 200) {
            throw new ClientResponseFailure(response);
        }
        return response.getEntity();
    }

    public <T> ClientResponse<T> get(Class<T> returnType) throws Exception {
        BaseClientResponse response = (BaseClientResponse)this.get();
        response.setReturnType(returnType);
        return response;
    }

    public <T> ClientResponse<T> get(Class<T> returnType, Type genericType) throws Exception {
        BaseClientResponse response = (BaseClientResponse)this.get();
        response.setReturnType(returnType);
        response.setGenericReturnType(genericType);
        return response;
    }

    public <T> ClientResponse<T> get(GenericType type) throws Exception {
        BaseClientResponse response = (BaseClientResponse)this.get();
        response.setReturnType(type.getType());
        response.setGenericReturnType(type.getGenericType());
        return response;
    }

    public ClientResponse head() throws Exception {
        return this.httpMethod("HEAD");
    }

    public ClientResponse put() throws Exception {
        return this.httpMethod("PUT");
    }

    public <T> ClientResponse<T> put(Class<T> returnType) throws Exception {
        BaseClientResponse response = (BaseClientResponse)this.put();
        response.setReturnType(returnType);
        return response;
    }

    public <T> ClientResponse<T> put(Class<T> returnType, Type genericType) throws Exception {
        BaseClientResponse response = (BaseClientResponse)this.put();
        response.setReturnType(returnType);
        response.setGenericReturnType(genericType);
        return response;
    }

    public <T> ClientResponse<T> put(GenericType type) throws Exception {
        BaseClientResponse response = (BaseClientResponse)this.put();
        response.setReturnType(type.getType());
        response.setGenericReturnType(type.getGenericType());
        return response;
    }

    public ClientResponse post() throws Exception {
        return this.httpMethod("POST");
    }

    public <T> ClientResponse<T> post(Class<T> returnType) throws Exception {
        BaseClientResponse response = (BaseClientResponse)this.post();
        response.setReturnType(returnType);
        return response;
    }

    public <T> T postTarget(Class<T> returnType) throws Exception {
        BaseClientResponse response = (BaseClientResponse)this.post(returnType);
        if (response.getStatus() == 204) {
            return null;
        }
        if (response.getStatus() != 200) {
            throw new ClientResponseFailure(response);
        }
        return response.getEntity();
    }

    public <T> ClientResponse<T> post(Class<T> returnType, Type genericType) throws Exception {
        BaseClientResponse response = (BaseClientResponse)this.post();
        response.setReturnType(returnType);
        response.setGenericReturnType(genericType);
        return response;
    }

    public <T> ClientResponse<T> post(GenericType type) throws Exception {
        BaseClientResponse response = (BaseClientResponse)this.post();
        response.setReturnType(type.getType());
        response.setGenericReturnType(type.getGenericType());
        return response;
    }

    public Link create() throws Exception, ClientResponseFailure {
        BaseClientResponse response = (BaseClientResponse)this.post();
        if (response.getStatus() != 201) {
            throw new ClientResponseFailure(response);
        }
        return response.getLocation();
    }

    public ClientResponse delete() throws Exception {
        return this.httpMethod("DELETE");
    }

    public <T> ClientResponse<T> delete(Class<T> returnType) throws Exception {
        BaseClientResponse response = (BaseClientResponse)this.delete();
        response.setReturnType(returnType);
        return response;
    }

    public <T> ClientResponse<T> delete(Class<T> returnType, Type genericType) throws Exception {
        BaseClientResponse response = (BaseClientResponse)this.delete();
        response.setReturnType(returnType);
        response.setGenericReturnType(genericType);
        return response;
    }

    public <T> ClientResponse<T> delete(GenericType type) throws Exception {
        BaseClientResponse response = (BaseClientResponse)this.delete();
        response.setReturnType(type.getType());
        response.setGenericReturnType(type.getGenericType());
        return response;
    }

    public ClientResponse options() throws Exception {
        return this.httpMethod("OPTIONS");
    }

    public <T> ClientResponse<T> options(Class<T> returnType) throws Exception {
        BaseClientResponse response = (BaseClientResponse)this.options();
        response.setReturnType(returnType);
        return response;
    }

    public <T> ClientResponse<T> options(Class<T> returnType, Type genericType) throws Exception {
        BaseClientResponse response = (BaseClientResponse)this.options();
        response.setReturnType(returnType);
        response.setGenericReturnType(genericType);
        return response;
    }

    public <T> ClientResponse<T> options(GenericType type) throws Exception {
        BaseClientResponse response = (BaseClientResponse)this.options();
        response.setReturnType(type.getType());
        response.setGenericReturnType(type.getGenericType());
        return response;
    }

    public ClientResponse httpMethod(String httpMethod) throws Exception {
        this.httpMethod = httpMethod;
        return this.execute();
    }

    public <T> ClientResponse<T> httpMethod(String method, Class<T> returnType) throws Exception {
        BaseClientResponse response = (BaseClientResponse)this.httpMethod(method);
        response.setReturnType(returnType);
        return response;
    }

    public <T> ClientResponse<T> httpMethod(String method, Class<T> returnType, Type genericType) throws Exception {
        BaseClientResponse response = (BaseClientResponse)this.httpMethod(method);
        response.setReturnType(returnType);
        response.setGenericReturnType(genericType);
        return response;
    }

    public <T> ClientResponse<T> httpMethod(String method, GenericType type) throws Exception {
        BaseClientResponse response = (BaseClientResponse)this.httpMethod(method);
        response.setReturnType(type.getType());
        response.setGenericReturnType(type.getGenericType());
        return response;
    }

    public void overrideUri(URI uri) {
        this.uri.uri(uri);
    }

    public String getUri() throws Exception {
        List values;
        if (this.finalUri != null) {
            return this.finalUri;
        }
        UriBuilderImpl builder = (UriBuilderImpl)this.uri.clone();
        if (this.matrixParameters != null) {
            for (Map.Entry entry : this.matrixParameters.entrySet()) {
                values = (List)entry.getValue();
                for (String value : values) {
                    builder.matrixParam((String)entry.getKey(), value);
                }
            }
        }
        if (this.queryParameters != null) {
            for (Map.Entry entry : this.queryParameters.entrySet()) {
                values = (List)entry.getValue();
                for (String value : values) {
                    builder.clientQueryParam((String)entry.getKey(), value);
                }
            }
        }
        if (this.pathParameterList != null && !this.pathParameterList.isEmpty()) {
            this.finalUri = builder.build(this.pathParameterList.toArray()).toString();
        } else if (this.pathParameters != null && !this.pathParameters.isEmpty()) {
            for (Map.Entry entry : this.pathParameters.entrySet()) {
                values = (List)entry.getValue();
                for (String value : values) {
                    value = Encode.encodePathAsIs(value);
                    builder.substitutePathParam((String)entry.getKey(), value, true);
                }
            }
        }
        if (this.finalUri == null) {
            this.finalUri = builder.build(new Object[0]).toString();
        }
        return this.finalUri;
    }

    public ClientRequest createSubsequentRequest(URI uri) {
        try {
            ClientRequest clone = (ClientRequest)this.clone();
            clone.clear();
            clone.uri = new UriBuilderImpl();
            clone.uri.uri(uri);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("ClientRequest doesn't implement Clonable.  Notify the RESTEasy staff right away.");
        }
    }
}

