/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.interceptors.encoding;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.annotations.interception.ClientInterceptor;
import org.jboss.resteasy.annotations.interception.DecoderPrecedence;
import org.jboss.resteasy.annotations.interception.ServerInterceptor;
import org.jboss.resteasy.spi.interception.MessageBodyReaderContext;
import org.jboss.resteasy.spi.interception.MessageBodyReaderInterceptor;

@Provider
@ServerInterceptor
@ClientInterceptor
@DecoderPrecedence
public class GZIPDecodingInterceptor
implements MessageBodyReaderInterceptor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object read(MessageBodyReaderContext context) throws IOException, WebApplicationException {
        String encoding = context.getHeaders().getFirst("Content-Encoding");
        if (encoding != null && encoding.toString().equalsIgnoreCase("gzip")) {
            InputStream old = context.getInputStream();
            FinishableGZIPInputStream is = new FinishableGZIPInputStream(old);
            context.setInputStream(is);
            try {
                Object object = context.proceed();
                return object;
            }
            finally {
                if (!context.getType().equals(InputStream.class)) {
                    is.finish();
                }
                context.setInputStream(old);
            }
        }
        return context.proceed();
    }

    public static class FinishableGZIPInputStream
    extends GZIPInputStream {
        public FinishableGZIPInputStream(InputStream is) throws IOException {
            super(is);
        }

        public void finish() {
            this.inf.end();
        }
    }
}

