/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.specimpl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.util.LocaleHelper;
import org.jboss.resteasy.util.MediaTypeHelper;
import org.jboss.resteasy.util.WeightedLanguage;

public class HttpHeadersImpl
implements HttpHeaders {
    private MultivaluedMap<String, String> requestHeaders;
    private List<MediaType> acceptableMediaTypes;
    private MediaType mediaType;
    private Locale language;
    private Map<String, Cookie> cookies;
    private List<Locale> acceptableLanguages;

    @Override
    public MultivaluedMap<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    public void setRequestHeaders(MultivaluedMap<String, String> requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    @Override
    public List<MediaType> getAcceptableMediaTypes() {
        return this.acceptableMediaTypes;
    }

    public void setAcceptableMediaTypes(List<MediaType> acceptableMediaTypes) {
        this.acceptableMediaTypes = acceptableMediaTypes;
        if (acceptableMediaTypes != null) {
            MediaTypeHelper.sortByWeight(acceptableMediaTypes);
        }
    }

    @Override
    public MediaType getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    @Override
    public Locale getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        if (language == null) {
            return;
        }
        this.language = LocaleHelper.extractLocale(language);
    }

    public void setAcceptableLanguages(List<String> acceptableLanguages) {
        if (acceptableLanguages == null) {
            this.acceptableLanguages = null;
        } else {
            this.acceptableLanguages = new ArrayList<Locale>(acceptableLanguages.size());
            ArrayList<WeightedLanguage> languages = new ArrayList<WeightedLanguage>(acceptableLanguages.size());
            for (String string : acceptableLanguages) {
                languages.add(WeightedLanguage.parse(string));
            }
            Collections.sort(languages);
            for (WeightedLanguage weightedLanguage : languages) {
                this.acceptableLanguages.add(weightedLanguage.getLocale());
            }
        }
    }

    @Override
    public Map<String, Cookie> getCookies() {
        return this.cookies;
    }

    public void setCookies(Map<String, Cookie> cookies) {
        this.cookies = cookies;
    }

    @Override
    public List<String> getRequestHeader(String name) {
        return (List)this.requestHeaders.get(name);
    }

    @Override
    public List<Locale> getAcceptableLanguages() {
        if (this.acceptableLanguages == null) {
            this.acceptableLanguages = new ArrayList<Locale>();
        }
        return this.acceptableLanguages;
    }
}

