/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.util;

import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.plugins.providers.FormUrlEncodedProvider;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.util.Encode;

public abstract class HttpRequestImpl
implements HttpRequest {
    protected HttpHeaders httpHeaders;
    protected InputStream inputStream;
    protected UriInfo uri;
    protected String httpMethod;
    protected String preProcessedPath;
    protected MultivaluedMap<String, String> formParameters;
    protected MultivaluedMap<String, String> decodedFormParameters;

    public HttpRequestImpl(InputStream inputStream, HttpHeaders httpHeaders, String httpMethod, UriInfo uri) {
        this.inputStream = inputStream;
        this.httpHeaders = httpHeaders;
        this.httpMethod = httpMethod;
        this.uri = uri;
        this.preProcessedPath = uri.getPath(false);
    }

    @Override
    public HttpHeaders getHttpHeaders() {
        return this.httpHeaders;
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public UriInfo getUri() {
        return this.uri;
    }

    @Override
    public String getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public String getPreprocessedPath() {
        return this.preProcessedPath;
    }

    @Override
    public void setPreprocessedPath(String path) {
        this.preProcessedPath = path;
    }

    @Override
    public MultivaluedMap<String, String> getFormParameters() {
        if (this.formParameters != null) {
            return this.formParameters;
        }
        if (this.getHttpHeaders().getMediaType().isCompatible(MediaType.valueOf("application/x-www-form-urlencoded"))) {
            try {
                this.formParameters = FormUrlEncodedProvider.parseForm(this.getInputStream());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new IllegalArgumentException("Request media type is not application/x-www-form-urlencoded");
        }
        return this.formParameters;
    }

    @Override
    public MultivaluedMap<String, String> getDecodedFormParameters() {
        if (this.decodedFormParameters != null) {
            return this.decodedFormParameters;
        }
        this.decodedFormParameters = Encode.decode(this.getFormParameters());
        return this.decodedFormParameters;
    }

    public void suspend() {
        throw new UnsupportedOperationException("UNSUPPORTED OPERATION");
    }

    public void suspend(long timeout) {
        throw new UnsupportedOperationException("UNSUPPORTED OPERATION");
    }

    public void complete() {
        throw new UnsupportedOperationException("UNSUPPORTED OPERATION");
    }

    @Override
    public boolean isInitial() {
        return true;
    }

    @Override
    public boolean isSuspended() {
        return false;
    }

    public boolean isTimeout() {
        return false;
    }
}

