/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import net.sf.okapi.common.IdGenerator;
import org.junit.Assert;
import org.junit.Test;

public class IdGeneratorTest {
    private IdGenerator idGen;

    @Test
    public void testresultNotNull() {
        this.idGen = new IdGenerator("test");
        Assert.assertNotNull(this.idGen.createId());
        Assert.assertNotNull(this.idGen.createId());
    }

    @Test
    public void testresultNotEmpty() {
        this.idGen = new IdGenerator("test");
        Assert.assertTrue(this.idGen.createId().length() > 0);
        Assert.assertTrue(this.idGen.createId().length() > 0);
    }

    @Test
    public void testCreationWithNullRoot() {
        this.idGen = new IdGenerator(null);
        Assert.assertEquals("1", this.idGen.createId());
        Assert.assertEquals("1", this.idGen.getLastId());
    }

    @Test
    public void testCreationWithEmptyRoot() {
        this.idGen = new IdGenerator("");
        Assert.assertEquals("1", this.idGen.createId());
        Assert.assertEquals("1", this.idGen.getLastId());
    }

    @Test
    public void testWithNullPrefix() {
        this.idGen = new IdGenerator("test");
        String id1 = this.idGen.createId();
        this.idGen = new IdGenerator("test", null);
        Assert.assertEquals(id1, this.idGen.createId());
    }

    @Test
    public void testWithEmptyPrefix() {
        this.idGen = new IdGenerator("test");
        String id1 = this.idGen.createId();
        this.idGen = new IdGenerator("test", "");
        Assert.assertEquals(id1, this.idGen.createId());
    }

    @Test
    public void testSameIdForSameRoot() {
        this.idGen = new IdGenerator("test");
        String id1 = this.idGen.createId();
        String id2 = this.idGen.createId();
        this.idGen = new IdGenerator("test");
        Assert.assertTrue(id1.equals(this.idGen.createId()));
        Assert.assertTrue(id2.equals(this.idGen.createId()));
    }

    @Test
    public void testDifferentIdForDifferentRoot() {
        this.idGen = new IdGenerator("test");
        String id1 = this.idGen.createId();
        String id2 = this.idGen.createId();
        this.idGen = new IdGenerator("Test");
        Assert.assertFalse(id1.equals(this.idGen.createId()));
        Assert.assertFalse(id2.equals(this.idGen.createId()));
    }

    @Test
    public void testresultNotNullWithPrefix() {
        this.idGen = new IdGenerator("test", "p");
        Assert.assertNotNull(this.idGen.createId());
        Assert.assertNotNull(this.idGen.createId());
    }

    @Test
    public void testresultNotEmptyWithPrefix() {
        this.idGen = new IdGenerator("test", "p");
        Assert.assertTrue(this.idGen.createId().length() > 0);
        Assert.assertTrue(this.idGen.createId().length() > 0);
    }

    @Test
    public void testSameIdForSameRootAndPrefix() {
        this.idGen = new IdGenerator("test", "p");
        String id1 = this.idGen.createId();
        String id2 = this.idGen.createId();
        this.idGen = new IdGenerator("test", "p");
        Assert.assertTrue(id1.equals(this.idGen.createId()));
        Assert.assertTrue(id2.equals(this.idGen.createId()));
    }

    @Test
    public void testDifferentIdForDifferentRootSamePrefix() {
        this.idGen = new IdGenerator("test", "p");
        String id1 = this.idGen.createId();
        String id2 = this.idGen.createId();
        this.idGen = new IdGenerator("Test", "p");
        Assert.assertFalse(id1.equals(this.idGen.createId()));
        Assert.assertFalse(id2.equals(this.idGen.createId()));
    }

    @Test
    public void testDifferentIdForSameRootDifferentPrefix() {
        this.idGen = new IdGenerator("test", "p");
        String id1 = this.idGen.createId();
        String id2 = this.idGen.createId();
        this.idGen = new IdGenerator("test", "P");
        Assert.assertFalse(id1.equals(this.idGen.createId()));
        Assert.assertFalse(id2.equals(this.idGen.createId()));
    }

    @Test
    public void testDifferentIdForDifferentRootAndPrefix() {
        this.idGen = new IdGenerator("test", "p");
        String id1 = this.idGen.createId();
        String id2 = this.idGen.createId();
        this.idGen = new IdGenerator("Test", "P");
        Assert.assertFalse(id1.equals(this.idGen.createId()));
        Assert.assertFalse(id2.equals(this.idGen.createId()));
    }

    @Test
    public void testCanReproduceValue() {
        this.idGen = new IdGenerator("test", "p");
        String id1 = this.idGen.createId();
        String id2 = this.idGen.createId();
        Assert.assertEquals("P364492-p1", id1);
        Assert.assertEquals("P364492-p2", id2);
        this.idGen = new IdGenerator("test/A/b/C");
        id1 = this.idGen.createId();
        id2 = this.idGen.createId();
        Assert.assertEquals("P269F9F4B-1", id1);
        Assert.assertEquals("P269F9F4B-2", id2);
    }

    @Test
    public void testLastId() {
        this.idGen = new IdGenerator("test", "p");
        String id = this.idGen.createId();
        String bis = null;
        for (int i = 0; i < 10; ++i) {
            bis = this.idGen.getLastId();
        }
        Assert.assertEquals(id, bis);
    }

    @Test
    public void testCreateIdWithPrefix() {
        this.idGen = new IdGenerator(null, "p");
        String id = this.idGen.createId();
        Assert.assertEquals("p1", id);
        id = this.idGen.createId("xyz");
        Assert.assertEquals("xyz2", id);
        id = this.idGen.createId();
        Assert.assertEquals("p3", id);
    }

    @Test
    public void testLastIdWithPrefix() {
        this.idGen = new IdGenerator(null, "p");
        String id = this.idGen.createId("zxc");
        Assert.assertEquals("zxc1", id);
        Assert.assertEquals("zxc1", this.idGen.getLastId());
        Assert.assertEquals("p2", this.idGen.createId());
    }

    @Test
    public void testToString() {
        this.idGen = new IdGenerator("test", "p");
        String id = this.idGen.createId();
        Assert.assertEquals(this.idGen.toString(), this.idGen.getLastId());
        Assert.assertEquals(id, this.idGen.toString());
    }
}

