/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.net.URISyntaxException;
import java.net.URL;
import net.sf.okapi.common.DummyParameters;
import net.sf.okapi.common.ParameterDescriptor;
import net.sf.okapi.common.ParametersDescription;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ParametersTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testDefaults() {
        DummyParameters params = new DummyParameters();
        Assert.assertTrue(params.paramBool1);
        Assert.assertEquals(params.paramInt1, 123L);
        Assert.assertEquals(params.paramStr1, "test");
        Assert.assertEquals(params.password1, "password");
        params.reset();
        Assert.assertTrue(params.paramBool1);
        Assert.assertEquals(params.paramInt1, 123L);
        Assert.assertEquals(params.paramStr1, "test");
        Assert.assertEquals(params.password1, "password");
    }

    @Test
    public void testLoadParametersFromString() {
        String snippet = "#v1\nparamBool1.b=false\nparamInt1.i=456";
        DummyParameters params = new DummyParameters();
        params.fromString(snippet);
        Assert.assertFalse(params.paramBool1);
        Assert.assertEquals(params.paramInt1, 456L);
        Assert.assertEquals(params.paramStr1, "test");
        Assert.assertEquals(params.password1, "password");
    }

    @Test
    public void testWhitespaces() {
        String snippet = "#v1\nparamBool1.b  =  true  \nparamInt1.i  =  456 \nparamStr1  = AB  C  \npassword1=psw";
        DummyParameters params = new DummyParameters();
        params.fromString(snippet);
        Assert.assertTrue(params.paramBool1);
        Assert.assertEquals(params.paramInt1, 456L);
        Assert.assertEquals(params.paramStr1, " AB  C  ");
        Assert.assertEquals(params.password1, "psw");
    }

    @Test
    public void testLoadParametersFromWindowsFile() throws URISyntaxException {
        DummyParameters params = new DummyParameters();
        URL url = ParametersTest.class.getResource("/ParamTest01.txt");
        params.load(url.toURI(), false);
        Assert.assertFalse(params.paramBool1);
        Assert.assertEquals(789L, params.paramInt1);
        Assert.assertEquals(params.paramStr1, "TestOK");
    }

    @Test
    public void testParameterDescriptor() {
        TestClass ts = new TestClass();
        ParameterDescriptor pd = new ParameterDescriptor("text", ts, "displayName", "shortDescription");
        Assert.assertEquals("displayName", pd.getDisplayName());
        Assert.assertEquals("shortDescription", pd.getShortDescription());
        Assert.assertEquals(String.class, pd.getType());
        Assert.assertEquals("text", pd.getName());
        Assert.assertEquals(ts, pd.getParent());
        Assert.assertNotNull(pd.getReadMethod());
        Assert.assertNotNull(pd.getWriteMethod());
    }

    @Test
    public void testParametersDescription() {
        TestClass ts = new TestClass();
        ParametersDescription desc = new ParametersDescription(ts);
        desc.add("text", "displayName", "shortDescription");
        desc.add("flag", "Flag", "A flag");
        ParameterDescriptor pd = desc.get("text");
        Assert.assertEquals(2L, desc.getDescriptors().size());
        Assert.assertEquals(pd, desc.getDescriptors().get("text"));
        pd = desc.get("flag");
        Assert.assertEquals(pd, desc.getDescriptors().get("flag"));
        Assert.assertEquals(Boolean.TYPE, pd.getType());
    }

    @Test
    public void testGetFromName() {
        DummyParameters natParams = new DummyParameters();
        natParams.paramStr1 = "qwerty";
        natParams.paramBool1 = false;
        natParams.paramInt1 = 98765;
        DummyParameters params = natParams;
        Assert.assertEquals("qwerty", params.getString("paramStr1"));
        Assert.assertEquals(false, params.getBoolean("paramBool1"));
        Assert.assertEquals(98765L, params.getInteger("paramInt1"));
    }

    @Test
    public void testSetFromName() {
        DummyParameters natParams = new DummyParameters();
        natParams.paramStr1 = "qwerty";
        natParams.paramBool1 = false;
        natParams.paramInt1 = 98765;
        DummyParameters params = natParams;
        Assert.assertEquals("qwerty", params.getString("paramStr1"));
        Assert.assertEquals(false, params.getBoolean("paramBool1"));
        params.setString("paramStr1", "newValue");
        params.setBoolean("paramBool1", true);
        Assert.assertEquals("newValue", params.getString("paramStr1"));
        Assert.assertEquals(true, params.getBoolean("paramBool1"));
        Assert.assertEquals(98765L, params.getInteger("paramInt1"));
        params.setInteger("paramInt1", 12345678);
        Assert.assertEquals(12345678L, params.getInteger("paramInt1"));
    }

    class TestClass {
        private String text;
        private boolean flag;

        TestClass() {
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public boolean isFlag() {
            return this.flag;
        }

        public void setFlag(boolean flag) {
            this.flag = flag;
        }
    }
}

