/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.EmptyStackException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.TestUtil;
import net.sf.okapi.common.XMLWriter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class XMLWriterTest {
    XMLWriter writer;
    StringWriter sWriter;

    @Before
    public void setUp() {
        this.sWriter = new StringWriter();
        this.writer = new XMLWriter(this.sWriter);
    }

    @Test
    public void constructorWithPath() throws IOException {
        String filename = "target/test-classes/some/dir/to/be/created/some.xml";
        this.writer = new XMLWriter("target/test-classes/some/dir/to/be/created/some.xml");
        File f = new File("target/test-classes/some/dir/to/be/created/some.xml");
        Assert.assertTrue("A file should have been created along with the directory structure", f.exists());
        this.writer.writeStartDocument();
        this.writer.close();
        String xml = TestUtil.getFileAsString(f);
        Assert.assertEquals("writer's contents", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>", xml.trim());
        Assert.assertTrue("Could not delete file " + f.getPath(), f.delete());
    }

    @Test
    public void constructorWithWriter() {
        Assert.assertEquals("writer's contents", "", this.sWriter.toString());
    }

    @Test
    public void writeStartDocument() {
        this.writer.writeStartDocument();
        this.writer.flush();
        Assert.assertEquals("writer's contents", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>", this.sWriter.toString().trim());
    }

    @Test
    public void writeEndDocumentNoStartTag() {
        this.writer.writeStartDocument();
        this.writer.writeEndDocument();
        Assert.assertEquals("writer's contents", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>", this.sWriter.toString().trim());
    }

    @Test
    public void writeStartElement() {
        this.writer.writeStartDocument();
        this.writer.writeStartElement("joe");
        this.writer.flush();
        String xml = this.sWriter.toString().trim();
        xml = xml.replaceAll("\n", "");
        xml = xml.replaceAll("\r", "");
        Assert.assertEquals("writer's contents", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><joe", xml);
    }

    @Test
    public void writeStartElementWithPreviousStartElement() {
        this.writer.writeStartDocument();
        this.writer.writeStartElement("jack");
        this.writer.writeStartElement("diane");
        this.writer.flush();
        String xml = this.sWriter.toString().trim();
        xml = xml.replaceAll("\n", "");
        xml = xml.replaceAll("\r", "");
        Assert.assertEquals("writer's contents", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><jack><diane", xml);
    }

    @Test
    public void writeEndElement() {
        this.writer.writeStartDocument();
        this.writer.writeStartElement("jack");
        this.writer.writeEndElement();
        this.writer.flush();
        String xml = this.sWriter.toString().trim();
        xml = xml.replaceAll("\n", "");
        xml = xml.replaceAll("\r", "");
        Assert.assertEquals("writer's contents", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><jack></jack>", xml);
    }

    @Test(expected=EmptyStackException.class)
    public void writeEndElementNoStartElement() {
        this.writer.writeStartDocument();
        this.writer.writeEndElement();
        String xml = this.sWriter.toString().trim();
        xml = xml.replaceAll("\n", "");
        xml = xml.replaceAll("\r", "");
        Assert.assertEquals("writer's contents", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>", xml);
    }

    @Test
    public void writeEndElementLineBreakStartElement() {
        this.writer.writeStartDocument();
        this.writer.writeStartElement("mary");
        this.writer.writeEndElementLineBreak();
        this.writer.flush();
        String xml = this.sWriter.toString();
        Pattern p = Pattern.compile("<\\?xml version=\"1.0\" encoding=\"UTF-8\"\\?>[\\n\\r]+<mary></mary>[\\r\\n]+", 8);
        Matcher m = p.matcher(xml);
        Assert.assertTrue("New lines were not written", m.matches());
    }

    @Test(expected=EmptyStackException.class)
    public void writeEndElementLineBreakNoStartElement() {
        this.writer.writeStartDocument();
        this.writer.writeEndElementLineBreak();
        String xml = this.sWriter.toString().trim();
        xml = xml.replaceAll("\n", "");
        xml = xml.replaceAll("\r", "");
        Assert.assertEquals("writer's contents", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>", xml);
    }

    @Test
    public void writeLeadingSpaces() {
        this.writer.writeStartElement("w:t");
        this.writer.writeAttributeString("xml:space", "preserve");
        this.writer.writeString(" (");
        this.writer.writeEndElement();
        this.writer.flush();
        Assert.assertEquals("<w:t xml:space=\"preserve\"> (</w:t>", this.sWriter.toString());
    }
}

